# 通知設計書 19-プロジェクト不在通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「プロジェクト不在通知（Project file not found!）」の設計仕様を記述する。

### 本通知の処理概要

この通知は、ジョブ処理を開始する際にプロジェクトファイル（.srip）が存在しない場合に、ユーザーにエラー情報を表示する機能を提供する。

**業務上の目的・背景**：StaxRipではエンコードジョブをプロジェクトファイルとして保存し、バッチ処理やキュー処理で実行する。ジョブ処理を開始する際にプロジェクトファイルが見つからない場合（削除された、移動された、パスが無効など）、処理を継続することは不可能であり、ユーザーにエラーを通知してジョブをスキップする必要がある。

**通知の送信タイミング**：GlobalClass.ProcessJobメソッドにおいて、File.Exists(jobPath)がFalseを返した場合に通知が発生する。具体的にはGlobalClass.vbの行481-482で発生する。

**通知の受信者**：StaxRipアプリケーションを操作している現在のユーザー（エンドユーザー）。g.RunTask()を通じてUIスレッドでモーダルダイアログとして表示される。

**通知内容の概要**：エラーメッセージとして「Project file not found!」というタイトルと、「'{ジョブパス}' could not be found and got skipped!」という詳細メッセージが表示される。

**期待されるアクション**：ユーザーはエラーメッセージを確認し、以下のような対処を行うことが期待される。(1) プロジェクトファイルの場所を確認する、(2) ファイルが削除されていないか確認する、(3) ジョブキューから無効なジョブを削除する、(4) プロジェクトを再作成する。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（UIスレッドで実行） |
| 優先度 | 高（エラー通知） |
| リトライ | 無 |

### 送信先決定ロジック

現在StaxRipアプリケーションを操作しているユーザーに対して、モーダルダイアログとして直接表示される。バックグラウンドスレッドからはg.RunTask()を通じてUIスレッドで表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Project file not found! |
| アイコン | Error |
| ボタン | OK |

### 本文テンプレート

```
'{JobPath}'
could not be found and got skipped!
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| JobPath | プロジェクトファイルのパス | jobPath引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッチ処理 | ジョブ処理開始 | Not File.Exists(jobPath) | プロジェクトファイルが存在しない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| File.Exists(jobPath) = True | プロジェクトファイルが存在する場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GlobalClass.ProcessJob呼び出し] --> B{File.Exists#40;jobPath#41;?}
    B -->|Yes| C[g.RaiseAppEvent#40;BeforeJobProcessed#41;]
    B -->|No| D[g.RunTask#40;MsgError表示#41;]
    D --> E[Exit Sub]
    C --> F[ジョブ処理継続]
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースは使用しない。

### 更新テーブル一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル不在 | プロジェクトファイルが存在しない | MsgError表示、ジョブをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし、ジョブをスキップ） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ジョブ処理に応じて随時表示）

## セキュリティ考慮事項

- ファイルパスがメッセージに含まれるため、ディレクトリ構造が露出する

## 備考

- GlobalClass使用時に発生する
- g.RunTask()を使用してUIスレッドでダイアログを表示する
- Exit Subによりジョブ処理は即座に中断され、次のジョブに移行する
- 類似の通知として「プロジェクトファイル不在警告（No.51）」があるが、こちらはMainFormでの読み込み時に使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ProcessJobメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | ProcessJobメソッド（行479-576付近） |

**主要処理フロー**:
1. **行480**: Try
2. **行481**: If Not File.Exists(jobPath) Then
3. **行482**: **通知発生箇所** - g.RunTask(Sub() MsgError("Project file not found!", ...))
4. **行483**: Exit Sub
5. **行486**: g.RaiseAppEvent(ApplicationEvent.BeforeJobProcessed)
6. 以降、ジョブ処理本体

#### Step 2: RunTaskメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | g.RunTaskメソッド（UIスレッドでアクションを実行） |

**読解のコツ**: ProcessJobはバックグラウンドで実行される可能性があるため、g.RunTask()でUIスレッドに処理を委譲していることを理解する。

### プログラム呼び出し階層図

```
[ジョブキュー処理]
    │
    └─ GlobalClass.ProcessJob(jobPath)
           │
           ├─ [ファイルが存在しない場合]
           │      │
           │      └─ g.RunTask(Sub()
           │                       MsgError("Project file not found!",
           │                                $"'{jobPath}'{BR}could not be found and got skipped!")
           │                   End Sub)
           │             │
           │             └─ Exit Sub
           │
           └─ [ファイルが存在する場合]
                  │
                  └─ g.RaiseAppEvent(ApplicationEvent.BeforeJobProcessed)
                         │
                         └─ [ジョブ処理継続]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

jobPath ─────────────────▶ File.Exists(jobPath)
                               │
                               ├─ [True] ────────────────▶ ジョブ処理継続
                               │
                               └─ [False]
                                      │
                                      ▼
                                   g.RunTask()
                                      │
                                      ▼
                                   MsgError表示
                                   (タイトル: "Project file not found!",
                                    本文: jobPath + "could not be found and got skipped!")
                                      │
                                      ▼
                                   Exit Sub (ジョブスキップ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | グローバルクラス（行482が通知発生箇所） |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgError関数の定義 |
| ProcessingForm.vb | `Source/Forms/ProcessingForm.vb` | ソース | ジョブ処理フォーム |
