# 通知設計書 21-ソースフィルタ未検出警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「ソースフィルタ未検出警告」通知の設計仕様を定義する。この通知は、ビデオ処理時にアクティブなソースフィルタが設定されていない場合にユーザーに警告を表示するものである。

### 本通知の処理概要

この通知は、StaxRipでビデオエンコーディングやスクリプト検証を行う際に、ソースフィルタの設定状態を確認し、必要なフィルタが適用されていない場合にユーザーに警告を発する機能を提供する。

**業務上の目的・背景**：StaxRipでは、ビデオ処理の基盤となるソースフィルタ（AviSynthまたはVapourSynthのソースフィルタ）が必須である。ソースフィルタが設定されていない状態でエンコード処理を開始すると、処理が正常に完了しないため、事前にユーザーに警告を発して設定の確認を促す必要がある。これにより、ユーザーの作業効率を向上させ、無駄な処理時間を削減する。

**通知の送信タイミング**：エンコード処理の事前検証（VerifyRequirements関数）において、スクリプト内のフィルタ一覧を確認した際に、カテゴリが「Source」であるアクティブなフィルタが1つも存在しない場合に発生する。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（操作者）がダイアログボックスを通じて通知を受け取る。

**通知内容の概要**：「No active filter of category 'Source' found.」というメッセージが警告ダイアログとして表示される。ソースフィルタが未設定であることを明確に伝え、ユーザーに設定の確認を促す。

**期待されるアクション**：ユーザーは警告を確認後、フィルタ設定画面（Filters > Filter Setup）を開き、適切なソースフィルタ（例：LWLibavVideoSource、FFVideoSource等）を有効化する必要がある。

## 通知種別

アプリ内通知（TaskDialog警告ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザーに対してモーダルダイアログとして表示される。アプリケーションのメインウィンドウを親ウィンドウとして表示され、ユーザーがOKボタンをクリックするまで他の操作をブロックする。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | No active filter of category 'Source' found. |
| ボタン | OK |

### 本文テンプレート

```
No active filter of category 'Source' found.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | エンコード処理開始時 | p.Script.IsFilterActive("Source") = False | ソースカテゴリのアクティブフィルタが存在しない |
| 画面操作 | スクリプト検証時 | p.Script.IsFilterActive("Source") = False | VerifyRequirements関数内でのチェック |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ソースフィルタが存在する場合 | p.Script.IsFilterActive("Source")がTrueの場合は通知しない |
| p.SourceFile = "" の場合 | ソースファイルが設定されていない場合はこのチェックに到達しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[エンコード処理開始] --> B[VerifyRequirements呼び出し]
    B --> C[パッケージ検証]
    C --> D{ソースフィルタ存在確認}
    D -->|IsFilterActive"Source" = False| E[MsgWarn呼び出し]
    D -->|IsFilterActive"Source" = True| F[検証通過]
    E --> G[警告ダイアログ表示]
    G --> H[ユーザーがOKクリック]
    H --> I[False返却・処理中断]
    F --> J[True返却・処理継続]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。プロジェクトオブジェクト（p）のメモリ上のスクリプト設定を参照する。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | メモリ上のオブジェクトのみ参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | この通知自体がエラー状態を示すものであり、追加のエラー処理はない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- 個人情報は含まれない
- ローカルアプリケーション内での表示のため、暗号化不要
- 認証不要

## 備考

- この警告が表示された場合、ユーザーはFilters > Filter Setupから適切なソースフィルタを選択・有効化する必要がある
- 一般的なソースフィルタには、LWLibavVideoSource、FFVideoSource、LSMASHVideoSourceなどがある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プロジェクトとスクリプトの関係を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Misc.vb | `Source/General/Misc.vb` | ShortcutModule（行18-22）でグローバル変数g, p, sの定義を確認 |
| 1-2 | Project.vb | `Source/General/Project.vb` | Projectクラスの構造、特にScriptプロパティの役割を理解 |

**読解のコツ**: VB.NETのModule構文は静的クラスのように機能し、グローバルスコープでアクセス可能。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | VerifyRequirements関数（行790付近から）がエントリーポイント |

**主要処理フロー**:
1. **行800-806**: Package.Items.Valuesをループしてパッケージの検証を実行
2. **行808**: p.Script.IsFilterActive("Source")でソースフィルタの存在を確認
3. **行809**: MsgWarn("No active filter of category 'Source' found.")で警告表示
4. **行810**: Return Falseで処理中断を通知

#### Step 3: 通知表示ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数の定義（行1245-1255）を確認 |
| 3-2 | General.vb | `Source/General/General.vb` | Msg関数（行1274-1279）でTaskDialogを使用した表示処理 |

**主要処理フロー**:
- **行1245**: MsgWarn(text, content, onlyOnce)のシグネチャ
- **行1250**: Msg(text, content, TaskIcon.Warning, TaskButton.OK)を呼び出し
- **行1275-1279**: TaskDialogを生成してアイコン、タイトル、コンテンツ、ボタンを設定

### プログラム呼び出し階層図

```
MainForm (エンコード開始)
    │
    ├─ g.VerifyRequirements()
    │      │
    │      ├─ Package.Items.Values検証ループ
    │      │
    │      └─ p.Script.IsFilterActive("Source")
    │             │
    │             └─ (False時) MsgWarn()
    │                    │
    │                    └─ Msg(TaskIcon.Warning)
    │                           │
    │                           └─ TaskDialog.Show()
    │
    └─ (VerifyRequirements=False時) 処理中断
```

### データフロー図

```
[入力]               [処理]                    [出力]

p.Script      ───▶ IsFilterActive("Source") ───▶ Boolean
     │
     │ (False時)
     ▼
MsgWarn()     ───▶ TaskDialog表示           ───▶ ユーザーへの警告
     │
     ▼
Return False  ───▶ 呼び出し元               ───▶ 処理中断
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | VerifyRequirements関数の実装、通知発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn/Msg関数の実装、TaskDialog表示処理 |
| Misc.vb | `Source/General/Misc.vb` | ソース | グローバル変数g, p, sの定義 |
| Project.vb | `Source/General/Project.vb` | ソース | Projectクラス、Scriptプロパティの管理 |
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | IsFilterActive関数の実装 |
