# 通知設計書 22-Unicode非対応エラー

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「Unicode非対応エラー」通知の設計仕様を定義する。この通知は、AviSynthエンジン使用時にUnicodeを含むファイル名が指定された場合、Windows 10未満の環境では処理できないことをユーザーに通知するものである。

### 本通知の処理概要

この通知は、AviSynthスクリプトエンジンでビデオ処理を行う際に、ソースファイルのパスにUnicode文字（日本語、中国語等の非ASCII文字）が含まれている場合の互換性問題をユーザーに警告する機能を提供する。

**業務上の目的・背景**：AviSynthは歴史的な経緯により、Windows 10未満の環境ではUnicodeファイル名のサポートが不完全である。ユーザーが日本語ファイル名等を含むソースファイルを使用しようとした場合、処理が失敗する可能性があるため、事前にエラーを通知して代替手段（ファイル名変更またはVapourSynthへの切り替え）を案内する必要がある。

**通知の送信タイミング**：VerifySource関数でソースファイルのパスを検証する際、ファイル名がプロセスエンコーディングと互換性がない（Unicode文字を含む）かつ、現在のスクリプトエンジンがAviSynthの場合に発生する。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（操作者）がダイアログボックスを通じてエラー通知を受け取る。

**通知内容の概要**：「Unicode filenames are not supported by AviSynth unless Windows 10 is used.」というメッセージに加え、ファイル名の変更またはVapourSynthへの切り替え方法が案内される。

**期待されるアクション**：ユーザーは以下のいずれかの対応を行う必要がある：(1) ソースファイル名からUnicode文字を除去してASCII文字のみの名前に変更する、(2) Filters > Filter Setup > VapourSynthからVapourSynthエンジンに切り替える。

## 通知種別

アプリ内通知（TaskDialogエラーダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザーに対してモーダルダイアログとして表示される。エラーアイコンで重要度を示し、コピーボタンでメッセージのコピーが可能。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Error（エラーアイコン） |
| タイトル | Unicode filenames are not supported by AviSynth unless Windows 10 is used. |
| ボタン | OK、Copy |

### 本文テンプレート

```
Unicode filenames are not supported by AviSynth unless Windows 10 is used.

Rename the file or enable VapourSynth:

Filters > Filter Setup > VapourSynth
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ソースファイル読み込み時 | file.IsProcessEncodingCompatible = False AND p.Script.IsAviSynth = True | AviSynth使用時にUnicode文字を含むファイル名 |
| 画面操作 | ソース検証時 | VerifySource関数内でのチェック | ファイルパスの互換性検証 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| VapourSynth使用時 | p.Script.IsAviSynth = Falseの場合は通知しない |
| ASCII文字のみのファイル名 | file.IsProcessEncodingCompatible = Trueの場合は通知しない |
| Windows 10以上の環境 | （注：コード上ではOS判定せず常にチェックを実行） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ソースファイル読み込み] --> B[VerifySource呼び出し]
    B --> C{各ファイルをループ}
    C --> D{Unicode文字を含む?}
    D -->|file.IsProcessEncodingCompatible = False| E{AviSynth使用中?}
    D -->|True| C
    E -->|p.Script.IsAviSynth = True| F[ShowAviSynthUnicodeError呼び出し]
    E -->|False| C
    F --> G[MsgError呼び出し]
    G --> H[エラーダイアログ表示]
    H --> I[Return False・処理中断]
    C -->|ループ完了| J[Return True・処理継続]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ファイルパス文字列のみ参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | この通知自体がエラー状態を示すものである |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- ファイルパス情報がダイアログに含まれる可能性があるが、ローカル表示のみ
- 暗号化不要
- 認証不要

## 備考

- VapourSynthはUnicodeファイル名を完全にサポートしている
- Windows 10以上ではAviSynthでもUnicodeサポートが向上している場合があるが、確実性のためVapourSynth使用を推奨
- この問題は特に日本語、中国語、韓国語などのファイル名で発生しやすい

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ファイルパスの互換性判定メカニズムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StringExtensions | `Source/General/` | IsProcessEncodingCompatible拡張メソッドの実装を確認 |

**読解のコツ**: VB.NETの拡張メソッドはStringクラスに追加機能を提供し、file.IsProcessEncodingCompatibleのように呼び出せる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | VerifySource関数（行817-826）がエントリーポイント |

**主要処理フロー**:
1. **行817**: Function VerifySource(files As IEnumerable(Of String)) As Boolean
2. **行818**: For Each file In files - ファイルリストをループ
3. **行819**: If Not file.IsProcessEncodingCompatible AndAlso p.Script.IsAviSynth Then - 条件判定
4. **行820**: ShowAviSynthUnicodeError() - エラー表示関数呼び出し
5. **行821**: Return False - 処理中断

#### Step 3: エラー表示ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | ShowAviSynthUnicodeError関数（行828-831）を確認 |
| 3-2 | General.vb | `Source/General/General.vb` | MsgError関数の定義（行1222-1241）を確認 |

**主要処理フロー**:
- **行828-830**: MsgError呼び出しでメッセージを構築
- **行829-830**: メッセージに解決方法（VapourSynth切り替え）を含める

### プログラム呼び出し階層図

```
MainForm / 各種処理
    │
    ├─ g.VerifySource(files)
    │      │
    │      ├─ For Each file In files
    │      │      │
    │      │      └─ file.IsProcessEncodingCompatible
    │      │             │
    │      │             └─ (False AND IsAviSynth時)
    │      │                    │
    │      │                    └─ ShowAviSynthUnicodeError()
    │      │                           │
    │      │                           └─ MsgError()
    │      │                                  │
    │      │                                  └─ TaskDialog.Show()
    │      │
    │      └─ Return False
    │
    └─ 処理中断
```

### データフロー図

```
[入力]               [処理]                    [出力]

files (String[]) ───▶ IsProcessEncodingCompatible ───▶ Boolean
     │                        │
     │                        ▼
     │               p.Script.IsAviSynth ───▶ Boolean
     │                        │
     ▼                        ▼
(両方条件満たす時)     ShowAviSynthUnicodeError()
                              │
                              ▼
                       MsgError()  ───▶ ユーザーへのエラー通知
                              │
                              ▼
                       Return False ───▶ 呼び出し元
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | VerifySource関数、ShowAviSynthUnicodeError関数の実装 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の実装、TaskDialog表示処理 |
| Misc.vb | `Source/General/Misc.vb` | ソース | グローバル変数の定義 |
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | IsAviSynthプロパティの実装 |
