# 通知設計書 23-オーディオ再生エラー通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「オーディオ再生エラー通知」の設計仕様を定義する。この通知は、オーディオファイルの再生処理が失敗した場合にユーザーにエラーを通知するものである。

### 本通知の処理概要

この通知は、StaxRipでオーディオプロファイルに関連付けられたオーディオファイルを再生しようとした際に、再生可能な形式ではない場合や再生条件を満たさない場合にエラーを表示する機能を提供する。

**業務上の目的・背景**：StaxRipはビデオエンコーディングソフトウェアであるが、オーディオトラックのプレビュー再生機能を提供している。ユーザーがエンコード前にオーディオを確認したい場合、mpvnetプレイヤーを使用して再生を試みる。しかし、オーディオファイルの形式や状態によっては再生できない場合があり、その際にユーザーに状況を通知する必要がある。

**通知の送信タイミング**：PlayAudio関数でオーディオプロファイルの再生を試みる際、以下のいずれの条件にも該当しない場合に発生する：(1) オーディオRaw形式ファイルである、(2) 元ソースファイルと同一でストリームが存在する、(3) 標準オーディオ形式ファイルである。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（操作者）がダイアログボックスを通じてエラー通知を受け取る。

**通知内容の概要**：「Unable to play audio.」というメッセージがエラーダイアログとして表示される。オーディオファイルが再生できないことを簡潔に伝える。

**期待されるアクション**：ユーザーはオーディオファイルの形式を確認し、必要に応じてオーディオの変換処理を実行するか、別のオーディオファイルを選択する必要がある。

## 通知種別

アプリ内通知（TaskDialogエラーダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザーに対してモーダルダイアログとして表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Error（エラーアイコン） |
| タイトル | Unable to play audio. |
| ボタン | OK、Copy |

### 本文テンプレート

```
Unable to play audio.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | オーディオ再生要求時 | 全ての再生条件に該当しない | PlayAudio関数のElse分岐に到達 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| AudioRaw形式の場合 | FileTypes.AudioRaw.Contains(ap.File.Ext)がTrueの場合は再生を試行 |
| 元ソースファイルでストリームあり | ap.File = p.FirstOriginalSourceFile AndAlso ap.Streams.Count > 0の場合は再生を試行 |
| 標準Audio形式の場合 | FileTypes.Audio.Contains(ap.File.Ext)がTrueの場合は再生を試行 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[PlayAudio呼び出し] --> B{AudioRaw形式?}
    B -->|Yes| C[mpvnetでRaw再生]
    B -->|No| D{元ソース＆ストリームあり?}
    D -->|Yes| E[mpvnetで音声トラック指定再生]
    D -->|No| F{標準Audio形式?}
    F -->|Yes| G[mpvnetでディレイ付き再生]
    F -->|No| H[MsgError呼び出し]
    H --> I[エラーダイアログ表示]
    C --> J[終了]
    E --> J
    G --> J
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | オーディオプロファイルオブジェクトを参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | この通知自体がエラー状態を示すものである |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- 個人情報は含まれない
- ローカルアプリケーション内での表示のため、暗号化不要
- 認証不要

## 備考

- 再生にはmpvnetプレイヤーが使用される
- サポートされるオーディオ形式はFileTypesクラスで定義されている
- AudioRaw形式には、raw PCMデータなどが含まれる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

オーディオプロファイルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AudioProfile.vb | `Source/Audio/` | AudioProfileクラスの構造、Fileプロパティ、Streamsプロパティを確認 |
| 1-2 | FileTypes.vb | `Source/General/` | FileTypes.AudioRaw、FileTypes.Audioの定義を確認 |

**読解のコツ**: AudioProfileはオーディオトラックの設定を保持し、Fileプロパティでオーディオファイルのパスを取得できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | PlayAudio関数（行833-843）がエントリーポイント |

**主要処理フロー**:
1. **行833**: Sub PlayAudio(ap As AudioProfile)
2. **行834**: If FileTypes.AudioRaw.Contains(ap.File.Ext) Then - Raw形式チェック
3. **行835**: g.ShellExecute(Package.mpvnet.Path, ap.File.Escape) - Raw再生
4. **行836**: ElseIf ap.File = p.FirstOriginalSourceFile AndAlso ap.Streams.Count > 0 Then - 元ソースチェック
5. **行837**: g.ShellExecute(...) - 音声トラック指定再生
6. **行838**: ElseIf FileTypes.Audio.Contains(ap.File.Ext) Then - 標準Audio形式チェック
7. **行839**: g.ShellExecute(...) - ディレイ付き再生
8. **行840-841**: Else MsgError("Unable to play audio.") - エラー表示

#### Step 3: 外部プレイヤー呼び出しを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Package.vb | `Source/General/` | Package.mpvnetの定義、Pathプロパティを確認 |
| 3-2 | GlobalClass.vb | `Source/General/GlobalClass.vb` | ShellExecute関数の実装を確認 |

**主要処理フロー**:
- **mpvnet**: StaxRipに同梱されるメディアプレイヤー
- **引数**: --audio, --audio-delay, --audio-filesなどのオプションで再生設定

### プログラム呼び出し階層図

```
MainForm / AudioMenu
    │
    └─ g.PlayAudio(ap)
           │
           ├─ (AudioRaw形式) g.ShellExecute(mpvnet, file)
           │
           ├─ (元ソース＆ストリームあり) g.ShellExecute(mpvnet, --audio=N file)
           │
           ├─ (標準Audio形式) g.ShellExecute(mpvnet, --audio-delay=X --audio-files=Y file)
           │
           └─ (いずれでもない) MsgError("Unable to play audio.")
                  │
                  └─ TaskDialog.Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

ap.File.Ext   ───▶ FileTypes.AudioRaw判定 ───▶ Boolean
     │
     ▼
ap.File       ───▶ p.FirstOriginalSourceFile比較 ───▶ Boolean
ap.Streams.Count
     │
     ▼
ap.File.Ext   ───▶ FileTypes.Audio判定 ───▶ Boolean
     │
     ▼ (全てFalse)
MsgError()    ───▶ TaskDialog表示 ───▶ ユーザーへのエラー通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | PlayAudio関数の実装、通知発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の実装 |
| AudioProfile.vb | `Source/Audio/` | ソース | AudioProfileクラス定義 |
| FileTypes.vb | `Source/General/` | ソース | サポート形式の定義（AudioRaw, Audio） |
| Package.vb | `Source/General/` | ソース | mpvnetパッケージ定義 |
