# 通知設計書 24-一時ディレクトリ作成失敗警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「一時ディレクトリ作成失敗警告」通知の設計仕様を定義する。この通知は、エンコード処理用の一時ディレクトリの作成に失敗した場合にユーザーに警告を表示するものである。

### 本通知の処理概要

この通知は、StaxRipでソースファイルを開いてエンコード処理を開始する際に、作業用の一時ディレクトリを作成しようとした時点で失敗した場合に表示される警告機能を提供する。

**業務上の目的・背景**：StaxRipはビデオエンコーディング処理の過程で、中間ファイルやスクリプトファイルを保存するための一時ディレクトリを必要とする。デフォルトでは、ソースファイルと同じディレクトリに一時フォルダが作成される。しかし、光学ドライブから直接ファイルを開いた場合など、書き込み権限のない場所では一時ディレクトリを作成できないため、ユーザーに状況を説明し、代替手段を案内する必要がある。

**通知の送信タイミング**：ソースファイルオープン処理中にSetupTempDir関数が呼ばれ、Directory.CreateDirectoryで一時ディレクトリの作成を試みた際に例外が発生した場合。最初の試行で失敗した後、ファイル名ベースの代替パスでも作成に失敗した場合に警告が表示される。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（操作者）がダイアログボックスを通じて警告通知を受け取る。

**通知内容の概要**：「Failed to create a temp directory.」というメッセージとともに、一時ディレクトリがソースファイルのディレクトリに作成される仕組みと、光学ドライブからの直接読み込みができない理由、さらにMakeMKV、DVDFab等を使用してディスクをハードドライブにコピーする推奨手順が案内される。

**期待されるアクション**：ユーザーは以下のいずれかの対応を行う必要がある：(1) オプションで一時ディレクトリのパスを明示的に設定する、(2) MakeMKV、DVDFab、Xreveal、AnyDVDなどのツールを使用してディスク内容をハードドライブにコピーしてから処理する。

## 通知種別

アプリ内通知（TaskDialog警告ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザーに対してモーダルダイアログとして表示される。警告表示後はAbortExceptionがスローされ、処理が中断される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | Failed to create a temp directory. |
| ボタン | OK |

### 本文テンプレート

```
Failed to create a temp directory. By default it's created in the directory of the source file so it's not possible to open files directly from an optical drive unless a temp directory is defined in the options. Usually discs are copied to the hard drive first using an application like MakeMKV, DVDFab, Xreveal or AnyDVD.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ソースファイルオープン時 | Directory.CreateDirectoryで例外発生 | 一時ディレクトリ作成失敗 |
| 画面操作 | 一時ディレクトリ設定時 | SetupTempDir関数内のCatch分岐 | 代替パスでも作成失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ディレクトリが既に存在する場合 | Directory.Exists(p.TempDir) = Trueの場合は作成不要 |
| 最初の試行で成功した場合 | 例外が発生しなければ警告なし |
| 代替パスで成功した場合 | 2回目の試行で成功すれば警告なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SetupTempDir呼び出し] --> B{p.TempDir存在?}
    B -->|Yes| C[終了]
    B -->|No| D[Directory.CreateDirectory試行]
    D -->|成功| C
    D -->|例外発生| E[代替パス設定]
    E --> F{代替パス存在?}
    F -->|Yes| C
    F -->|No| G[Directory.CreateDirectory再試行]
    G -->|成功| C
    G -->|例外発生| H[MsgWarn呼び出し]
    H --> I[警告ダイアログ表示]
    I --> J[Throw AbortException]
    J --> K[処理中断]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ファイルシステム操作のみ |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ディレクトリ作成例外 | 書き込み権限なし、パス無効等 | MsgWarn表示後、AbortException |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 1（代替パスで再試行） |
| リトライ間隔 | 即時 |
| リトライ対象エラー | Directory.CreateDirectory例外 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- ファイルシステムパス情報がメッセージに含まれない（一般的な説明のみ）
- ローカルアプリケーション内での表示のため、暗号化不要
- 認証不要

## 備考

- 光学ドライブからの直接処理は非推奨
- MakeMKV、DVDFab、Xreveal、AnyDVDなどのリッピングツールの使用を推奨
- オプション画面で一時ディレクトリを明示的に設定することで問題を回避可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロジェクトの一時ディレクトリ設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | TempDirプロパティの定義と用途を確認 |

**読解のコツ**: p.TempDirはProjectクラスのプロパティで、エンコード処理中の作業ファイルの保存先パスを保持する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | SetupTempDir関数（行1350付近）がエントリーポイント |

**主要処理フロー**:
1. **行1350**: If Not Directory.Exists(p.TempDir) Then - 存在確認
2. **行1351-1352**: Try Directory.CreateDirectory(p.TempDir) - 最初の試行
3. **行1353-1356**: Catch - 例外時の代替パス設定
4. **行1357-1358**: If Not Directory.Exists(p.TempDir) Then Directory.CreateDirectory - 再試行
5. **行1360-1366**: Catch MsgWarn(...) Throw New AbortException - 警告表示と中断

#### Step 3: 例外処理とAbortExceptionを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbortException.vb | `Source/General/` | AbortExceptionクラスの定義を確認 |

**主要処理フロー**:
- **AbortException**: 処理の意図的な中断を示すカスタム例外
- 上位の処理でキャッチされ、適切にクリーンアップが行われる

### プログラム呼び出し階層図

```
MainForm / OpenSourceFile
    │
    └─ g.SetupTempDir()
           │
           ├─ Directory.Exists(p.TempDir)
           │      │
           │      └─ (False時) Directory.CreateDirectory(p.TempDir)
           │             │
           │             ├─ (成功) 終了
           │             │
           │             └─ (例外) 代替パス設定
           │                    │
           │                    └─ Directory.CreateDirectory(代替パス)
           │                           │
           │                           ├─ (成功) 終了
           │                           │
           │                           └─ (例外) MsgWarn()
           │                                  │
           │                                  └─ Throw AbortException
           │
           └─ (True時) 終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

p.TempDir     ───▶ Directory.Exists判定    ───▶ Boolean
     │
     │ (False時)
     ▼
p.TempDir     ───▶ Directory.CreateDirectory ───▶ 例外発生?
     │
     │ (例外時)
     ▼
代替パス      ───▶ Directory.CreateDirectory ───▶ 例外発生?
     │
     │ (例外時)
     ▼
MsgWarn()     ───▶ TaskDialog表示           ───▶ ユーザーへの警告
     │
     ▼
AbortException───▶ 上位処理                 ───▶ 処理中断
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | SetupTempDir関数の実装、通知発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の実装 |
| Project.vb | `Source/General/Project.vb` | ソース | TempDirプロパティの定義 |
| AbortException.vb | `Source/General/` | ソース | 処理中断用例外クラス |
