# 通知設計書 26-ソース読込失敗警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「ソース読込失敗警告」通知の設計仕様を定義する。この通知は、ソースファイルの読み込み処理が失敗した場合（フレーム数が0の場合）にユーザーに警告を表示するものである。

### 本通知の処理概要

この通知は、StaxRipでソーススクリプトを同期化した後、ソースファイルから有効なフレームが取得できなかった場合に表示される警告機能を提供する。

**業務上の目的・背景**：StaxRipはビデオエンコーディングソフトウェアであり、ソースファイルからフレームを読み込んで処理する。ソーススクリプト（AviSynthまたはVapourSynth）がソースファイルを正常に読み込めない場合、フレーム数が0として検出される。この状態ではエンコード処理を継続できないため、ユーザーに早期に問題を通知し、ソースファイルやスクリプト設定の確認を促す必要がある。

**通知の送信タイミング**：IsValidSource関数でソーススクリプトの検証を行う際、p.SourceScript.Synchronize後にp.SourceScript.Info.FrameCount = 0の場合、かつwarnパラメータがTrueの場合に発生する。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（操作者）がダイアログボックスを通じて警告通知を受け取る。

**通知内容の概要**：「Failed to load source.」というメッセージが警告ダイアログとして表示される。ソースの読み込みに失敗したことを簡潔に伝える。

**期待されるアクション**：ユーザーは以下の確認を行う必要がある：(1) ソースファイルが破損していないか確認する、(2) ソースフィルタが正しく設定されているか確認する、(3) 必要なコーデックやプラグインがインストールされているか確認する、(4) ファイルパスに問題がないか確認する。

## 通知種別

アプリ内通知（TaskDialog警告ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザーに対してモーダルダイアログとして表示される。警告表示後、関数はFalseを返し、呼び出し元で処理が中断される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | Failed to load source. |
| ボタン | OK |

### 本文テンプレート

```
Failed to load source.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ソース検証時 | p.SourceScript.Info.FrameCount = 0 AND warn = True | フレーム数が0で警告有効 |
| 画面操作 | スクリプト同期後 | IsValidSource関数内でのチェック | ソーススクリプト検証 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| フレーム数が1以上の場合 | p.SourceScript.Info.FrameCount > 0の場合は通知しない |
| warnパラメータがFalseの場合 | 警告を抑制するオプションが指定された場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[IsValidSource呼び出し] --> B[p.SourceScript.Synchronize]
    B --> C{FrameCount = 0?}
    C -->|Yes| D{warn = True?}
    C -->|No| E[スクリプトエラーチェック]
    D -->|Yes| F[MsgWarn呼び出し]
    D -->|No| G[Return False]
    F --> H[警告ダイアログ表示]
    H --> G
    E --> I{Script.Error <> ""?}
    I -->|Yes| J[MsgError表示]
    I -->|No| K[Return True]
    J --> L[Return False]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ソーススクリプトオブジェクトのみ参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| スクリプトエラー | p.SourceScript.Error <> "" | MsgErrorで別途表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- 個人情報は含まれない
- ローカルアプリケーション内での表示のため、暗号化不要
- 認証不要

## 備考

- フレーム数0は、ソースファイルが読み込めなかったか、スクリプトに問題がある場合に発生する
- スクリプト自体にエラーがある場合は、別途MsgErrorで詳細なエラー内容が表示される
- ソースフィルタの設定、必要なプラグイン、コーデックを確認することが推奨される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ソーススクリプトとスクリプト情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | VideoScriptクラス、Infoプロパティ、FrameCountプロパティを確認 |
| 1-2 | Project.vb | `Source/General/Project.vb` | SourceScriptプロパティの定義を確認 |

**読解のコツ**: p.SourceScriptはProjectクラスのプロパティで、現在のソース読み込み用スクリプトを保持する。Synchronize()でスクリプトを実行し、Info.FrameCountで読み込まれたフレーム数を取得する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | IsValidSource関数（行1422-1439）がエントリーポイント |

**主要処理フロー**:
1. **行1422**: Function IsValidSource(Optional warn As Boolean = True) As Boolean
2. **行1423**: p.SourceScript.Synchronize(False, False) - スクリプト同期
3. **行1425**: If p.SourceScript.Info.FrameCount = 0 Then - フレーム数チェック
4. **行1426**: If warn Then - 警告フラグチェック
5. **行1427**: MsgWarn("Failed to load source.") - 警告表示
6. **行1430**: Return False - 処理中断
7. **行1433-1436**: スクリプトエラーチェックと表示

#### Step 3: スクリプト同期処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | Synchronize関数の実装を確認 |

**主要処理フロー**:
- **Synchronize**: スクリプトファイルを書き出し、フレームサーバーを通じてフレーム情報を取得する

### プログラム呼び出し階層図

```
MainForm / 各種処理
    │
    └─ g.IsValidSource(warn)
           │
           ├─ p.SourceScript.Synchronize(False, False)
           │      │
           │      └─ スクリプト実行・フレーム情報取得
           │
           ├─ (FrameCount = 0 AND warn) MsgWarn()
           │      │
           │      └─ TaskDialog.Show()
           │
           ├─ (FrameCount = 0) Return False
           │
           ├─ (Script.Error <> "") MsgError()
           │      │
           │      └─ Return False
           │
           └─ Return True
```

### データフロー図

```
[入力]               [処理]                    [出力]

warn (Boolean) ───▶ パラメータ受け取り

p.SourceScript ───▶ Synchronize()           ───▶ フレーム情報更新
     │
     ▼
Info.FrameCount───▶ = 0 判定               ───▶ Boolean
     │
     │ (True AND warn時)
     ▼
MsgWarn()      ───▶ TaskDialog表示         ───▶ ユーザーへの警告
     │
     ▼
Return False   ───▶ 呼び出し元             ───▶ 処理中断
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | IsValidSource関数の実装、通知発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の実装 |
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | VideoScriptクラス、Synchronize関数 |
| Project.vb | `Source/General/Project.vb` | ソース | SourceScriptプロパティの定義 |
