# 通知設計書 28-オプション未検出エラー

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「オプション未検出エラー」通知の設計仕様を定義する。この通知は、エンコーダのヘルプ表示機能で指定されたオプションがヘルプテキスト内に見つからない場合にユーザーにエラーを表示するものである。

### 本通知の処理概要

この通知は、StaxRipでビデオエンコーダ（x264、x265、SVT-AV1など）のコマンドラインオプションに関するヘルプを表示する際に、指定されたオプション名がエンコーダのヘルプ出力内に存在しない場合に表示されるエラー機能を提供する。

**業務上の目的・背景**：StaxRipは多数のビデオエンコーダをサポートしており、それぞれのエンコーダには多くのコマンドラインオプションが存在する。ユーザーがオプションのヘルプを参照しようとした際、そのオプションがエンコーダのヘルプドキュメントに記載されていない場合（非公開オプション、廃止されたオプション、タイプミスなど）、適切なエラーメッセージを表示してユーザーに状況を通知する必要がある。

**通知の送信タイミング**：VideoEncoderCommandLineクラスのShowHelp関数で、エンコーダのヘルプテキスト（--helpオプションの出力）内を検索し、指定されたオプション文字列が見つからない場合に発生する。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（操作者）がダイアログボックスを通じてエラー通知を受け取る。

**通知内容の概要**：「{オプション名} not found」というタイトルと、「This option is either undocumented or deprecated.」という本文がエラーダイアログとして表示される。

**期待されるアクション**：ユーザーは以下の確認を行う必要がある：(1) オプション名のスペルが正しいか確認する、(2) 使用しているエンコーダのバージョンでそのオプションがサポートされているか確認する、(3) エンコーダの公式ドキュメントを参照する。

## 通知種別

アプリ内通知（TaskDialogエラーダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザーに対してモーダルダイアログとして表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Error（エラーアイコン） |
| タイトル | {opt} not found |
| 本文 | This option is either undocumented or deprecated. |
| ボタン | OK、Copy |

### 本文テンプレート

```
{opt} not found

This option is either undocumented or deprecated.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| opt | 検索されたオプション名 | ShowHelp関数の引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | オプションヘルプ表示要求時 | find = ""（オプションが見つからない） | ヘルプテキスト内にオプションが存在しない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| オプションが見つかった場合 | find <> ""の場合はヘルプを正常表示 |
| ヘルプコンテンツが取得できない場合 | contentが空の場合は別処理 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ShowHelp呼び出し] --> B[エンコーダヘルプ取得]
    B --> C[content = GetHelpContent]
    C --> D{opt文字列を検索}
    D -->|", opt " 形式で発見| E[find = ", opt "]
    D -->|"  opt " 形式で発見| F[find = "  opt "]
    D -->|"opt " 形式で発見| G[find = "opt "]
    D -->|"opt" 形式で発見| H[find = "opt"]
    D -->|見つからない| I{find = ""?}
    E --> J[g.ShowCode - ヘルプ表示]
    F --> J
    G --> J
    H --> J
    I -->|Yes| K[MsgError呼び出し]
    K --> L[エラーダイアログ表示]
    L --> M[Exit Sub]
    J --> N[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | エンコーダのヘルプ出力のみ参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| オプション未検出 | find = "" | MsgErrorで通知、Exit Sub |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- オプション名のみがメッセージに含まれる
- ローカルアプリケーション内での表示のため、暗号化不要
- 認証不要

## 備考

- 複数の検索パターンで段階的にオプションを検索する
  - ", {opt} " - カンマ区切りの形式
  - "  {opt} " - ダブルスペースの形式
  - "{opt} " - 通常の形式
  - "{opt}" - 最小の形式
- 非公開オプション（ドキュメントに記載されていないがコード上は存在するオプション）の場合にこのエラーが発生する可能性がある
- エンコーダのバージョンアップにより廃止されたオプションでも発生する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

VideoEncoderCommandLineクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoEncoderCommandLine.vb | `Source/Video/VideoEncoderCommandLine.vb` | VideoEncoderCommandLineクラスの基本構造を確認 |

**読解のコツ**: このクラスはエンコーダのコマンドライン設定を管理し、ヘルプ表示機能も提供する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VideoEncoderCommandLine.vb | `Source/Video/VideoEncoderCommandLine.vb` | ShowHelp関数（行83-110付近）がエントリーポイント |

**主要処理フロー**:
1. **行83-87**: opt取得とnullチェック
2. **行89-94**: content取得とnullチェック
3. **行95-101**: オプション検索（4つのパターンで段階的に検索）
4. **行104-106**: If find = "" Then MsgError - 見つからない場合のエラー表示
5. **行109**: g.ShowCode - ヘルプ表示

#### Step 3: オプション検索ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoEncoderCommandLine.vb | `Source/Video/VideoEncoderCommandLine.vb` | 検索パターンの実装（行95-101） |

**主要処理フロー**:
- **行95**: If content.Contains(",  " + opt + " ") - カンマ区切り形式
- **行96**: ElseIf content.Contains("  " + opt + " ") - ダブルスペース形式
- **行98**: ElseIf content.Contains(opt + " ") - 通常形式
- **行100**: ElseIf content.Contains(opt) - 最小形式

### プログラム呼び出し階層図

```
CommandLineForm / オプションヘルプボタン
    │
    └─ params.ShowHelp(opt)
           │
           ├─ GetHelpOption(options) - オプション取得
           │
           ├─ content = GetHelpContent() - ヘルプテキスト取得
           │
           ├─ content.Contains検索（4パターン）
           │      │
           │      ├─ (見つかる) find = 検索パターン
           │      │
           │      └─ (見つからない) find = ""
           │
           ├─ (find = "") MsgError($"{opt} not found", ...)
           │      │
           │      └─ TaskDialog.Show()
           │             │
           │             └─ Exit Sub
           │
           └─ g.ShowCode(package.Name + " Help", content, find)
```

### データフロー図

```
[入力]               [処理]                    [出力]

opt (String)   ───▶ GetHelpOption取得        ───▶ オプション名確定
     │
     ▼
content        ───▶ GetHelpContent()         ───▶ ヘルプテキスト
     │
     ▼
content.Contains───▶ パターン検索（4段階）   ───▶ find (String)
     │
     │ (find = "" 時)
     ▼
MsgError()     ───▶ TaskDialog表示          ───▶ ユーザーへのエラー通知
     │
     ▼
Exit Sub       ───▶ 処理終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VideoEncoderCommandLine.vb | `Source/Video/VideoEncoderCommandLine.vb` | ソース | ShowHelp関数の実装、通知発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の実装 |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | ShowCode関数（ヘルプ表示） |
| Package.vb | `Source/General/Package.vb` | ソース | エンコーダパッケージ定義 |
