# 通知設計書 29-チャプターファイル未検出通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「チャプターファイル未検出通知」の設計仕様を定義する。この通知は、プレビュー画面でチャプター移動機能を使用しようとした際に、チャプターファイルが見つからない場合にユーザーにエラーを表示するものである。

### 本通知の処理概要

この通知は、StaxRipのプレビューフォーム（PreviewForm）でチャプターへの移動機能（GoToChapter）を使用する際に、チャプター情報ファイルが存在しない場合に表示されるエラー機能を提供する。

**業務上の目的・背景**：ビデオファイル、特にDVDやBlu-rayからリッピングされた動画には、チャプター情報が含まれていることがある。StaxRipはソースファイルからチャプター情報を抽出し、テキストファイル（{ソースファイル名}_chapters.txt）として一時ディレクトリに保存する。プレビュー画面でユーザーがチャプターを選択して移動する機能を使用する際、このチャプターファイルが存在しない場合（ソースにチャプター情報がない、抽出に失敗した等）、ユーザーにエラーを通知する必要がある。

**通知の送信タイミング**：PreviewFormのGoToChapter関数で、チャプターファイルパス（{p.TempDir}\{p.SourceFile.Base}_chapters.txt）の存在を確認し、File.Exists(fp)がFalseの場合に発生する。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（操作者）がダイアログボックスを通じてエラー通知を受け取る。

**通知内容の概要**：「No chapter file found.」というメッセージがエラーダイアログとして表示される。チャプターファイルが見つからないことを簡潔に伝える。

**期待されるアクション**：ユーザーは以下の確認を行う必要がある：(1) ソースファイルにチャプター情報が含まれているか確認する、(2) ソースファイルを再度読み込んでチャプター抽出を試みる、(3) チャプター情報なしで作業を継続する。

## 通知種別

アプリ内通知（TaskDialogエラーダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザー（プレビューフォームを表示中）に対してモーダルダイアログとして表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Error（エラーアイコン） |
| タイトル | No chapter file found. |
| ボタン | OK、Copy |

### 本文テンプレート

```
No chapter file found.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | GoToChapter実行時 | File.Exists(fp) = False | チャプターファイルが存在しない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| チャプターファイルが存在する場合 | File.Exists(fp) = Trueの場合はチャプター選択ダイアログを表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GoToChapter呼び出し] --> B[チャプターファイルパス構築]
    B --> C[fp = Path.Combine p.TempDir + _chapters.txt]
    C --> D{File.Exists fp?}
    D -->|No| E[MsgError呼び出し]
    D -->|Yes| F[チャプター読み込み]
    E --> G[エラーダイアログ表示]
    G --> H[Exit Sub]
    F --> I[TaskDialog チャプター選択]
    I --> J{選択された?}
    J -->|Yes| K[SetPos - 位置移動]
    J -->|No| L[終了]
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ファイルシステムのみ参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル未検出 | File.Exists(fp) = False | MsgErrorで通知、Exit Sub |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- 個人情報は含まれない
- ファイルパス情報はメッセージに含まれない
- ローカルアプリケーション内での表示のため、暗号化不要
- 認証不要

## 備考

- チャプターファイルの形式：{ソースファイル名}_chapters.txt
- チャプターファイルの保存先：p.TempDir（一時ディレクトリ）
- チャプターファイルはソースファイル読み込み時にmkvextract等で抽出される
- DVDやBlu-rayからリッピングしたMKVファイルにはチャプター情報が含まれることが多い
- チャプターファイルの内容例：CHAPTER01=00:00:00.000形式

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

チャプターファイルの構造とパス構築を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | TempDir、SourceFile.Baseプロパティの定義を確認 |

**読解のコツ**: チャプターファイルパスは p.TempDir + p.SourceFile.Base + "_chapters.txt" で構築される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PreviewForm.vb | `Source/Forms/PreviewForm.vb` | GoToChapter関数（行952-976）がエントリーポイント |

**主要処理フロー**:
1. **行952**: <Command("Shows a dialog to navigate to a chapter.")> - コマンド属性
2. **行953**: Sub GoToChapter() - 関数定義
3. **行954**: Dim fp = Path.Combine(p.TempDir, p.SourceFile.Base + "_chapters.txt") - パス構築
4. **行956**: If Not File.Exists(fp) Then - 存在確認
5. **行957**: MsgError("No chapter file found.") - エラー表示
6. **行958**: Exit Sub - 処理終了
7. **行961-976**: チャプター選択ダイアログと位置移動処理

#### Step 3: チャプター選択UIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PreviewForm.vb | `Source/Forms/PreviewForm.vb` | TaskDialogでのチャプター選択実装（行961-975） |

**主要処理フロー**:
- **行961-962**: TaskDialog生成、タイトル設定
- **行964-969**: チャプターファイル読み込みとコマンド追加
- **行972-973**: 選択時の位置移動（TimeSpan.Parse → フレーム位置計算）

### プログラム呼び出し階層図

```
PreviewForm / メニュー・ショートカット
    │
    └─ GoToChapter()
           │
           ├─ fp = Path.Combine(p.TempDir, p.SourceFile.Base + "_chapters.txt")
           │
           ├─ File.Exists(fp)
           │      │
           │      ├─ (False) MsgError("No chapter file found.")
           │      │      │
           │      │      └─ TaskDialog.Show()
           │      │             │
           │      │             └─ Exit Sub
           │      │
           │      └─ (True) File.ReadAllLines(fp)
           │             │
           │             └─ TaskDialog - チャプター選択
           │                    │
           │                    └─ SetPos(フレーム位置)
           │
           └─ 終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

p.TempDir      ───▶ Path.Combine             ───▶ fp (チャプターファイルパス)
p.SourceFile.Base
     │
     ▼
fp             ───▶ File.Exists判定          ───▶ Boolean
     │
     │ (False時)
     ▼
MsgError()     ───▶ TaskDialog表示          ───▶ ユーザーへのエラー通知
     │
     ▼
Exit Sub       ───▶ 処理終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PreviewForm.vb | `Source/Forms/PreviewForm.vb` | ソース | GoToChapter関数の実装、通知発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の実装 |
| Project.vb | `Source/General/Project.vb` | ソース | TempDir、SourceFileプロパティの定義 |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | チャプター抽出処理の呼び出し元 |
