# 通知設計書 3-MsgWarn

## 概要

本ドキュメントは、StaxRipアプリケーションにおける警告メッセージ通知「MsgWarn」の設計仕様を定義する。MsgWarnは、ユーザーに注意を促す必要がある状況を伝達するためのタスクダイアログベースの通知機能であり、onlyOnceフラグによる重複表示抑制機能を備えている。

### 本通知の処理概要

MsgWarn通知は、エラーほど深刻ではないが、ユーザーが認識すべき警告状態を伝達するための通知メカニズムである。

**業務上の目的・背景**：処理中の注意事項、非推奨機能の使用、潜在的な問題などをユーザーに警告し、適切な対応を促すために必要である。onlyOnceフラグにより、同じ警告が繰り返し表示されることを防ぎ、ユーザー体験を向上させる。例えば、互換性の問題、設定の不整合、廃止予定機能の使用警告などで使用される。

**通知の送信タイミング**：警告が必要な状況が検出された瞬間に同期的に表示される。onlyOnce = Trueの場合、同一メッセージは1回のみ表示され、2回目以降はスキップされる。

**通知の受信者**：現在アプリケーションを操作しているユーザー。タスクダイアログはモーダルダイアログとして表示される。

**通知内容の概要**：警告タイトルとオプションの警告詳細（content）で構成される。Warningアイコン（黄色い三角形の注意マーク）が表示され、OKボタンのみが配置される。

**期待されるアクション**：ユーザーは警告内容を確認し、OKボタンをクリックしてダイアログを閉じる。警告の内容に応じて、設定変更や操作方法の見直しを検討する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

現在のフォアグラウンドウィンドウのオーナーとして表示される。onlyOnceフラグがTrueの場合、過去に表示されたメッセージと照合し、重複を抑制する。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内通知のため）

### 本文テンプレート

```
[タイトル]
{text パラメータの値}

[コンテンツ]（オプション）
{content パラメータの値}

[アイコン]
Warning（黄色い三角形の警告アイコン）

[ボタン]
OK
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| text | 警告のタイトルテキスト | 呼び出し元から渡されるString型 | Yes |
| content | 警告の詳細テキスト | 呼び出し元から渡されるString型 | No |
| onlyOnce | 重複表示を抑制するフラグ | 呼び出し元から渡されるBoolean型（デフォルトFalse） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | MsgWarn関数の呼び出し | onlyOnceがFalseまたは初回表示 | コード内でMsgWarn()が呼び出された時点で表示 |
| 画面操作 | コマンド重複検出 | 同名コマンド存在時 | CommandManager.AddCommandで"Command 'X' already exists."を表示 |
| 画面操作 | 入力値エラー | 無効な入力時 | ExtenderProviders等で"X is no valid input."を表示 |
| 画面操作 | フォント未検出 | 正しいフォントがない場合 | ImageUtils等で"Correct font was not found..."を表示 |
| 画面操作 | 各種システム警告 | 各機能のエラー/警告発生時 | 多数の箇所で様々な警告メッセージを表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| onlyOnce = True かつ 表示済み | 同一メッセージ（text + content）が既にShownMessagesに記録されている場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MsgWarn呼び出し] --> B{onlyOnce = True?}
    B -->|No| E[Msg関数呼び出し]
    B -->|Yes| C{ShownMessages.Contains?}
    C -->|Yes| D[処理終了/スキップ]
    C -->|No| E
    E --> F[TaskDialogインスタンス生成]
    F --> G[Icon = TaskIcon.Warning設定]
    G --> H[Title/Content設定]
    H --> I[Buttons = TaskButton.OK設定]
    I --> J[Show呼び出し]
    J --> K[ダイアログ表示]
    K --> L{ユーザー操作}
    L -->|OK| M[ダイアログクローズ]
    M --> N{onlyOnce = True?}
    N -->|Yes| O[ShownMessagesに記録]
    N -->|No| P[終了]
    O --> P
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（MsgWarnはデータベースを参照しない）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

#### 送信ログテーブル

該当なし（MsgWarnは送信ログを記録しないが、ShownMessages変数でメモリ内追跡を行う）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 表示失敗 | ウィンドウハンドル取得失敗 | スクリーン中央に表示 |
| パラメータエラー | textがnullまたは空 | そのまま空の状態で表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（onlyOnceによる論理的な制限のみ） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（アプリケーション動作中は常に表示可能）

## セキュリティ考慮事項

- 警告メッセージに機密情報が含まれないよう、呼び出し元での配慮が必要
- ShownMessagesはプライベートな静的変数として管理され、外部からアクセスできない

## 備考

- MsgWarnはMainModuleに定義されたグローバル関数
- ShownMessagesは静的変数として保持され、アプリケーション再起動でリセットされる
- onlyOnceフラグは、繰り返し発生する警告（ループ処理内など）での使用に有効

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MsgWarnの重複抑制で使用されるShownMessages変数と、TaskIcon.Warning列挙型を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | ShownMessages変数（行1243）、Private Sharedとして定義 |
| 1-2 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | TaskIcon列挙型のWarning値（行580-587） |

**読解のコツ**: ShownMessagesはStringとして定義され、表示されたメッセージを連結して保持する。Contains()で既存メッセージをチェックする。

#### Step 2: エントリーポイントを理解する

MsgWarn関数の定義と、onlyOnceフラグによる重複抑制ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | General.vb | `Source/General/General.vb` | MsgWarn関数の定義（行1245-1255） |

**主要処理フロー**:
1. **行1245**: MsgWarn関数シグネチャ（text, content, onlyOnce）
2. **行1246-1248**: onlyOnceがTrueかつ表示済みの場合は早期リターン
3. **行1250**: Msg関数呼び出し（TaskIcon.Warning, TaskButton.OK）
4. **行1252-1254**: onlyOnceがTrueの場合、ShownMessagesに記録

#### Step 3: 使用例を理解する

MsgWarnが実際に呼び出される箇所を確認し、警告通知のパターンを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | CommandManager.AddCommand（行1105-1109）でのMsgWarn使用 |
| 3-2 | ExtenderProviders.vb | `Source/UI/ExtenderProviders.vb` | 入力値検証でのMsgWarn使用 |

**主要処理フロー**:
- **行1105-1109**: コマンド重複時の警告例
- ExtenderProviders: 無効な入力値時の警告例

### プログラム呼び出し階層図

```
MsgWarn(text, content, onlyOnce)  [General.vb:1245]
    |
    +-- (onlyOnce = True かつ 表示済み) ───> 早期リターン
    |
    +-- Msg(text, content, TaskIcon.Warning, TaskButton.OK)  [General.vb:1274]
    |      |
    |      +-- New TaskDialog(Of DialogResult)()  [TaskDialog.vb:8]
    |      |
    |      +-- TaskDialog.Icon = TaskIcon.Warning
    |      |
    |      +-- TaskDialog.Show()  [TaskDialog.vb:552]
    |             |
    |             +-- TaskDialog.Init()  [TaskDialog.vb:43]
    |             |      |
    |             |      +-- StockIcon.GetImage(Warning)  [TaskDialog.vb:83]
    |             |
    |             +-- ShowDialog()  [TaskDialog.vb:557]
    |
    +-- (onlyOnce = True) ───> ShownMessages += text + content
```

### データフロー図

```
[入力]               [処理]                    [出力]

text (String) ─────> 重複チェック ────────> TaskDialog.Title設定
                          |
content (String) ───> 重複チェック ────────> TaskDialog.Content設定
                          |
onlyOnce (Boolean) ─> 条件分岐 ────────────> スキップ or 続行
                          |
TaskIcon.Warning ───> Icon設定 ────────────> pbIcon.Image設定
                          |
                    ShowDialog() ──────────> [画面表示]
                          |
                    (onlyOnce = True)
                          |
                    ShownMessages += ──────> メモリ記録
                    (text + content)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数/ShownMessages変数の定義（MainModule内） |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | TaskDialog(Of T)クラス、TaskIcon.Warning列挙型の定義 |
| StockIcon.vb | `Source/UI/StockIcon.vb` | ソース | Warningアイコン取得ユーティリティ |
| ExtenderProviders.vb | `Source/UI/ExtenderProviders.vb` | ソース | MsgWarnの使用例（入力値検証） |
| ImageUtils.vb | `Source/UI/ImageUtils.vb` | ソース | MsgWarnの使用例（フォント警告） |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | MsgWarnの使用例（ソース読込失敗等） |
