# 通知設計書 30-アシスタント指示通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「アシスタント指示通知」の設計仕様を定義する。この通知は、プレビューフォームで特定の操作を行う際に、メインダイアログのアシスタントメッセージを先に確認するようユーザーに促すエラー通知である。

### 本通知の処理概要

この通知は、StaxRipのプレビューフォームで「各選択範囲にジョブを作成」（CreateJobForEachSelection）機能を使用する際に、メインフォームのアシスタント（ウィザード的なガイダンス機能）がまだパスしていない場合に表示されるエラー機能を提供する。

**業務上の目的・背景**：StaxRipには、エンコード処理を行う前に必要な設定や前提条件を確認するアシスタント機能がある。アシスタントは、ソースファイルの設定、出力形式、エンコーダ設定などの重要なステップが完了しているかを検証する。プレビューフォームからジョブを作成する操作は、これらの前提条件が満たされている必要があるため、アシスタントが未完了の場合はユーザーに先にアシスタントの指示に従うよう促す必要がある。

**通知の送信タイミング**：PreviewFormのCreateJobForEachSelection関数で、g.MainForm.AssistantPassedがFalseの場合（アシスタントがまだパスしていない場合）に発生する。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（プレビューフォームを表示中）がダイアログボックスを通じてエラー通知を受け取る。

**通知内容の概要**：「Follow assistant message in main dialog.」というメッセージがエラーダイアログとして表示される。メインダイアログのアシスタントメッセージを確認するようユーザーに促す。

**期待されるアクション**：ユーザーはプレビューフォームを閉じてメインダイアログに戻り、アシスタントメッセージ（通常は画面下部に表示される）の指示に従って必要な設定を完了する必要がある。その後、再度プレビューフォームを開いてジョブ作成操作を実行できる。

## 通知種別

アプリ内通知（TaskDialogエラーダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザー（プレビューフォームを表示中）に対してモーダルダイアログとして表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Error（エラーアイコン） |
| タイトル | Follow assistant message in main dialog. |
| ボタン | OK、Copy |

### 本文テンプレート

```
Follow assistant message in main dialog.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | CreateJobForEachSelection実行時 | g.MainForm.AssistantPassed = False | アシスタントが未完了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| アシスタントがパス済み | g.MainForm.AssistantPassed = Trueの場合は通知しない |
| ソースファイル未設定 | p.SourceFile = ""の場合は先に終了（通知前） |
| 選択範囲なし | p.Ranges.Count = 0の場合は先に終了（通知前） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CreateJobForEachSelection呼び出し] --> B{p.SourceFile = ""?}
    B -->|Yes| C[Exit Sub]
    B -->|No| D{p.Ranges.Count = 0?}
    D -->|Yes| C
    D -->|No| E{AssistantPassed?}
    E -->|No| F[MsgError呼び出し]
    E -->|Yes| G[ジョブ作成処理]
    F --> H[エラーダイアログ表示]
    H --> I[Exit Sub]
    G --> J[各Rangeにジョブ作成]
    J --> K[JobsDialog表示]
    K --> L[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | アプリケーション状態のみ参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| アシスタント未完了 | AssistantPassed = False | MsgErrorで通知、Exit Sub |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- 個人情報は含まれない
- ローカルアプリケーション内での表示のため、暗号化不要
- 認証不要

## 備考

- アシスタント機能は、エンコード処理に必要な設定が完了しているかを検証する
- アシスタントメッセージはメインフォームの下部に表示される
- アシスタントがパスするためには、ソースファイル、出力形式、エンコーダなどの基本設定が必要
- この通知は、ユーザーが設定を完了せずに高度な機能を使用しようとした場合の安全弁として機能する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アシスタント機能とMainFormの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainForm.vb | `Source/Forms/MainForm.vb` | AssistantPassedプロパティの定義を確認 |
| 1-2 | GlobalClass.vb | `Source/General/GlobalClass.vb` | MainFormプロパティの定義を確認 |

**読解のコツ**: g.MainForm.AssistantPassedは、メインフォームのアシスタント機能が必要な設定チェックを全てパスしたかどうかを示すBoolean値。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PreviewForm.vb | `Source/Forms/PreviewForm.vb` | CreateJobForEachSelection関数（行713-748）がエントリーポイント |

**主要処理フロー**:
1. **行713**: <Command("Creates a job for each selection.")> - コマンド属性
2. **行714**: Sub CreateJobForEachSelection() - 関数定義
3. **行715-717**: If p.SourceFile = "" OrElse p.Ranges.Count = 0 Then Exit Sub - 前提条件チェック
4. **行719-721**: If Not g.MainForm.AssistantPassed Then MsgError(...) Exit Sub - アシスタントチェック
5. **行724-747**: ジョブ作成処理

#### Step 3: アシスタント機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm.vb | `Source/Forms/MainForm.vb` | アシスタント検証ロジックの実装を確認 |

**主要処理フロー**:
- **AssistantPassed**: 全てのアシスタントチェックがパスした場合にTrueになる
- チェック項目：ソースファイル設定、出力形式設定、エンコーダ設定など

### プログラム呼び出し階層図

```
PreviewForm / メニュー・コマンド
    │
    └─ CreateJobForEachSelection()
           │
           ├─ (p.SourceFile = "" OR p.Ranges.Count = 0) Exit Sub
           │
           ├─ g.MainForm.AssistantPassed
           │      │
           │      ├─ (False) MsgError("Follow assistant message in main dialog.")
           │      │      │
           │      │      └─ TaskDialog.Show()
           │      │             │
           │      │             └─ Exit Sub
           │      │
           │      └─ (True) ジョブ作成処理
           │             │
           │             ├─ tempProject = ObjectHelp.GetCopy(p)
           │             │
           │             ├─ For Each range in p.Ranges
           │             │      │
           │             │      └─ g.MainForm.AddJob(False)
           │             │
           │             └─ g.MainForm.ShowJobsDialog()
           │
           └─ 終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

p.SourceFile   ───▶ = "" 判定              ───▶ Boolean (先行チェック)

p.Ranges.Count ───▶ = 0 判定               ───▶ Boolean (先行チェック)

g.MainForm.AssistantPassed ───▶ Boolean判定
     │
     │ (False時)
     ▼
MsgError()     ───▶ TaskDialog表示         ───▶ ユーザーへのエラー通知
     │
     ▼
Exit Sub       ───▶ 処理終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PreviewForm.vb | `Source/Forms/PreviewForm.vb` | ソース | CreateJobForEachSelection関数の実装、通知発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の実装 |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | AssistantPassedプロパティ、アシスタント機能の実装 |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | MainFormプロパティの定義 |
| Project.vb | `Source/General/Project.vb` | ソース | SourceFile、Rangesプロパティの定義 |
