# 通知設計書 31-処理結果確認通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「処理結果確認通知」（All Good!）の設計仕様を記述する。本通知は、開発・テスト実行時に全ツールの状態が正常であることを確認するための情報メッセージを表示する。

### 本通知の処理概要

本通知は、開発者が内部テストコマンドを実行した際に、全ての組み込みツール（エンコーダやパッケージ）の状態チェックが完了し、問題がないことをユーザーに通知する機能を提供する。

**業務上の目的・背景**：StaxRipは多数の外部ツール（x264、x265、ffmpeg、NVEnc、QSVEnc等）を利用するため、これらのツールの設定・バージョン・パスの整合性を確認する必要がある。開発時やトラブルシューティング時に、すべてのツールが正常状態であることを迅速に確認できるよう、本通知が設計されている。

**通知の送信タイミング**：`GlobalCommands.Test()`メソッドが実行され、全ツールのチェック処理が完了した際に、問題が検出されなかった場合にのみ表示される。このメソッドは開発者PC（`g.IsDevelopmentPC = True`）でのみ動作する。

**通知の受信者**：開発者またはアプリケーションの動作検証を行うユーザー。

**通知内容の概要**：「All Good!」という短いメッセージで、全ツールが正常状態であることを示す。

**期待されるアクション**：ユーザーはOKボタンをクリックしてダイアログを閉じる。問題がないことを確認し、通常の作業を継続できる。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | All Good! |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
All Good!
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コマンド実行 | `Test()`コマンド実行 | 全ツールチェック正常完了 | 開発用テストコマンドの実行結果通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 開発者PC以外 | `g.IsDevelopmentPC = False`の場合、テストコマンド自体が実行されない |
| エラー検出時 | ツールのパス、バージョン、ヘルプファイル等に問題がある場合はテキストファイルに出力される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Test コマンド実行] --> B{開発者PCか?}
    B -->|No| C[処理終了]
    B -->|Yes| D[エンコーダテスト実行]
    D --> E[パッケージチェック]
    E --> F{エラー検出?}
    F -->|Yes| G[テキストファイルに出力]
    F -->|No| H[MsgInfo "All Good!" 表示]
    G --> I[ファイルをシェル実行]
    H --> J[終了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 対象外 | 本通知はエラーがない場合のみ表示 | - |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 本通知は開発者PCでのみ動作するため、一般ユーザーには表示されない
- 内部のツール状態情報は外部に送信されない

## 備考

- このコマンドは`CommandAttribute`で「Development tests.」と説明されている
- 開発時のセルフテスト用機能であり、エンドユーザー向けではない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本通知は単純な情報メッセージのため、特別なデータ構造は使用しない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | `MsgInfo`関数の定義（1216-1219行） |

**読解のコツ**: `MsgInfo`は`Msg`関数のラッパーで、`TaskIcon.Info`と`TaskButton.OK`を設定する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコマンドメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalCommands.vb | `Source/General/GlobalCommands.vb` | `Test()`メソッド（230-273行） |

**主要処理フロー**:
1. **行232-233**: `g.IsDevelopmentPC`チェックで開発者PC以外は早期リターン
2. **行238-243**: 各エンコーダのテスト実行（NVEnc, QSVEnc, x264, x265）
3. **行245-264**: `Package.Items`をループして各パッケージの状態チェック
4. **行266-272**: エラーがなければ`MsgInfo("All Good!")`を呼び出し

#### Step 3: メッセージ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | `MainModule`の`MsgInfo`関数（1216-1219行） |
| 3-2 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | `TaskDialog`クラスの表示処理 |

**主要処理フロー**:
- **行1216-1219**: `MsgInfo`は`Msg`を呼び出し、`TaskIcon.Info`と`TaskButton.OK`を設定
- **行1274-1282**: `Msg`関数は`TaskDialog`を生成して`Show()`を呼び出し

### プログラム呼び出し階層図

```
GlobalCommands.Test()
    │
    ├─ g.IsDevelopmentPC（開発者PCチェック）
    │
    ├─ NVEnc.Test / QSVEnc.Test / x264Enc.Test / x265Enc.Test
    │
    ├─ Package.Items.Values ループ
    │      ├─ pack.Path チェック
    │      ├─ pack.Version チェック
    │      └─ pack.HelpFilename チェック
    │
    └─ MsgInfo("All Good!")
           └─ Msg()
                  └─ TaskDialog(Of DialogResult).Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

開発者PC判定 ───▶ Test()メソッド ───▶ MsgInfo("All Good!")
                       │                      │
                       ▼                      ▼
              パッケージ検証 ───▶ TaskDialog表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | テストコマンド定義 |
| General.vb | `Source/General/General.vb` | ソース | メッセージ関数定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログUI |
