# 通知設計書 32-再起動リセット通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「再起動リセット通知」（Will be reseted on next startup.）の設計仕様を記述する。本通知は、ユーザーが特定の設定をリセット予約した際に、次回起動時にリセットが実行されることを通知する。

### 本通知の処理概要

本通知は、設定リセット機能において、ユーザーが特定の設定項目のリセットを選択した後、そのリセットが即座に実行されるのではなく、次回アプリケーション起動時に実行されることをユーザーに通知する情報メッセージを表示する。

**業務上の目的・背景**：StaxRipは多数の設定項目（Video Encoder、Audio Tracks、Preferred Audio Languages等）を持ち、これらの設定が破損したり初期状態に戻したい場合がある。設定リセットは安全のため即時実行せず、次回起動時に実行される設計となっている。ユーザーがこの動作を理解できるよう、本通知が設計されている。

**通知の送信タイミング**：`GlobalCommands.ResetSettings()`メソッドでユーザーがリセットする設定項目を選択し、OKボタンをクリックした後に表示される。

**通知の受信者**：設定リセット操作を実行したユーザー。

**通知内容の概要**：「Will be reseted on next startup.」というメッセージと、選択された設定名が表示される。

**期待されるアクション**：ユーザーはメッセージを確認し、次回起動時にリセットが実行されることを理解する。必要に応じてアプリケーションを再起動する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Will be reseted on next startup. |
| 補足情報 | {選択された設定名} |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
Will be reseted on next startup.

{設定名}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| 設定名 | リセット対象の設定項目名 | SelectionBox.SelectedValue | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ResetSettings()コマンド実行 | 設定選択ダイアログでOK選択 | リセット予約完了通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| キャンセル選択 | SelectionBoxでキャンセルまたは閉じた場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ResetSettings コマンド実行] --> B[SelectionBox表示]
    B --> C[設定項目一覧取得]
    C --> D{ユーザー選択}
    D -->|キャンセル| E[処理終了]
    D -->|OK| F[バージョン番号を-1に設定]
    F --> G[MsgInfo表示]
    G --> H[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新対象

| 対象 | 操作 | 概要 |
|-----|------|------|
| s.Versions | UPDATE | 選択された設定のバージョンを-1に設定 |

#### 設定バージョン更新

| 操作 | 項目 | 更新値 | 備考 |
|-----|------|-------|------|
| UPDATE | s.Versions(選択設定名) | -1 | 次回起動時にリセットトリガー |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 設定項目なし | Versionsが空の場合 | SelectionBoxが空で表示される |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 設定リセットは即時実行されないため、誤操作時に復旧の余地がある
- 個人情報や機密情報は含まれない

## 備考

- バージョン番号を-1に設定することで、次回起動時の`ISafeSerialization.Init()`でリセットがトリガーされる
- このコマンドは`CommandAttribute`で「Shows a dialog allowing to reset specific settings.」と説明されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定のバージョン管理の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | `ISafeSerialization`インターフェース（433-437行） |
| 1-2 | ApplicationSettings.vb | 設定ファイル | `Versions`ディクショナリの使い方 |

**読解のコツ**: `Versions`は設定項目名をキー、バージョン番号を値とするディクショナリで、-1は「次回起動時にリセット」を意味する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalCommands.vb | `Source/General/GlobalCommands.vb` | `ResetSettings()`メソッド（917-937行） |

**主要処理フロー**:
1. **行919-920**: `SelectionBox(Of String)`を生成してタイトルとテキストを設定
2. **行924-925**: `ApplicationSettings`を生成して`Init()`を呼び出し
3. **行927-929**: `appSettings.Versions.Keys`をループしてSelectionBoxに項目を追加
4. **行931**: 項目をソート
5. **行933-936**: ユーザーがOKを選択した場合、バージョンを-1に設定してMsgInfo表示

#### Step 3: メッセージ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | `MsgInfo`関数（1216-1219行） |

**主要処理フロー**:
- **行935**: `MsgInfo("Will be reseted on next startup.", sb.SelectedValue)`

### プログラム呼び出し階層図

```
GlobalCommands.ResetSettings()
    │
    ├─ SelectionBox(Of String) 生成
    │      ├─ Title = "Reset Settings"
    │      └─ Text = "Please select a setting to reset."
    │
    ├─ ApplicationSettings.Init()
    │      └─ Versions ディクショナリ初期化
    │
    ├─ appSettings.Versions.Keys ループ
    │      └─ sb.AddItem(i)
    │
    ├─ sb.Items.Sort()
    │
    ├─ sb.Show()
    │      └─ ユーザー選択
    │
    └─ s.Versions(sb.SelectedValue) = -1
           └─ MsgInfo("Will be reseted on next startup.", sb.SelectedValue)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ApplicationSettings ───▶ ResetSettings() ───▶ MsgInfo表示
        │                       │
        ▼                       ▼
  Versions.Keys        s.Versions更新
        │                  (-1設定)
        ▼
  SelectionBox表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | リセット設定コマンド定義 |
| General.vb | `Source/General/General.vb` | ソース | メッセージ関数・ISafeSerialization定義 |
| ApplicationSettings.vb | 設定関連 | ソース | アプリケーション設定クラス |
