# 通知設計書 33-機能廃止通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「機能廃止通知」（Functionality is no longer available.）の設計仕様を記述する。本通知は、廃止された機能が使用された際にユーザーに警告を表示する。

### 本通知の処理概要

本通知は、アプリケーションのバージョンアップに伴い廃止された機能やコマンドが呼び出された際に、その機能がもう利用できないことをユーザーに通知する警告メッセージを表示する。

**業務上の目的・背景**：StaxRipは継続的に開発が進められており、古いメニュー項目やコマンドが廃止されることがある。廃止された機能を呼び出すカスタムメニューやイベントコマンドが残っている場合、ユーザーに適切にフィードバックを与え、設定の見直しを促す必要がある。

**通知の送信タイミング**：`GlobalCommands.ShowRemovedFunctionalityMessage()`メソッドが呼び出された際に表示される。これは廃止されたコマンドに対するスタブとして機能する。

**通知の受信者**：廃止された機能を実行しようとしたユーザー。

**通知内容の概要**：「Functionality is no longer available.」という警告メッセージが表示される。

**期待されるアクション**：ユーザーはカスタムメニューやイベントコマンドの設定を確認し、廃止された機能への参照を削除または更新する。

## 通知種別

アプリ内通知（タスクダイアログ - 警告）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Functionality is no longer available. |
| アイコン | Warning |
| ボタン | OK |

### 本文テンプレート

```
Functionality is no longer available.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コマンド実行 | ShowRemovedFunctionalityMessage()呼び出し | 常に表示 | 廃止機能の実行時 |

### 送信抑止条件

なし（呼び出されれば必ず表示）

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[廃止コマンド実行] --> B[ShowRemovedFunctionalityMessage呼び出し]
    B --> C[MsgWarn表示]
    C --> D[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

該当なし

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 機密情報は含まれない
- 廃止された機能の詳細情報は表示されない

## 備考

- このコマンドは`CommandAttribute`で「Shows a message about removed functionality.」と説明されている
- 廃止されたメニュー項目やイベントコマンドのスタブとして使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本通知は単純な警告メッセージのため、特別なデータ構造は使用しない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | `MsgWarn`関数の定義（1245-1255行） |

**読解のコツ**: `MsgWarn`は`Msg`関数を呼び出し、`TaskIcon.Warning`を設定する。`onlyOnce`パラメータで重複表示を抑制できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalCommands.vb | `Source/General/GlobalCommands.vb` | `ShowRemovedFunctionalityMessage()`メソッド（939-942行） |

**主要処理フロー**:
1. **行941**: `MsgWarn("Functionality is no longer available.")`を呼び出し

#### Step 3: メッセージ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | `MsgWarn`関数（1245-1255行） |
| 3-2 | General.vb | `Source/General/General.vb` | `Msg`関数（1274-1282行） |

**主要処理フロー**:
- **行1250**: `Msg(text, content, TaskIcon.Warning, TaskButton.OK)`を呼び出し
- **行1274-1282**: `TaskDialog`を生成して表示

### プログラム呼び出し階層図

```
廃止コマンド呼び出し
    │
    └─ GlobalCommands.ShowRemovedFunctionalityMessage()
           │
           └─ MsgWarn("Functionality is no longer available.")
                  │
                  └─ Msg(text, content, TaskIcon.Warning, TaskButton.OK)
                         │
                         └─ TaskDialog(Of DialogResult).Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

廃止コマンド ───▶ ShowRemovedFunctionalityMessage() ───▶ MsgWarn表示
                                                              │
                                                              ▼
                                                      TaskDialog(Warning)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | 廃止機能通知コマンド定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログUI |
