# 通知設計書 34-無効文字警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「無効文字警告」（Filename contains invalid characters.）の設計仕様を記述する。本通知は、ファイル名に無効な文字が含まれている場合にユーザーに警告を表示する。

### 本通知の処理概要

本通知は、プロジェクトのターゲットファイル名を設定する際に、ファイルパスやファイル名に無効な文字が含まれている場合に警告メッセージを表示し、設定を拒否する機能を提供する。

**業務上の目的・背景**：Windowsファイルシステムでは、特定の文字（<, >, :, ", /, \, |, ?, *等）がファイル名に使用できない。ユーザーがこれらの文字を含むファイル名を入力した場合、後続のエンコード・マクシング処理で失敗する可能性がある。早期にエラーを検出し、ユーザーに修正を促すことで、処理失敗を未然に防ぐ。

**通知の送信タイミング**：`Project.TargetFile`プロパティのSetterで、新しい値が無効な文字を含む場合に表示される。

**通知の受信者**：ターゲットファイル名を変更しようとしたユーザー。

**通知内容の概要**：「Filename contains invalid characters.」という警告メッセージが表示される。

**期待されるアクション**：ユーザーは無効な文字を含まないファイル名を入力し直す。

## 通知種別

アプリ内通知（タスクダイアログ - 警告）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Filename contains invalid characters. |
| アイコン | Warning |
| ボタン | OK |

### 本文テンプレート

```
Filename contains invalid characters.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロパティ設定 | TargetFileプロパティ設定 | 無効文字を含む場合 | ファイル名検証エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 空文字列 | 値が空の場合は検証をスキップ |
| 同一値 | 現在の値と同じ場合は検証をスキップ |
| 有効なファイル名 | 無効文字を含まない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[TargetFile設定] --> B{値が空か?}
    B -->|Yes| C[検証スキップ]
    B -->|No| D{現在値と同一か?}
    D -->|Yes| C
    D -->|No| E{パスに無効文字を含むか?}
    E -->|Yes| F[MsgWarn表示]
    E -->|No| G{ファイル名が有効か?}
    G -->|No| F
    G -->|Yes| H[値を設定]
    F --> I[Exit Property - 設定を拒否]
    H --> J[PropertyChanged通知]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし（検証エラー時は設定が拒否される）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効文字検出 | パスに無効文字が含まれる | 警告表示して設定を拒否 |
| 無効なファイル名 | ファイル名が有効でない | 警告表示して設定を拒否 |

### リトライ仕様

該当なし（ユーザーが正しい値を再入力する必要がある）

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 入力検証によりファイルシステムの不正操作を防止
- パストラバーサル攻撃の防止に寄与

## 備考

- `Path.GetInvalidPathChars()`と`IsValidFileName()`を使用して検証
- 設定が拒否されるため、後続処理でのエラーを防止

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Projectクラスのプロパティ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | `TargetFile`プロパティ定義（283-300行） |

**読解のコツ**: `TargetFile`プロパティはSetterで入力検証を行い、無効な場合は`Exit Property`で設定を拒否する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Project.vb | `Source/General/Project.vb` | `TargetFile`プロパティSetter（285-300行） |

**主要処理フロー**:
1. **行290**: 新しい値が現在値と異なるかチェック
2. **行291**: 値が空でなく、無効文字を含むかチェック
3. **行291**: `Path.GetInvalidPathChars()`で無効パス文字をチェック
4. **行291**: `IsValidFileName()`でファイル名の有効性をチェック
5. **行292**: 無効な場合、`MsgWarn("Filename contains invalid characters.")`を呼び出し
6. **行293**: `Exit Property`で設定を拒否

#### Step 3: 検証ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 拡張メソッド | 各種Extension | `IsValidFileName()`メソッドの実装 |

**主要処理フロー**:
- `ContainsAny(Path.GetInvalidPathChars())`でパス文字検証
- `IsValidFileName()`でファイル名検証

### プログラム呼び出し階層図

```
TargetFile = value (プロパティSetter)
    │
    ├─ value <> TargetFileValue（変更チェック）
    │
    ├─ value <> ""（空チェック）
    │
    ├─ value.ContainsAny(Path.GetInvalidPathChars())（パス文字検証）
    │
    ├─ value.FileName.IsValidFileName()（ファイル名検証）
    │
    └─ MsgWarn("Filename contains invalid characters.")
           │
           └─ Exit Property（設定拒否）
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー入力 ───▶ TargetFile Setter ───▶ 検証結果
    │                    │
    │                    ▼
    │              無効文字検出?
    │                    │
    │            ┌───────┴───────┐
    │            │Yes            │No
    │            ▼               ▼
    │       MsgWarn表示      値を設定
    │            │               │
    │            ▼               ▼
    │       Exit Property   PropertyChanged
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Project.vb | `Source/General/Project.vb` | ソース | TargetFileプロパティ定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数定義 |
| Extensions | 各種拡張メソッド | ソース | IsValidFileName()等 |
