# 通知設計書 35-字幕形式エラー通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「字幕形式エラー通知」（Only idx, srt and ass file types are supported.）の設計仕様を記述する。本通知は、AviSynth使用時にサポートされていない字幕形式が指定された場合にユーザーにエラーを表示する。

### 本通知の処理概要

本通知は、ハードコード字幕フィルタを追加する際に、AviSynth環境でサポートされていない字幕形式（idx、srt、ass以外）が指定された場合にエラーメッセージを表示する機能を提供する。

**業務上の目的・背景**：StaxRipは字幕をビデオにハードコード（焼き込み）する機能を持つ。AviSynthでは使用可能なフィルタが限られており、VobSub（idx）、TextSub（srt、ass）形式のみがサポートされている。サポートされていない形式が指定された場合、早期にエラーを通知することで、ユーザーの混乱を防ぎ、適切な形式への変換を促す。

**通知の送信タイミング**：`Project.AddHardcodedSubtitleFilter()`メソッドでAviSynth環境において、idx、srt、ass以外の拡張子を持つファイルが指定された場合に表示される。

**通知の受信者**：ハードコード字幕を追加しようとしたユーザー。

**通知内容の概要**：「Only idx, srt and ass file types are supported.」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーは字幕ファイルをサポートされている形式（idx、srt、ass）に変換するか、VapourSynth環境への切り替えを検討する。

## 通知種別

アプリ内通知（タスクダイアログ - エラー）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Only idx, srt and ass file types are supported. |
| アイコン | Error |
| ボタン | OK |

### 本文テンプレート

```
Only idx, srt and ass file types are supported.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ハードコード字幕追加 | 非対応形式かつAviSynth環境 | 字幕形式検証エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| VapourSynth使用時 | VapourSynth環境では別の通知（No.36）が使用される |
| 対応形式 | idx、srt、assの場合は表示されない |
| showErrorMsg=False | フラグがFalseの場合は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AddHardcodedSubtitleFilter呼び出し] --> B{スクリプトエンジン}
    B -->|AviSynth| C{拡張子チェック}
    B -->|VapourSynth| D[別処理へ]
    C -->|idx| E[VobSubフィルタ設定]
    C -->|srt/ass| F[TextSubフィルタ設定]
    C -->|その他| G{showErrorMsg?}
    G -->|True| H[MsgError表示]
    G -->|False| I[処理終了]
    H --> J[Exit Sub]
    E --> K[フィルタ追加]
    F --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 非対応形式 | idx、srt、ass以外の拡張子 | エラー表示してフィルタ追加を中止 |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 外部ファイルの形式検証によりセキュリティを確保
- ファイルパスの妥当性は別途検証される

## 備考

- AviSynth環境専用の通知
- VapourSynth環境では追加でsup形式もサポートされる（No.36参照）
- showErrorMsgフラグにより表示を制御可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

字幕フィルタの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | `AddHardcodedSubtitleFilter`メソッド定義（302-363行） |

**読解のコツ**: AviSynth用とVapourSynth用で分岐しており、AviSynth用は行303-326で処理される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Project.vb | `Source/General/Project.vb` | AviSynth分岐部分（303-326行） |

**主要処理フロー**:
1. **行303**: `p.Script.IsAviSynth`でスクリプトエンジンをチェック
2. **行306-316**: Select Caseで拡張子を判定
3. **行306**: `Case "idx"` - VobSubフィルタを使用
4. **行308**: `Case "srt", "ass"` - TextSubフィルタを使用
5. **行310-315**: `Case Else` - showErrorMsgがTrueならMsgError表示

#### Step 3: メッセージ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | `MsgError`関数（1222-1240行） |

**主要処理フロー**:
- **行313**: `MsgError("Only idx, srt and ass file types are supported.")`
- **行315**: `Exit Sub`でメソッドを終了

### プログラム呼び出し階層図

```
AddHardcodedSubtitleFilter(path, showErrorMsg)
    │
    ├─ p.Script.IsAviSynth チェック
    │      │
    │      └─ True（AviSynth）
    │             │
    │             ├─ path.Ext = "idx" → filterName = "VobSub"
    │             │
    │             ├─ path.Ext = "srt" or "ass" → filterName = "TextSub"
    │             │
    │             └─ Case Else
    │                    │
    │                    ├─ showErrorMsg = True
    │                    │      └─ MsgError("Only idx, srt and ass...")
    │                    │
    │                    └─ Exit Sub
    │
    └─ False（VapourSynth）→ 別処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

字幕ファイルパス ───▶ AddHardcodedSubtitleFilter ───▶ 結果
       │                       │
       ▼                       ▼
  拡張子取得           スクリプトエンジン判定
       │                       │
       │              ┌────────┴────────┐
       │              │AviSynth        │VapourSynth
       │              ▼                ▼
       │         拡張子検証        別処理
       │              │
       │     ┌────────┼────────┐
       │     │idx     │srt/ass │その他
       │     ▼        ▼        ▼
       │  VobSub  TextSub  MsgError
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Project.vb | `Source/General/Project.vb` | ソース | AddHardcodedSubtitleFilterメソッド |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログUI |
