# 通知設計書 36-字幕形式エラー通知（sup含む）

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「字幕形式エラー通知（sup含む）」（Only idx, srt, ass and sup file types are supported.）の設計仕様を記述する。本通知は、VapourSynth使用時にサポートされていない字幕形式が指定された場合にユーザーにエラーを表示する。

### 本通知の処理概要

本通知は、ハードコード字幕フィルタを追加する際に、VapourSynth環境でサポートされていない字幕形式（idx、srt、ass、sup以外）が指定された場合にエラーメッセージを表示する機能を提供する。

**業務上の目的・背景**：StaxRipは字幕をビデオにハードコード（焼き込み）する機能を持つ。VapourSynthではAviSynthよりも多くの形式（追加でsup形式）がサポートされているが、それ以外の形式については対応していない。サポートされていない形式が指定された場合、早期にエラーを通知することで、ユーザーの混乱を防ぎ、適切な形式への変換を促す。

**通知の送信タイミング**：`Project.AddHardcodedSubtitleFilter()`メソッドでVapourSynth環境において、idx、srt、ass、sup以外の拡張子を持つファイルが指定された場合に表示される。

**通知の受信者**：ハードコード字幕を追加しようとしたユーザー。

**通知内容の概要**：「Only idx, srt, ass and sup file types are supported.」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーは字幕ファイルをサポートされている形式（idx、srt、ass、sup）に変換する。

## 通知種別

アプリ内通知（タスクダイアログ - エラー）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Only idx, srt, ass and sup file types are supported. |
| アイコン | Error |
| ボタン | OK |

### 本文テンプレート

```
Only idx, srt, ass and sup file types are supported.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ハードコード字幕追加 | 非対応形式かつVapourSynth環境 | 字幕形式検証エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| AviSynth使用時 | AviSynth環境では別の通知（No.35）が使用される |
| 対応形式 | idx、srt、ass、supの場合は表示されない |
| showErrorMsg=False | フラグがFalseの場合は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AddHardcodedSubtitleFilter呼び出し] --> B{スクリプトエンジン}
    B -->|AviSynth| C[No.35の処理へ]
    B -->|VapourSynth| D{拡張子チェック}
    D -->|idx| E[core.vsfm.VobSubフィルタ設定]
    D -->|srt| F[core.vsfm.TextSubModフィルタ設定]
    D -->|ass| G[レンダラー選択ダイアログ]
    D -->|sup| H[core.sub.ImageFileフィルタ設定]
    D -->|その他| I{showErrorMsg?}
    I -->|True| J[MsgError表示]
    I -->|False| K[処理終了]
    J --> L[Exit Sub]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 非対応形式 | idx、srt、ass、sup以外の拡張子 | エラー表示してフィルタ追加を中止 |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 外部ファイルの形式検証によりセキュリティを確保
- ファイルパスの妥当性は別途検証される

## 備考

- VapourSynth環境専用の通知
- AviSynth環境よりもsup形式が追加でサポートされる
- ass形式の場合、レンダラー選択ダイアログが表示される
- showErrorMsgフラグにより表示を制御可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

VapourSynth用の字幕フィルタの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | `AddHardcodedSubtitleFilter`メソッド定義（302-363行） |

**読解のコツ**: VapourSynth用は行327-362で処理される。AviSynthよりも対応形式が多く、各形式で異なるフィルタが使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Project.vb | `Source/General/Project.vb` | VapourSynth分岐部分（327-362行） |

**主要処理フロー**:
1. **行327**: `Else`でVapourSynth環境の処理に入る
2. **行330-351**: Select Caseで拡張子を判定
3. **行331**: `Case "idx"` - core.vsfm.VobSubフィルタを使用
4. **行333**: `Case "srt"` - core.vsfm.TextSubModフィルタを使用
5. **行335-345**: `Case "ass"` - レンダラー選択ダイアログ表示
6. **行347**: `Case "sup"` - core.sub.ImageFileフィルタを使用
7. **行349-351**: `Case Else` - showErrorMsgがTrueならMsgError表示

#### Step 3: メッセージ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | `MsgError`関数（1222-1240行） |

**主要処理フロー**:
- **行350**: `MsgError("Only idx, srt, ass and sup file types are supported.")`
- **行351**: `Exit Sub`でメソッドを終了

### プログラム呼び出し階層図

```
AddHardcodedSubtitleFilter(path, showErrorMsg)
    │
    ├─ p.Script.IsAviSynth チェック
    │      │
    │      └─ False（VapourSynth）
    │             │
    │             ├─ path.Ext = "idx" → filterName = "core.vsfm.VobSub"
    │             │
    │             ├─ path.Ext = "srt" → filterName = "core.vsfm.TextSubMod"
    │             │
    │             ├─ path.Ext = "ass"
    │             │      └─ TaskDialog表示（レンダラー選択）
    │             │             ├─ core.vsfm.TextSubMod
    │             │             └─ core.sub.TextFile
    │             │
    │             ├─ path.Ext = "sup" → filterName = "core.sub.ImageFile"
    │             │
    │             └─ Case Else
    │                    │
    │                    ├─ showErrorMsg = True
    │                    │      └─ MsgError("Only idx, srt, ass and sup...")
    │                    │
    │                    └─ Exit Sub
```

### データフロー図

```
[入力]               [処理]                    [出力]

字幕ファイルパス ───▶ AddHardcodedSubtitleFilter ───▶ 結果
       │                       │
       ▼                       ▼
  拡張子取得           スクリプトエンジン判定
       │                       │
       │              ┌────────┴────────┐
       │              │AviSynth        │VapourSynth
       │              ▼                ▼
       │          No.35処理        拡張子検証
       │                              │
       │              ┌───┬───┬───┬───┼───┐
       │              │idx│srt│ass│sup│他
       │              ▼   ▼   ▼   ▼   ▼
       │           VobSub TextSub ダイアログ ImageFile MsgError
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Project.vb | `Source/General/Project.vb` | ソース | AddHardcodedSubtitleFilterメソッド |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログUI（レンダラー選択含む） |
