# 通知設計書 37-HDRメタデータ未検出通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「HDRメタデータ未検出通知」（No HDR Metadata Key was Found）の設計仕様を記述する。本通知は、MKVファイルにHDRメタデータを追加しようとした際に、HDRコンテンツとして認識されなかった場合にユーザーに通知する。

### 本通知の処理概要

本通知は、MKVファイルにHDRメタデータを追加する機能（SaveMKVHDRコマンド）において、入力ファイルがHDR10やHLGとして認識されなかった場合に情報メッセージを表示する機能を提供する。

**業務上の目的・背景**：HDRコンテンツをMKVコンテナに格納する際、適切なメタデータ（色空間、輝度情報等）が必要となる。ユーザーがHDRメタデータ追加機能を使用した際に、入力ファイルがSDRコンテンツであったり、既にメタデータが設定されていたりする場合、処理が不要であることを明示的に通知する。

**通知の送信タイミング**：`MKVInfo.MetadataHDR()`メソッドで、MediaInfoから取得したtransfer_characteristicsが「PQ」でも「HLG」でもない場合に表示される。

**通知の受信者**：HDRメタデータ追加機能を使用しようとしたユーザー。

**通知内容の概要**：「No HDR Metadata Key was Found」という情報メッセージが表示される。

**期待されるアクション**：ユーザーは入力ファイルがHDRコンテンツかどうかを確認し、必要に応じて別のファイルを選択するか、処理を中止する。

## 通知種別

アプリ内通知（タスクダイアログ - 情報）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | No HDR Metadata Key was Found |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
No HDR Metadata Key was Found
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コマンド実行 | SaveMKVHDR()実行 | transfer_characteristicsがPQ/HLG以外 | HDR未検出通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| HDR10検出 | transfer_characteristics = "PQ"の場合 |
| HLG検出 | transfer_characteristics = "HLG"の場合 |
| ファイル不存在 | 入力ファイルが存在しない場合は処理自体がスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SaveMKVHDR コマンド実行] --> B[ファイル選択ダイアログ]
    B --> C{ファイル選択}
    C -->|キャンセル| D[処理終了]
    C -->|OK| E[MKVInfo.MetadataHDR呼び出し]
    E --> F{ファイル存在?}
    F -->|No| D
    F -->|Yes| G[MediaInfo取得]
    G --> H{transfer_characteristics}
    H -->|PQ| I[HDR10メタデータ追加処理]
    H -->|HLG| J[HLGメタデータ追加処理]
    H -->|その他| K[MsgInfo表示]
    I --> L[処理完了]
    J --> L
    K --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 外部データソース参照

| データソース | 用途 | 備考 |
|-------------|------|------|
| MediaInfo | transfer_characteristics取得 | ビデオトラックの色特性情報 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| HDR未検出 | 非HDRコンテンツ | 情報通知を表示 |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 外部ファイルの情報取得のみ行い、内容の改変は行わない
- MediaInfoライブラリを使用した安全なメタデータ取得

## 備考

- HDR10の場合はtransfer_characteristics = "PQ"（Perceptual Quantizer）
- HLGの場合はtransfer_characteristics = "HLG"（Hybrid Log-Gamma）
- Extras.vbで定義されたMKVInfoクラスで処理

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HDRメタデータの取得方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Extras.vb | `Source/General/Extras.vb` | `MKVInfo.MetadataHDR`メソッド定義（144-181行） |

**読解のコツ**: MediaInfo.GetVideo()でtransfer_characteristicsを取得し、その値で分岐する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalCommands.vb | `Source/General/GlobalCommands.vb` | `SaveMKVHDR()`メソッド（583-596行） |
| 2-2 | Extras.vb | `Source/General/Extras.vb` | `MKVInfo.MetadataHDR`メソッド（144-181行） |

**主要処理フロー**:
1. **行584-596（GlobalCommands）**: ファイル選択ダイアログを表示し、MetadataHDRを呼び出す
2. **行145-148（Extras）**: ファイル存在チェック
3. **行150**: `MediaInfo.GetVideo(inputFile, "transfer_characteristics")`でHDR情報取得
4. **行152-177**: transfer_characteristicsの値で分岐
5. **行179**: PQでもHLGでもない場合、`MsgInfo("No HDR Metadata Key was Found")`

#### Step 3: メッセージ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | `MsgInfo`関数（1216-1219行） |

**主要処理フロー**:
- **行179**: `MsgInfo("No HDR Metadata Key was Found")`
- MsgInfo関数はTaskIcon.Infoでダイアログを表示

### プログラム呼び出し階層図

```
GlobalCommands.SaveMKVHDR()
    │
    ├─ OpenFileDialog.ShowDialog()
    │
    └─ MKVInfo.MetadataHDR(dialog.FileName, Nothing)
           │
           ├─ File.Exists チェック
           │
           ├─ MediaInfo.GetVideo(inputFile, "transfer_characteristics")
           │
           └─ If hdr = "PQ" Then
           │      └─ mkvmerge処理（HDR10メタデータ追加）
           │
           └─ ElseIf hdr = "HLG" Then
           │      └─ mkvmerge処理（HLGメタデータ追加）
           │
           └─ Else
                  └─ MsgInfo("No HDR Metadata Key was Found")
```

### データフロー図

```
[入力]               [処理]                    [出力]

MKVファイル ───▶ MKVInfo.MetadataHDR ───▶ 結果
       │                   │
       ▼                   ▼
  MediaInfo取得    transfer_characteristics判定
       │                   │
       │          ┌────────┼────────┐
       │          │PQ      │HLG     │その他
       │          ▼        ▼        ▼
       │       HDR10処理 HLG処理  MsgInfo
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Extras.vb | `Source/General/Extras.vb` | ソース | MKVInfo.MetadataHDRメソッド |
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | SaveMKVHDRコマンド |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数定義 |
| MediaInfo | 外部ライブラリ | ライブラリ | メタデータ取得 |
