# 通知設計書 38-コマンド重複警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「コマンド重複警告」（Command already exists.）の設計仕様を記述する。本通知は、同名のコマンドが既に登録されている場合にユーザーに警告を表示する。

### 本通知の処理概要

本通知は、コマンドマネージャーに新しいコマンドを追加しようとした際に、同じ名前のコマンドが既に登録されている場合に警告メッセージを表示する機能を提供する。これにより、コマンドの重複登録によるシステム動作の不整合を防ぐ。

**業務上の目的・背景**：StaxRipはコマンドベースのアーキテクチャを採用しており、`CommandManager`クラスでコマンドを管理している。プラグインやカスタム機能により同名のコマンドが登録される可能性があり、重複を検出してユーザーに通知することで、予期しない動作を防止する。

**通知の送信タイミング**：`CommandManager.AddCommand()`メソッドで、同名のコマンドが既にCommandsディクショナリに存在する場合に表示される。

**通知の受信者**：コマンドを登録しようとした開発者またはプラグイン作成者。

**通知内容の概要**：「Command '{コマンド名}' already exists.」という警告メッセージが表示される。

**期待されるアクション**：ユーザーは重複するコマンド名を変更するか、既存のコマンドを削除してから再登録する。

## 通知種別

アプリ内通知（タスクダイアログ - 警告）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Command '{コマンド名}' already exists. |
| アイコン | Warning |
| ボタン | OK |

### 本文テンプレート

```
Command '{コマンド名}' already exists.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| コマンド名 | 重複しているコマンドのメソッド名 | command.MethodInfo.Name | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コマンド登録 | AddCommand()実行 | 同名コマンドが存在 | コマンド重複検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 新規コマンド | 同名のコマンドが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AddCommand呼び出し] --> B{同名コマンド存在?}
    B -->|Yes| C[MsgWarn表示]
    B -->|No| D[コマンド登録]
    C --> E[処理終了 - 登録スキップ]
    D --> F[処理完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### メモリ内データ参照

| データ | 用途 | 備考 |
|-------|------|------|
| Commands Dictionary | コマンド重複チェック | コマンド名をキーとするディクショナリ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コマンド重複 | 同名コマンドが既に存在 | 警告表示して登録をスキップ |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- コマンド名の重複検出により、意図しないコマンド上書きを防止
- プラグインによる悪意あるコマンド置換を防止

## 備考

- `CommandManager`クラスはGeneral.vbで定義（1056-1207行）
- 重複時は登録をスキップするため、最初に登録されたコマンドが優先される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CommandManagerクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | `CommandManager`クラス定義（1056-1207行） |
| 1-2 | General.vb | `Source/General/General.vb` | `Command`クラス定義（928-1043行） |

**読解のコツ**: `Commands`プロパティはコマンド名をキーとするディクショナリで、コマンドの一意性を保証する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | General.vb | `Source/General/General.vb` | `AddCommand()`メソッド（1104-1110行） |

**主要処理フロー**:
1. **行1105**: `Commands.ContainsKey(command.MethodInfo.Name)`で重複チェック
2. **行1106**: 重複時、`MsgWarn("Command '" + command.MethodInfo.Name + "' already exists.")`
3. **行1108**: 重複なしの場合、`Commands(command.MethodInfo.Name) = command`で登録

#### Step 3: メッセージ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | `MsgWarn`関数（1245-1255行） |

**主要処理フロー**:
- **行1106**: `MsgWarn("Command '" + command.MethodInfo.Name + "' already exists.")`
- MsgWarn関数はTaskIcon.Warningでダイアログを表示

### プログラム呼び出し階層図

```
CommandManager.AddCommand(command)
    │
    ├─ Commands.ContainsKey(command.MethodInfo.Name)
    │      │
    │      ├─ True（重複あり）
    │      │      └─ MsgWarn("Command '" + name + "' already exists.")
    │      │
    │      └─ False（重複なし）
    │             └─ Commands(name) = command
    │
    └─ 処理終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

Commandオブジェクト ───▶ AddCommand ───▶ 結果
       │                     │
       ▼                     ▼
  MethodInfo.Name    Commands.ContainsKey
       │                     │
       │            ┌────────┴────────┐
       │            │True            │False
       │            ▼                ▼
       │         MsgWarn        Commands登録
       │            │                │
       │            ▼                ▼
       │       登録スキップ      登録完了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| General.vb | `Source/General/General.vb` | ソース | CommandManager、Command、MsgWarn定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログUI |
