# 通知設計書 39-パラメータ不一致エラー

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「パラメータ不一致エラー」（Parameter mismatch, for the command）の設計仕様を記述する。本通知は、コマンド実行時にパラメータの数や型が一致しない場合にユーザーにエラーを表示する。

### 本通知の処理概要

本通知は、コマンドマネージャーがコマンドを実行しようとした際に、渡されたパラメータの数や型がコマンドメソッドの定義と一致しない場合にエラーメッセージを表示する機能を提供する。

**業務上の目的・背景**：StaxRipはコマンドベースのアーキテクチャを採用しており、イベントコマンドやカスタムメニューから様々なコマンドを実行できる。古い設定ファイルや不正な設定により、パラメータが不一致となる可能性がある。このエラーを適切に通知することで、設定の修正を促す。

**通知の送信タイミング**：`CommandManager.Process()`メソッドで、`MethodInfo.Invoke()`が`TargetParameterCountException`をスローした場合に表示される。

**通知の受信者**：コマンドを実行しようとしたユーザー。

**通知内容の概要**：「Parameter mismatch, for the command :{コマンド名}」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーはイベントコマンドやカスタムメニューの設定を確認し、正しいパラメータを設定する。

## 通知種別

アプリ内通知（タスクダイアログ - エラー）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Parameter mismatch, for the command :{コマンド名} |
| アイコン | Error |
| ボタン | OK |

### 本文テンプレート

```
Parameter mismatch, for the command :{コマンド名}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| コマンド名 | パラメータ不一致となったコマンドのメソッド名 | command.MethodInfo.Name | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コマンド実行 | Process()実行 | TargetParameterCountException発生 | パラメータ数不一致 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常実行 | パラメータが正しい場合 |
| AbortException | 中断例外の場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Process呼び出し] --> B[MethodInfo.Invoke実行]
    B --> C{例外発生?}
    C -->|なし| D[処理完了]
    C -->|TargetParameterCountException| E[MsgError表示]
    C -->|AbortException| F[スキップ]
    C -->|その他Exception| G[g.ShowException]
    E --> H[処理終了]
    F --> H
    G --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| TargetParameterCountException | パラメータ数不一致 | MsgError表示 |
| AbortException | ユーザー中断 | 通知なしでスキップ |
| その他Exception | その他のエラー | g.ShowException表示 |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- パラメータ検証によるコードインジェクション防止
- 不正なパラメータによる予期しない動作を防止

## 備考

- `TargetParameterCountException`は.NET Frameworkの標準例外
- 例外キャッチはTry-Catchブロックで実装
- `AbortException`は意図的な中断を示すカスタム例外

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CommandManagerクラスの例外処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | `CommandManager.Process`メソッド定義（1130-1144行） |

**読解のコツ**: Try-Catchブロックで3種類の例外（TargetParameterCountException、AbortException、その他）を区別して処理している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | General.vb | `Source/General/General.vb` | `Process`メソッド（1130-1144行） |

**主要処理フロー**:
1. **行1131**: `Try`ブロック開始
2. **行1132**: `command.MethodInfo.Invoke(command.Object, params.ToArray)`でコマンド実行
3. **行1133-1134**: `TargetParameterCountException`をキャッチしてMsgError表示
4. **行1135-1139**: その他の例外処理（AbortException以外はShowException）

#### Step 3: メッセージ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | `MsgError`関数（1222-1240行） |

**主要処理フロー**:
- **行1134**: `MsgError("Parameter mismatch, for the command :" + command.MethodInfo.Name)`
- MsgError関数はTaskIcon.Errorでダイアログを表示

### プログラム呼び出し階層図

```
CommandManager.Process(command, params)
    │
    ├─ Try
    │      │
    │      └─ command.MethodInfo.Invoke(command.Object, params.ToArray)
    │
    ├─ Catch ex As TargetParameterCountException
    │      │
    │      └─ MsgError("Parameter mismatch, for the command :" + name)
    │
    ├─ Catch ex As Exception
    │      │
    │      ├─ TypeOf ex.InnerException Is AbortException
    │      │      └─ (何もしない)
    │      │
    │      └─ Otherwise
    │             └─ g.ShowException(ex)
    │
    └─ End Try
```

### データフロー図

```
[入力]               [処理]                    [出力]

Command + Params ───▶ Process ───▶ 結果
       │                  │
       ▼                  ▼
  MethodInfo.Invoke   例外処理
       │                  │
       │         ┌────────┴────────┐
       │         │成功            │例外
       │         ▼                ▼
       │      処理完了    ┌───────┼───────┐
       │                  │      │       │
       │           ParamCount Abort  Other
       │                  │      │       │
       │                  ▼      ▼       ▼
       │              MsgError スキップ ShowException
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| General.vb | `Source/General/General.vb` | ソース | CommandManager.Process、MsgError定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログUI |
