# 通知設計書 4-MsgQuestion

## 概要

本ドキュメントは、StaxRipアプリケーションにおける質問・確認ダイアログ通知「MsgQuestion」の設計仕様を定義する。MsgQuestionは、ユーザーに確認や選択を求めるタスクダイアログベースの通知機能であり、様々なボタン構成（OK/Cancel、Yes/No等）をサポートする。

### 本通知の処理概要

MsgQuestion通知は、ユーザーからの明示的な応答を必要とする質問や確認を行うための対話型通知メカニズムである。

**業務上の目的・背景**：処理の続行確認、削除操作の確認、設定変更の承認など、ユーザーの意思決定が必要な場面で使用される。これにより、重要な操作の前にユーザーの同意を得ることができ、誤操作を防止する。ボタン構成を柔軟に選択できるため、状況に応じた適切な選択肢を提示できる。

**通知の送信タイミング**：ユーザーの確認が必要な操作が開始される前に同期的に表示される。ユーザーがボタンをクリックして応答するまで、呼び出し元の処理はブロックされる。

**通知の受信者**：現在アプリケーションを操作しているユーザー。タスクダイアログはモーダルダイアログとして表示され、応答が必須となる。

**通知内容の概要**：質問タイトルとオプションのコンテンツ（詳細メッセージ）で構成される。Questionアイコン（青い疑問符マーク）が表示され、指定されたボタン構成（デフォルトはOK/Cancel）が配置される。

**期待されるアクション**：ユーザーは質問内容を確認し、適切なボタン（OK/Cancel、Yes/No等）をクリックして回答する。回答結果はDialogResult列挙型として呼び出し元に返され、後続の処理を決定する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

現在のフォアグラウンドウィンドウのオーナーとして表示される。ユーザーの応答を待つモーダルダイアログとして動作する。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内通知のため）

### 本文テンプレート

```
[タイトル]
{title パラメータの値}

[コンテンツ]（オプション）
{content パラメータの値}

[アイコン]
Question（青い疑問符アイコン）

[ボタン]（buttonsパラメータで指定）
- OkCancel: [OK] [Cancel]（デフォルト）
- YesNo: [Yes] [No]
- YesNoCancel: [Yes] [No] [Cancel]
- RetryCancel: [Retry] [Cancel]
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 質問のタイトルテキスト | 呼び出し元から渡されるString型 | Yes |
| content | 質問の詳細テキスト | 呼び出し元から渡されるString型 | No |
| buttons | ボタン構成 | 呼び出し元から渡されるTaskButton列挙型（デフォルトOkCancel） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | MsgQuestion関数の呼び出し | なし（常に表示） | コード内でMsgQuestion()が呼び出された時点で表示 |
| 画面操作 | 設定リセット確認 | リセット操作実行時 | "Are you sure you want to reset your settings?"を表示 |
| 画面操作 | ファイル削除確認 | 削除操作実行時 | "Delete current files?"を表示 |
| 画面操作 | プロファイル上書き確認 | 上書き操作実行時 | "overwrite?"を表示 |
| 画面操作 | 処理中断確認 | 中断操作実行時 | "Abort processing?"を表示 |
| 画面操作 | 各種確認ダイアログ | ユーザー確認が必要な操作時 | 多数の確認ダイアログで使用 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | MsgQuestionは呼び出し時に常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MsgQuestion呼び出し] --> B[パラメータ検証]
    B --> C[Msg関数呼び出し]
    C --> D[TaskDialogインスタンス生成]
    D --> E[Icon = TaskIcon.Question設定]
    E --> F[Title/Content設定]
    F --> G[Buttons設定]
    G --> H[Show呼び出し]
    H --> I[ダイアログ表示]
    I --> J{ユーザー選択}
    J -->|OK| K[DialogResult.OK返却]
    J -->|Cancel| L[DialogResult.Cancel返却]
    J -->|Yes| M[DialogResult.Yes返却]
    J -->|No| N[DialogResult.No返却]
    J -->|Retry| O[DialogResult.Retry返却]
    K --> P[終了]
    L --> P
    M --> P
    N --> P
    O --> P
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（MsgQuestionはデータベースを参照しない）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

#### 送信ログテーブル

該当なし（MsgQuestionは送信ログを記録しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 表示失敗 | ウィンドウハンドル取得失敗 | スクリーン中央に表示 |
| パラメータエラー | titleが空 | 空のタイトルでダイアログを表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（アプリケーション動作中は常に表示可能）

## セキュリティ考慮事項

- 確認ダイアログはモーダル表示のため、バイパスされることはない
- 重要な操作（削除、リセット等）の前に必ず確認を行うことで、誤操作を防止

## 備考

- MsgQuestionはMainModuleに定義されたグローバル関数であり、2つのオーバーロードが存在
- 戻り値はDialogResult列挙型（OK, Cancel, Yes, No, Retry等）
- TaskButtonフラグ列挙型によりボタン構成を柔軟に指定可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MsgQuestionで使用されるTaskButton列挙型とDialogResult戻り値の関係を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | TaskButton列挙型（行589-601）、フラグによる複合定義を確認 |

**読解のコツ**: TaskButtonはフラグ列挙型で、複数のボタンをOR演算で組み合わせる。OkCancel = OK Or Cancel、YesNo = Yes Or Noのように定義されている。

#### Step 2: エントリーポイントを理解する

MsgQuestion関数の2つのオーバーロードと、デフォルト引数の扱いを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数の定義（行1261-1272） |

**主要処理フロー**:
1. **行1261-1266**: タイトルのみのオーバーロード（buttonsデフォルトはOkCancel）
2. **行1268-1272**: タイトルとコンテンツのオーバーロード
3. **行1265, 1271**: Msg関数呼び出し（TaskIcon.Question, 指定されたbuttons）

#### Step 3: ボタン設定処理を理解する

TaskDialogのButtons WriteOnlyプロパティでのボタン生成処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | Buttons WriteOnlyプロパティ（行313-323）、GetDialogResultFromButton()（行493-508） |

**主要処理フロー**:
- **行313-323**: TaskButtonフラグをループしてAddButton()を呼び出し
- **行315-316**: OK, Yes, No, Cancel, Retry, Closeをチェック
- **行319**: GetDialogResultFromButton()でTaskButtonからDialogResultへ変換
- **行493-508**: TaskButton値に対応するDialogResult値を返す

### プログラム呼び出し階層図

```
MsgQuestion(title, buttons)  [General.vb:1261]
    |
    +-- Msg(title, Nothing, TaskIcon.Question, buttons)  [General.vb:1274]
    |
    OR
    |
MsgQuestion(title, content, buttons)  [General.vb:1268]
    |
    +-- Msg(title, content, TaskIcon.Question, buttons)  [General.vb:1274]
           |
           +-- New TaskDialog(Of DialogResult)()  [TaskDialog.vb:8]
           |
           +-- TaskDialog.Icon = TaskIcon.Question
           +-- TaskDialog.Title = title
           +-- TaskDialog.Content = content
           +-- TaskDialog.Buttons = buttons  [TaskDialog.vb:313]
           |      |
           |      +-- HasFlag(OK) ───> AddButton("OK", DialogResult.OK)
           |      +-- HasFlag(Yes) ──> AddButton("Yes", DialogResult.Yes)
           |      +-- HasFlag(No) ───> AddButton("No", DialogResult.No)
           |      +-- HasFlag(Cancel) > AddButton("Cancel", DialogResult.Cancel)
           |
           +-- TaskDialog.Show()  [TaskDialog.vb:552]
                  |
                  +-- ShowDialog()  [TaskDialog.vb:557]
                  |
                  +-- Return SelectedValue (DialogResult)
```

### データフロー図

```
[入力]               [処理]                    [出力]

title (String) ────> Title設定 ────────────> TaskDialog.Title
                          |
content (String) ───> Content設定 ─────────> TaskDialog.Content
                          |
buttons (TaskButton) > Buttonsプロパティ ───> ボタン群生成
    |                     |
    +-- OK ──────────> AddButton("OK") ───> [OK]ボタン
    +-- Cancel ──────> AddButton("Cancel") > [Cancel]ボタン
    +-- Yes ─────────> AddButton("Yes") ──> [Yes]ボタン
    +-- No ──────────> AddButton("No") ───> [No]ボタン
                          |
TaskIcon.Question ──> Icon設定 ────────────> pbIcon.Image
                          |
                    ShowDialog() ─────────> [画面表示]
                          |
                    ユーザー選択 ─────────> DialogResult
                          |
                    Return DialogResult ──> [戻り値]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| General.vb | `Source/General/General.vb` | ソース | MsgQuestion関数の定義（MainModule内） |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | TaskDialog(Of T)クラス、TaskButton列挙型、Buttonsプロパティ |
| StockIcon.vb | `Source/UI/StockIcon.vb` | ソース | Questionアイコン（Help）取得ユーティリティ |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | MsgQuestionの使用例（設定リセット確認等） |
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | MsgQuestionの使用例（ファイル削除/コピー確認） |
| ProcessingForm.vb | `Source/Forms/ProcessingForm.vb` | ソース | MsgQuestionの使用例（処理中断確認） |
