# 通知設計書 40-クリップボードコピー通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「クリップボードコピー通知」（Message was copied to clipboard.）の設計仕様を記述する。本通知は、メッセージダイアログの内容がクリップボードにコピーされた際にユーザーに通知する。

### 本通知の処理概要

本通知は、タスクダイアログに表示されている内容（タイトル、コンテンツ、拡張コンテンツ）をクリップボードにコピーした際に、コピー完了を示す情報メッセージを表示する機能を提供する。

**業務上の目的・背景**：StaxRipのタスクダイアログには、エラーメッセージや詳細情報などが表示される。これらの情報をバグレポートや問題調査のために外部に共有する必要がある場合があり、「Copy Message」ボタンにより内容をクリップボードにコピーできる。コピー完了を明示的に通知することで、ユーザーは操作が成功したことを確認できる。

**通知の送信タイミング**：タスクダイアログの「Copy Message」リンクボタンがクリックされ、クリップボードへのコピーが完了した後に表示される。

**通知の受信者**：メッセージをコピーしたユーザー。

**通知内容の概要**：「Message was copied to clipboard.」という情報メッセージが表示される。

**期待されるアクション**：ユーザーはコピーされた内容を別のアプリケーション（テキストエディタ、メール、バグトラッカー等）に貼り付けて使用する。

## 通知種別

アプリ内通知（タスクダイアログ - 情報）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | なし |

### 送信先決定ロジック

本通知はアプリケーション内のダイアログとして表示され、現在のアクティブユーザーに対して直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Message was copied to clipboard. |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
Message was copied to clipboard.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Copy Messageボタンクリック | クリップボードコピー完了後 | コピー完了通知 |

### 送信抑止条件

なし（ボタンクリック時は必ず表示）

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Copy Messageボタンクリック] --> B[g.RunSTATask開始]
    B --> C[GetText呼び出し]
    C --> D[テキスト取得]
    D --> E[Clipboard.SetText]
    E --> F[MsgInfo表示]
    F --> G[処理完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| クリップボードエラー | クリップボードアクセス失敗 | 例外がスローされる可能性あり |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- コピーされる内容はダイアログに表示されている内容のみ
- 機密情報がクリップボードに残る可能性があるため注意が必要
- STAThread（Single-Threaded Apartment）で実行される

## 備考

- `g.RunSTATask`はクリップボード操作のためのSTAスレッドを使用
- `GetText()`メソッドはタイトル、Content、ExpandedContentを結合して返す
- TaskDialogの`ShowCopyButton`プロパティでボタン表示を制御

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

TaskDialogクラスのテキスト取得メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | `GetText()`メソッド定義（479-491行） |

**読解のコツ**: `GetText()`はTitleLabel.Text、Content、ExpandedContentを結合して返す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | `ShowCopyButton`プロパティ（454-467行） |

**主要処理フロー**:
1. **行457**: `blCopyMessage.Text = "Copy Message"`でボタンテキスト設定
2. **行458**: `blCopyMessage.Visible = True`でボタン表示
3. **行459-464**: `blCopyMessage.ClickAction`でクリックハンドラ設定
4. **行460-463**: STATaskでクリップボード操作とMsgInfo表示

#### Step 3: メッセージ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | `MsgInfo`関数（1216-1219行） |

**主要処理フロー**:
- **行462**: `Clipboard.SetText(GetText)`でクリップボードにコピー
- **行463**: `MsgInfo("Message was copied to clipboard.")`で通知表示

### プログラム呼び出し階層図

```
ShowCopyButton = True
    │
    └─ blCopyMessage.ClickAction 設定
           │
           └─ g.RunSTATask(Sub()
                  │
                  ├─ Clipboard.SetText(GetText())
                  │      │
                  │      └─ GetText()
                  │             ├─ TitleLabel.Text
                  │             ├─ Content
                  │             └─ ExpandedContent
                  │
                  └─ MsgInfo("Message was copied to clipboard.")
                         │
                         └─ TaskDialog(Info, OK)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ボタンクリック ───▶ ClickAction ───▶ 結果
       │                 │
       ▼                 ▼
  RunSTATask      GetText()呼び出し
       │                 │
       │                 ▼
       │           テキスト取得
       │              │
       │       ┌──────┴──────┐
       │       │Title        │Content
       │       │ExpandedContent
       │              │
       │              ▼
       │       Clipboard.SetText
       │              │
       │              ▼
       │          MsgInfo
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ShowCopyButton、GetText定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数定義 |
| GlobalClass | ヘルパー | ソース | g.RunSTATask定義 |
