# 通知設計書 42-入力値エラー警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける入力値バリデーション失敗時に表示される警告通知「is no valid input」の設計を記載する。

### 本通知の処理概要

本通知は、ValidationProviderコンポーネントによる入力値検証において、ユーザーが入力した値が指定された正規表現パターンにマッチしない場合に表示される警告通知である。

**業務上の目的・背景**：ユーザー入力の品質を担保するため、各種フォームコントロールに対して正規表現ベースのバリデーションを適用している。無効な入力値が設定された場合、ユーザーに明確なフィードバックを提供し、デフォルト値に自動復元することで、アプリケーションの安定動作を維持する。この通知により、ユーザーは入力エラーを認識し、正しい形式での入力を促される。

**通知の送信タイミング**：コントロールのValidatingイベント発生時（フォーカスが離れる際など）に、入力値が設定されたパターンにマッチしない場合に表示される。

**通知の受信者**：該当フォームを操作中のユーザー。アプリケーション内通知のため、現在のセッションで操作を行っているユーザーのみが受信する。

**通知内容の概要**：ユーザーが入力した無効な値がダブルクォートで囲まれて表示される。例：「"abc123" is no valid input.」

**期待されるアクション**：ユーザーは通知内容を確認し、正しい形式で値を再入力する。通知後、コントロールの値は自動的にデフォルト値に復元される。

## 通知種別

アプリ内通知（MsgWarnによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

ValidationProviderが設定されたコントロールのValidatingイベント発生時に、バリデーション失敗を検出したユーザーに対して即時モーダルダイアログとして表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | 警告（Warning） |
| アイコン | Warning |
| ボタン | OK |

### 本文テンプレート

```
"{入力値}" is no valid input.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| 入力値 | ユーザーが入力した無効な値 | c.Text | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Control.Validating | Regex.IsMatch(c.Text, Patterns(c)) = False | コントロールのフォーカス離脱時にバリデーション実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| パターン適合 | 入力値が設定された正規表現パターンにマッチする場合 |
| パターン未設定 | コントロールにValidationProviderのパターンが設定されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コントロールのフォーカス離脱] --> B[Validatingイベント発生]
    B --> C{Regex.IsMatchで<br>パターン検証}
    C -->|マッチ| D[処理終了]
    C -->|不一致| E[MsgWarn表示]
    E --> F[デフォルト値に復元]
    F --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Patterns Dictionary | コントロールごとの正規表現パターン | メモリ内辞書 |
| Defaults Dictionary | コントロールごとのデフォルト値 | メモリ内辞書 |

### テーブル別参照項目詳細

#### Patterns（Dictionary(Of Control, String)）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Pattern | バリデーション用正規表現 | Patterns(c)でコントロールをキーに取得 |

#### Defaults（Dictionary(Of Control, String)）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Default | バリデーション失敗時の復元値 | Defaults(c)でコントロールをキーに取得 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Control.Text | UPDATE | デフォルト値への復元 |

#### コントロールテキスト更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | c.Text | Defaults(c) | バリデーション失敗時の自動復元 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 正規表現エラー | 無効な正規表現パターンが設定された場合 | 例外がスローされる可能性あり |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- ユーザー入力値がそのまま通知メッセージに含まれるため、極端に長い入力値の場合はダイアログ表示に影響する可能性がある
- 入力値に悪意のある文字列が含まれる場合でも、文字列として表示されるのみで実行されることはない

## 備考

- ValidationProviderはIExtenderProviderインターフェースを実装したコンポーネントである
- Enterイベントでデフォルト値を記録し、Validatingイベントで検証を行う
- 本コンポーネントはUI名前空間に定義されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ValidationProviderの内部データ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExtenderProviders.vb | `Source/UI/ExtenderProviders.vb` | Patterns, Defaults辞書の定義 |

**読解のコツ**: Dictionary(Of Control, String)型でコントロールごとにパターンとデフォルト値を管理している。

#### Step 2: エントリーポイントを理解する

処理の起点となるイベントハンドラを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExtenderProviders.vb | `Source/UI/ExtenderProviders.vb` | Validatingイベントハンドラ（行36-43） |
| 2-2 | ExtenderProviders.vb | `Source/UI/ExtenderProviders.vb` | Enterイベントハンドラ（行45-48） |

**主要処理フロー**:
1. **行36**: Validatingサブルーチン開始
2. **行37**: Controlへのキャスト
3. **行39**: Regex.IsMatchによるパターン検証
4. **行40**: MsgWarn呼び出しによる警告表示
5. **行41**: デフォルト値への復元

#### Step 3: バリデーションパターン設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExtenderProviders.vb | `Source/UI/ExtenderProviders.vb` | SetPatternメソッド（行27-34） |

**主要処理フロー**:
- **行28-31**: 初回設定時にイベントハンドラを登録
- **行33**: パターンを辞書に格納

### プログラム呼び出し階層図

```
Control.Validating Event
    │
    └─ ValidationProvider.Validating (行36)
           │
           ├─ CType(sender, Control) (行37)
           │
           ├─ Regex.IsMatch(c.Text, Patterns(c)) (行39)
           │
           ├─ MsgWarn (行40)
           │      └─ TaskDialog警告表示
           │
           └─ c.Text = Defaults(c) (行41)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Control.Text ───▶ Regex.IsMatch ───▶ バリデーション結果
                          │
                          └─ 不一致時
                                │
                                ├──▶ MsgWarn表示
                                │
                                └──▶ Defaults(c)で復元
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExtenderProviders.vb | `Source/UI/ExtenderProviders.vb` | ソース | ValidationProviderクラス定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示機能 |
