# 通知設計書 43-フォント未検出警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるシンボルフォント読み込み失敗時に表示される警告通知「Correct font was not found, using default instead!」の設計を記載する。

### 本通知の処理概要

本通知は、ImageHelpクラスのGetSymbolImage関数においてシンボルアイコン生成用のフォント（FontAwesomeまたはSegoe MDL2 Assets）が見つからない場合に表示される警告通知である。

**業務上の目的・背景**：StaxRipはUIのアイコン表示にシンボルフォント（FontAwesome、Segoe MDL2 Assets）を使用している。これらのフォントファイルが欠損または破損している場合、アイコン表示が正しく行われない可能性がある。この通知により、ユーザーはフォント関連の問題を認識し、フォントファイルの再インストールや修復を検討できる。デフォルトフォントへのフォールバック機能により、アプリケーションは動作を継続できる。

**通知の送信タイミング**：GetSymbolImage関数が呼び出され、要求されたシンボルに対応するフォントファミリーがPrivateFontCollectionから見つからない場合に表示される。

**通知の受信者**：アプリケーションを使用中のユーザー。シンボルアイコンが初めて生成される際（UIコンポーネントの初期化時など）に通知が発生する可能性がある。

**通知内容の概要**：フォントが見つからなかったことと、デフォルトフォントで代替することを通知するメッセージ。

**期待されるアクション**：ユーザーはフォントファイルの状態を確認し、必要に応じてStaxRipを再インストールするか、フォントファイルを手動で復元する。通知後、アプリケーションはGenericSerifフォントで処理を継続する。

## 通知種別

アプリ内通知（MsgWarnによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

GetSymbolImage関数実行中のユーザーに対して、フォントファミリー検索失敗時に即時モーダルダイアログとして表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | 警告（Warning） |
| アイコン | Warning |
| ボタン | OK |

### 本文テンプレート

```
Correct font was not found, using default instead!
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | GetSymbolImage呼び出し | Coll.Families.FirstOrDefault結果がNothing | シンボルフォントファミリーが見つからない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| フォントファイル不在 | FontFilesExistがFalseの場合、処理全体がスキップされNothing返却 |
| フォント検出成功 | 要求されたシンボルに対応するフォントファミリーが見つかった場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GetSymbolImage呼び出し] --> B{FontFilesExist?}
    B -->|No| C[Nothing返却]
    B -->|Yes| D[PrivateFontCollection確認/作成]
    D --> E{symbol > 61400?}
    E -->|Yes| F[FontAwesome検索]
    E -->|No| G[Segoe MDL2 Assets検索]
    F --> H{フォントファミリー見つかった?}
    G --> H
    H -->|Yes| I[ビットマップ生成]
    H -->|No| J[MsgWarn表示]
    J --> K[GenericSerifにフォールバック]
    K --> I
    I --> L[Image返却]
    C --> M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| PrivateFontCollection | ロード済みフォントの参照 | 静的変数Coll |
| ファイルシステム | フォントファイルの存在確認 | Folder.Fonts/Icons配下 |

### テーブル別参照項目詳細

#### ファイルシステム参照

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| FontAwesome.ttf | FontAwesomeフォント | Folder.Fonts/Icons/FontAwesome.ttf |
| Segoe-MDL2-Assets.ttf | Segoe MDL2フォント | Folder.Fonts/Icons/Segoe-MDL2-Assets.ttf |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本処理で更新は行わない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| フォント未検出 | フォントファミリーがCollectionに存在しない | MsgWarn表示後、GenericSerifにフォールバック |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（内部処理に応じて発生）

## セキュリティ考慮事項

本通知は固定メッセージであり、ユーザー入力や機密情報を含まない。セキュリティ上の懸念はない。

## 備考

- PrivateFontCollectionは静的変数として保持され、一度ロードされると再利用される
- FontAwesomeはシンボル値61400以上で使用され、それ未満はSegoe MDL2 Assetsが使用される
- フォントファイルが存在しない場合（FontFilesExist = False）は警告なしでNothingが返却される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、フォント管理の仕組みを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ImageUtils.vb | `Source/UI/ImageUtils.vb` | Coll（PrivateFontCollection）、AwesomePath、SegoePath定義 |

**読解のコツ**: Collは静的変数として一度だけ初期化され、フォントファイルパスは定数として定義されている。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ImageUtils.vb | `Source/UI/ImageUtils.vb` | GetSymbolImage関数（行18-59） |

**主要処理フロー**:
1. **行23-25**: FontFilesExistチェック
2. **行27-31**: PrivateFontCollection初期化
3. **行33-35**: シンボル値によるフォントファミリー選択
4. **行37-40**: フォント未検出時の警告とフォールバック
5. **行46-58**: ビットマップ生成

#### Step 3: フォント選択ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ImageUtils.vb | `Source/UI/ImageUtils.vb` | Coll.Families.FirstOrDefault呼び出し（行33-35） |

**主要処理フロー**:
- **行33**: symbol > 61400の判定
- **行34**: FontAwesome検索
- **行35**: Segoe MDL2 Assets検索

### プログラム呼び出し階層図

```
ImageHelp.GetSymbolImage (行18)
    │
    ├─ File.Exists確認 (FontFilesExist)
    │
    ├─ PrivateFontCollection初期化 (行27-31)
    │      ├─ AddFontFile(AwesomePath)
    │      └─ AddFontFile(SegoePath)
    │
    ├─ Coll.Families.FirstOrDefault (行33-35)
    │      └─ フォントファミリー検索
    │
    ├─ MsgWarn (行38)
    │      └─ TaskDialog警告表示
    │
    └─ Bitmap生成 (行46-58)
           └─ Graphics.DrawString
```

### データフロー図

```
[入力]               [処理]                    [出力]

Symbol値 ───▶ GetSymbolImage ───▶ Image/Nothing
                    │
                    ├─ FontFilesExist確認
                    │
                    ├─ フォント選択
                    │      │
                    │      └─ 未検出時 ──▶ MsgWarn表示
                    │                        │
                    │                        └─ GenericSerif代替
                    │
                    └─ Bitmap生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ImageUtils.vb | `Source/UI/ImageUtils.vb` | ソース | ImageHelpクラス、GetSymbolImage関数 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数定義 |
| Folder.vb | `Source/General/` | ソース | Folder.Fontsパス定義 |
| FontAwesome.ttf | `Folder.Fonts/Icons/` | フォント | FontAwesomeシンボルフォント |
| Segoe-MDL2-Assets.ttf | `Folder.Fonts/Icons/` | フォント | Segoe MDL2シンボルフォント |
