# 通知設計書 44-ヒント通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるユーザー向けヒント表示機能「Tip」の設計を記載する。

### 本通知の処理概要

本通知は、Documentationクラスに実装されたShowTip関数により、アプリケーション使用時の有用なヒントやアドバイスをユーザーに一度だけ表示する情報通知機能である。

**業務上の目的・背景**：ユーザーがアプリケーションの機能を効率的に活用できるよう、特定の操作や設定に関するヒントを提供する。同一のヒントが繰り返し表示されることを防ぐため、一度表示されたヒントはMD5ハッシュによって識別され、ストレージに記録される。これにより、ユーザーエクスペリエンスを向上させながら、煩わしい繰り返し通知を回避している。

**通知の送信タイミング**：ShowTip関数が呼び出された際に、そのヒントメッセージが過去に表示されていない場合にのみ表示される。具体的には、音声デコーダとエンコーダが同一の場合のパフォーマンス警告などで使用される。

**通知の受信者**：アプリケーションを使用中のユーザー。特定の条件（例：ffmpegデコーダとffmpegエンコーダを同時使用）を満たした際に通知が発生する。

**通知内容の概要**：タイトル「Tip」とともに、状況に応じた有用な情報やアドバイスが表示される。

**期待されるアクション**：ユーザーはヒント内容を読んで理解し、必要に応じて設定を調整する。通知を閉じると、同一のヒントは再表示されない。

## 通知種別

アプリ内通知（MsgInfoによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | なし |

### 送信先決定ロジック

ShowTip関数呼び出し時に、メッセージのMD5ハッシュをストレージで確認し、未表示の場合のみユーザーに対して即時モーダルダイアログとして表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | 情報（Information） |
| アイコン | Info |
| ボタン | OK |
| タイトル | Tip |

### 本文テンプレート

```
{動的メッセージ}
```

具体例（MainForm.ShowAudioTipより）:
```
Please note that defining an audio decoder will always result in a separate decoding step, which is usually not necessary if the decoder and encoder are identical, it's a waste of time and disk space.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | 表示するヒントメッセージ | 呼び出し元から渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | Documentation.ShowTip呼び出し | s.Storage.GetBool(hash) = False | 同一メッセージが未表示の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 表示済み | 同一メッセージのMD5ハッシュがストレージにTrue記録されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ShowTip呼び出し] --> B[メッセージのMD5ハッシュ計算]
    B --> C{s.Storage.GetBool確認}
    C -->|True| D[処理終了/表示済み]
    C -->|False| E[MsgInfo表示]
    E --> F[s.Storage.SetBool記録]
    F --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| s.Storage | ヒント表示履歴の参照 | Boolean値を保持 |

### テーブル別参照項目詳細

#### s.Storage

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Boolean値 | ヒント表示済みフラグ | GetBool(hash)でMD5ハッシュをキーに取得 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| s.Storage | INSERT/UPDATE | ヒント表示済みフラグの記録 |

#### ストレージ更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| SetBool | MD5ハッシュ | True | ヒント表示後に記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| なし | 本処理は正常系の情報通知であり、エラーケースは想定されていない | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（内部処理に応じて発生）

## セキュリティ考慮事項

本通知は固定またはアプリケーション内部で生成されるメッセージのみを表示し、ユーザー入力や外部データを含まない。セキュリティ上の懸念はない。

## 備考

- MD5ハッシュは拡張メソッドmessage.MD5Hashで計算される
- 一度表示されたヒントはアプリケーション再起動後も再表示されない（永続化）
- 現在の主な使用箇所はMainForm.ShowAudioTipで、ffmpegデコーダ/エンコーダ同時使用時の警告

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ヒント表示履歴の管理方法を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Storage関連 | `Source/General/` | s.Storageの実装とBoolean値の永続化 |

**読解のコツ**: s.StorageはGetBool/SetBoolメソッドでBoolean値を永続的に保存・取得する機能を提供。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Documentation.vb | `Source/General/Documentation.vb` | ShowTip関数（行425-432） |

**主要処理フロー**:
1. **行426**: message.MD5Hashでハッシュ計算
2. **行428**: s.Storage.GetBool(hash)で表示済み確認
3. **行429**: MsgInfo("Tip", message)で通知表示
4. **行430**: s.Storage.SetBool(hash, True)で表示済み記録

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ShowAudioTip関数（行5417-5426） |

**主要処理フロー**:
- **行5421**: ffmpegデコーダ/エンコーダ同時使用条件確認
- **行5422-5425**: Documentation.ShowTip呼び出し

### プログラム呼び出し階層図

```
MainForm.ShowAudioTip (行5417)
    │
    └─ Documentation.ShowTip (行425)
           │
           ├─ message.MD5Hash (行426)
           │      └─ MD5ハッシュ計算
           │
           ├─ s.Storage.GetBool(hash) (行428)
           │      └─ 表示済み確認
           │
           ├─ MsgInfo("Tip", message) (行429)
           │      └─ TaskDialogで情報通知表示
           │
           └─ s.Storage.SetBool(hash, True) (行430)
                  └─ 表示済みフラグ記録
```

### データフロー図

```
[入力]               [処理]                    [出力]

メッセージ文字列 ───▶ ShowTip ───▶ 通知表示（条件付き）
                          │
                          ├─ MD5ハッシュ計算
                          │
                          ├─ Storage確認
                          │      │
                          │      └─ True → 表示スキップ
                          │
                          └─ MsgInfo表示
                                 │
                                 └─ Storage記録
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Documentation.vb | `Source/General/Documentation.vb` | ソース | ShowTip関数定義 |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | ShowAudioTip（呼び出し元の一例） |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数定義 |
| Settings関連 | `Source/General/` | ソース | s.Storage実装 |
