# 通知設計書 45-eac3to失敗エラー

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるeac3toツール実行失敗時に表示されるエラー通知「eac3to failed with error code」の設計を記載する。

### 本通知の処理概要

本通知は、eac3toFormにおいてBlu-ray/DVDディスクのストリーム解析処理でeac3toツールがエラー終了した場合に表示されるエラー通知である。

**業務上の目的・背景**：eac3toはBlu-ray/DVDディスクのオーディオ・ビデオストリームを解析・抽出するための重要な外部ツールである。このツールが失敗した場合、ユーザーは処理を継続できないため、明確なエラー情報を提供し、問題の原因特定と対処を支援する必要がある。エラー終了コードと出力内容を表示することで、技術的なトラブルシューティングを可能にしている。

**通知の送信タイミング**：eac3toFormのAnalyze処理において、eac3toプロセスの終了コードが0以外（エラー）の場合に、UIスレッドへのマーシャリング後に表示される。

**通知の受信者**：eac3toForm（Blu-ray/DVDデマックスフォーム）を操作中のユーザー。

**通知内容の概要**：「eac3to failed with error code {終了コード}」というメッセージと、eac3toツールの標準出力内容が表示される。

**期待されるアクション**：ユーザーはエラーコードと出力内容を確認し、問題の原因（ディスク読み取りエラー、対応していないフォーマット、ツールの設定問題など）を特定する。必要に応じて、別のソースファイルを試すか、eac3toの設定を確認する。

## 通知種別

アプリ内通知（MsgErrorによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（BeginInvoke経由） |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

eac3toFormを操作中のユーザーに対して、eac3toプロセス終了後にUIスレッドで即時モーダルダイアログとして表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | エラー（Error） |
| アイコン | Error |
| ボタン | OK |

### 本文テンプレート

```
eac3to failed with error code {exitCode}
```

追加情報として、eac3toの標準出力（Output）が詳細として表示される。

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| exitCode | eac3toプロセスの終了コード | pr.ExitCode | Yes |
| Output | eac3toの標準出力内容 | OutputDataReceivedで収集 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | eac3toプロセス終了 | pr.ExitCode <> 0 | 終了コードが0以外の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常終了 | pr.ExitCode = 0の場合は通知なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Analyze開始] --> B[eac3toプロセス起動]
    B --> C[OutputDataReceived収集]
    C --> D[pr.WaitForExit]
    D --> E{pr.ExitCode = 0?}
    E -->|Yes| F[Init処理実行]
    E -->|No| G[BeginInvoke実行]
    G --> H[MsgError表示]
    H --> I[Cancel処理]
    F --> J[終了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Package.eac3to | ツールパスの参照 | Package管理 |
| プロセス出力 | 標準出力の収集 | Output変数に蓄積 |

### テーブル別参照項目詳細

#### プロセス情報

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| ExitCode | エラー終了コード | プロセス終了後 |
| StandardOutput | 解析結果/エラー情報 | OutputDataReceivedで収集 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本処理では永続化更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| eac3toエラー終了 | ExitCode <> 0 | MsgError表示後、Cancel処理でフォームクローズ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（処理に応じて発生）

## セキュリティ考慮事項

- 外部ツール（eac3to）の出力内容がそのまま表示されるため、出力に含まれるファイルパス情報がユーザーに開示される
- ローカル処理のため、外部への情報漏洩リスクはない

## 備考

- BeginInvokeによりUIスレッドにマーシャリングされてから通知が表示される
- Cancel()呼び出しにより、エラー後は自動的にフォームがクローズされる
- 出力内容はProject.Log.WriteLineでログにも記録される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、eac3toFormで使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Output変数、M2TSFile、PlaylistFolder等のフィールド定義 |

**読解のコツ**: Outputは文字列変数で、OutputDataReceivedイベントで行ごとに追加される。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Analyzeサブルーチン（行720付近〜） |

**主要処理フロー**:
1. **行737-745**: Processの設定と起動
2. **行746**: pr.WaitForExit()で終了待機
3. **行748-754**: ExitCodeチェックとBeginInvokeによるエラー通知
4. **行752**: MsgError呼び出し

#### Step 3: 出力収集メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | OutputDataReceivedイベントハンドラ（行769-778） |

**主要処理フロー**:
- **行771-776**: 進捗表示とOutput変数への蓄積

### プログラム呼び出し階層図

```
eac3toForm.Analyze
    │
    ├─ Package.eac3to.Path参照 (行739)
    │
    ├─ Process.Start (行744)
    │
    ├─ OutputDataReceived (行769)
    │      └─ Output += e.Data + BR
    │
    ├─ pr.WaitForExit (行746)
    │
    └─ ExitCode確認 (行748)
           │
           └─ <> 0の場合
                  │
                  ├─ BeginInvoke (行751)
                  │      └─ MsgError (行752)
                  │
                  └─ Cancel (行753)
```

### データフロー図

```
[入力]               [処理]                    [出力]

M2TSFile/Playlist ───▶ eac3toプロセス ───▶ Output収集
                            │
                            └─ ExitCode確認
                                   │
                                   └─ <> 0
                                          │
                                          └─ MsgError表示
                                                 │
                                                 └─ Cancel実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| eac3toForm.vb | `Source/Forms/eac3toForm.vb` | ソース | eac3to操作フォーム |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数定義 |
| Package.vb | `Source/General/` | ソース | Package.eac3toツール管理 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示機能 |
