# 通知設計書 46-eac3to空出力警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるeac3toツールの出力が空の場合に表示される警告通知「eac3to output was empty」の設計を記載する。

### 本通知の処理概要

本通知は、eac3toFormにおいてBlu-ray/DVDディスクのストリーム解析処理でeac3toツールが正常終了（ExitCode = 0）したにもかかわらず、標準出力が空の場合に表示される警告通知である。

**業務上の目的・背景**：eac3toツールは通常、解析結果としてストリーム情報を標準出力に出力する。正常終了しても出力が空の場合、解析対象のファイルやディスクに問題がある可能性がある。この通知により、ユーザーは期待した結果が得られていないことを認識し、入力ソースの確認や別のアプローチを検討できる。

**通知の送信タイミング**：eac3toFormのInit処理において、Output変数が空文字列の場合に表示される。

**通知の受信者**：eac3toForm（Blu-ray/DVDデマックスフォーム）を操作中のユーザー。

**通知内容の概要**：eac3toの出力が空であることを示す固定メッセージ。

**期待されるアクション**：ユーザーは入力ソース（M2TSファイルまたはプレイリスト）の状態を確認し、正しいファイルが選択されているか、ディスクが正しく読み込まれているかを検証する。必要に応じて、別のファイルやプレイリストを試す。

## 通知種別

アプリ内通知（MsgWarnによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

eac3toFormを操作中のユーザーに対して、Init処理中にOutput確認後に即時モーダルダイアログとして表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | 警告（Warning） |
| アイコン | Warning |
| ボタン | OK |

### 本文テンプレート

```
eac3to output was empty
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | Init処理実行 | Output = "" | 標準出力が空文字列の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 出力あり | Output変数に何らかの文字列が含まれている場合 |
| エラー終了 | eac3toがエラー終了した場合（別のエラー通知が表示される） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Init処理開始] --> B[コントロール有効化]
    B --> C{Output = ""?}
    C -->|Yes| D[MsgWarn表示]
    D --> E[Cancel処理]
    C -->|No| F{3D検出?}
    F -->|Yes| G[別エラー処理]
    F -->|No| H[ストリーム解析処理]
    E --> I[終了]
    G --> I
    H --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Output変数 | eac3to標準出力の確認 | フォームレベル変数 |

### テーブル別参照項目詳細

#### Output変数

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Output | 空判定 | Output = ""で確認 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本処理では永続化更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 空出力 | Output = "" | MsgWarn表示後、Cancel処理でフォームクローズ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（処理に応じて発生）

## セキュリティ考慮事項

本通知は固定メッセージであり、機密情報を含まない。セキュリティ上の懸念はない。

## 備考

- 本通知はeac3toが正常終了（ExitCode = 0）した後のInit処理で発生する
- Cancel()呼び出しにより、警告表示後は自動的にフォームがクローズされる
- 空出力は稀なケースであり、通常はファイル/ディスクの問題を示唆する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Output変数の役割を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Output変数の宣言と使用箇所 |

**読解のコツ**: OutputはOutputDataReceivedイベントで蓄積され、Init処理で判定・使用される。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Initサブルーチン（行780-829） |

**主要処理フロー**:
1. **行781-783**: コントロールの有効化
2. **行785-787**: Output空判定とMsgWarn表示
3. **行788-790**: 3Dコンテンツ検出とMsgError表示
4. **行791以降**: ストリーム解析処理

#### Step 3: 処理フローの分岐を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | If-ElseIf分岐構造（行785-791） |

**主要処理フロー**:
- **行785**: Output = ""の判定
- **行786**: MsgWarn("eac3to output was empty")
- **行787**: Cancel()呼び出し

### プログラム呼び出し階層図

```
eac3toForm.Analyze → BeginInvoke(Sub() Init())
    │
    └─ eac3toForm.Init (行780)
           │
           ├─ コントロール有効化 (行781-783)
           │
           └─ Output判定 (行785)
                  │
                  └─ 空の場合
                         │
                         ├─ MsgWarn (行786)
                         │
                         └─ Cancel (行787)
```

### データフロー図

```
[入力]               [処理]                    [出力]

eac3to完了 ───▶ Init処理 ───▶ Output判定
                    │
                    └─ Output = ""
                           │
                           ├──▶ MsgWarn表示
                           │
                           └──▶ Cancel実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| eac3toForm.vb | `Source/Forms/eac3toForm.vb` | ソース | eac3to操作フォーム |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示機能 |
