# 通知設計書 47-3D非対応エラー

## 概要

本ドキュメントは、StaxRipアプリケーションにおける3Dコンテンツのデマックス処理が非対応であることを通知するエラー「3D demuxing isn't supported.」の設計を記載する。

### 本通知の処理概要

本通知は、eac3toFormにおいてBlu-rayディスクの解析結果に3Dコンテンツ（左目/右目の映像ストリーム）が検出された場合に表示されるエラー通知である。

**業務上の目的・背景**：StaxRipは3Dコンテンツのデマックス処理をサポートしていない。3D Blu-rayディスクは左目（left eye）と右目（right eye）の2つの映像ストリームを含むが、これらを適切に処理するには特殊な対応が必要であり、現時点では実装されていない。この通知により、ユーザーは処理不可能なコンテンツであることを認識し、2Dコンテンツを使用するか、別のツールを検討できる。

**通知の送信タイミング**：eac3toFormのInit処理において、eac3toの出力に「left eye」と「right eye」の両方が含まれている場合に表示される。

**通知の受信者**：eac3toForm（Blu-ray/DVDデマックスフォーム）を操作中のユーザー。

**通知内容の概要**：3Dデマックスがサポートされていないことを示す固定メッセージ。

**期待されるアクション**：ユーザーは3D非対応を理解し、2Dバージョンのコンテンツを選択するか、3D対応の別ツールを使用する。処理は自動的にキャンセルされる。

## 通知種別

アプリ内通知（MsgErrorによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

eac3toFormを操作中のユーザーに対して、3Dコンテンツ検出時に即時モーダルダイアログとして表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | エラー（Error） |
| アイコン | Error |
| ボタン | OK |

### 本文テンプレート

```
3D demuxing isn't supported.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | Init処理実行 | Output.ContainsAll("left eye", "right eye") | 3D映像ストリーム検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 2Dコンテンツ | 「left eye」「right eye」の両方が含まれていない場合 |
| 空出力 | Output = ""の場合（別の警告が表示される） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Init処理開始] --> B[コントロール有効化]
    B --> C{Output = ""?}
    C -->|Yes| D[空出力警告]
    C -->|No| E{ContainsAll 3D?}
    E -->|Yes| F[MsgError表示]
    F --> G[Cancel処理]
    E -->|No| H[ストリーム解析処理]
    D --> I[終了]
    G --> I
    H --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Output変数 | eac3to標準出力の検査 | フォームレベル変数 |

### テーブル別参照項目詳細

#### Output変数

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Output | 3D検出 | ContainsAll("left eye", "right eye") |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本処理では永続化更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 3D検出 | ContainsAll("left eye", "right eye") | MsgError表示後、Cancel処理でフォームクローズ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（処理に応じて発生）

## セキュリティ考慮事項

本通知は固定メッセージであり、機密情報を含まない。セキュリティ上の懸念はない。

## 備考

- ContainsAllは拡張メソッドで、指定した全ての文字列が含まれているかを判定
- 「left eye」「right eye」は3D Blu-rayのeac3to出力における特徴的なキーワード
- 3Dサポートは技術的に可能だが、需要と開発コストの観点から現時点では未実装

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、3D検出の仕組みを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Output変数と3D検出ロジック |

**読解のコツ**: ContainsAll拡張メソッドは複数の文字列が全て含まれているかを判定する便利メソッド。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Initサブルーチン（行788-790） |

**主要処理フロー**:
1. **行788**: Output.ContainsAll("left eye", "right eye")判定
2. **行789**: MsgError("3D demuxing isn't supported.")
3. **行790**: Cancel()呼び出し

#### Step 3: 3Dコンテンツの特徴を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | eac3to出力サンプル | - | 3D Blu-rayの典型的な出力パターン |

**読解のコツ**: 3D Blu-rayでは左目用と右目用の2つの映像ストリームが含まれる。

### プログラム呼び出し階層図

```
eac3toForm.Init (行780)
    │
    ├─ コントロール有効化 (行781-783)
    │
    ├─ Output = ""判定 (行785)
    │
    └─ ContainsAll判定 (行788)
           │
           └─ 3D検出時
                  │
                  ├─ MsgError (行789)
                  │
                  └─ Cancel (行790)
```

### データフロー図

```
[入力]               [処理]                    [出力]

eac3to Output ───▶ Init処理 ───▶ 3D判定
                        │
                        └─ "left eye" AND "right eye"
                               │
                               ├──▶ MsgError表示
                               │
                               └──▶ Cancel実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| eac3toForm.vb | `Source/Forms/eac3toForm.vb` | ソース | eac3to操作フォーム |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数定義 |
| StringExtensions | `Source/General/` | ソース | ContainsAll拡張メソッド |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示機能 |
