# 通知設計書 48-コマンドラインコピー通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるコマンドラインのクリップボードコピー完了時に表示される情報通知「Command Line was copied.」の設計を記載する。

### 本通知の処理概要

本通知は、CommandLineFormにおいてユーザーがコマンドラインをクリップボードにコピーした際に表示される情報通知である。

**業務上の目的・背景**：ビデオエンコーダーのコマンドラインは、外部ツールでの実行、デバッグ、他ユーザーへの共有など、様々な用途で必要とされる。コマンドラインコピー機能により、ユーザーは現在の設定に基づいた完全なコマンドラインを簡単に取得できる。この通知により、コピー操作が成功したことを明確にフィードバックし、ユーザーが安心して次の操作に進めるようにしている。

**通知の送信タイミング**：CommandLineFormのコンテキストメニューから「Copy Command Line」を選択した際、またはショートカットキー（Ctrl+Shift+C）を使用した際に表示される。

**通知の受信者**：CommandLineForm（ビデオエンコーダー設定フォーム）を操作中のユーザー。

**通知内容の概要**：コマンドラインがクリップボードにコピーされたことを示す固定メッセージ。

**期待されるアクション**：ユーザーはコピー成功を確認し、コマンドプロンプトやPowerShellなどに貼り付けて使用するか、ドキュメントに保存する。

## 通知種別

アプリ内通知（MsgInfoによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | なし |

### 送信先決定ロジック

CommandLineFormを操作中のユーザーに対して、コピー操作完了後に即時モーダルダイアログとして表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | 情報（Information） |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
Command Line was copied.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Copy Command Lineメニュー選択 | Clipboard.SetText成功後 | Ctrl+Shift+Cでも実行可能 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | コピー操作成功時は常に表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Copy Command Line選択/Ctrl+Shift+C] --> B[params.GetCommandLine取得]
    B --> C[Clipboard.SetText実行]
    C --> D[MsgInfo表示]
    D --> E[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| params | コマンドラインパラメータの参照 | CommandLineParamsオブジェクト |

### テーブル別参照項目詳細

#### CommandLineParams

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| GetCommandLine(True, True) | 完全なコマンドラインの取得 | 展開済み、引用符付き |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Windowsクリップボード | SET | コマンドライン文字列の設定 |

#### クリップボード更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| SetText | Text | params.GetCommandLine(True, True) | システムクリップボードへの書き込み |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| クリップボードアクセスエラー | 他アプリがクリップボードをロック中 | 例外が発生する可能性あり（未処理） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて発生）

## セキュリティ考慮事項

- コマンドラインにはファイルパスが含まれる可能性があり、クリップボード経由で他アプリケーションに渡される
- ローカル操作のため、外部への情報漏洩リスクは低い
- クリップボード履歴機能を持つ他アプリケーションに情報が残る可能性がある

## 備考

- ショートカットキーはCtrl+Shift+Cで設定されている
- GetCommandLine(True, True)は第1引数で展開、第2引数で引用符処理を指定
- コンテキストメニューにはSymbol.Copyのアイコンが設定されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、CommandLineParamsの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CommandLineParams | `Source/Encoding/` | GetCommandLineメソッドの実装 |

**読解のコツ**: GetCommandLineは引数に応じてマクロ展開や引用符処理を行う。

#### Step 2: エントリーポイントを理解する

処理の起点となるイベント定義を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | コンストラクタ内のメニュー設定（行55-58） |

**主要処理フロー**:
1. **行55-58**: ラムダ式でコピー処理を定義
2. **行56**: Clipboard.SetText呼び出し
3. **行57**: MsgInfo("Command Line was copied.")呼び出し
4. **行60**: メニュー項目の追加（Ctrl+Shift+Cショートカット）

#### Step 3: メニュー構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | cmsメニュー設定全体（行51-62） |

**主要処理フロー**:
- **行53**: Execute Command Line
- **行60**: Copy Command Line
- **行61**: Show Command Line...
- **行62**: Import Command Line...

### プログラム呼び出し階層図

```
cms.Add("Copy Command Line", a, Keys.Control Or Keys.Shift Or Keys.C)
    │
    └─ ラムダ式 a (行55-58)
           │
           ├─ params.GetCommandLine(True, True) (行56)
           │      └─ コマンドライン文字列生成
           │
           ├─ Clipboard.SetText (行56)
           │      └─ クリップボードへコピー
           │
           └─ MsgInfo (行57)
                  └─ TaskDialog情報通知表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

メニュー選択 ───▶ ラムダ式実行 ───▶ クリップボード
/Ctrl+Shift+C          │
                       ├─ GetCommandLine
                       │
                       ├─ SetText
                       │
                       └─ MsgInfo表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | ソース | コマンドライン設定フォーム |
| CommandLineParams | `Source/Encoding/` | ソース | コマンドラインパラメータ管理 |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示機能 |
