# 通知設計書 49-再起動要求通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける設定変更後の再起動要求を通知する「Please restart StaxRip.」の設計を記載する。

### 本通知の処理概要

本通知は、MainForm_ShowSettings（設定ダイアログ）において、アプリケーションの再起動が必要な設定変更が行われた場合に表示される情報通知である。

**業務上の目的・背景**：一部の設定変更（AviSynthモード、VapourSynthモードなど）は、アプリケーション起動時に初期化される内部状態に影響を与えるため、変更を完全に反映するには再起動が必要である。この通知により、ユーザーは設定変更が認識されたが即時反映されないことを理解し、適切なタイミングでアプリケーションを再起動できる。

**通知の送信タイミング**：設定ダイアログが閉じられる際（DialogResult.OK時）に、再起動が必要な設定項目が変更されていた場合に表示される。GetRestartId関数で設定変更前後の状態を比較して判定する。

**通知の受信者**：設定ダイアログを操作したユーザー。

**通知内容の概要**：StaxRipの再起動を求める固定メッセージ。

**期待されるアクション**：ユーザーは通知を確認し、現在の作業を保存した後、アプリケーションを再起動する。即時の再起動が不可能な場合は、一部の設定が反映されない可能性があることを認識した上で作業を継続する。

## 通知種別

アプリ内通知（MsgInfoによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

設定ダイアログを閉じたユーザーに対して、再起動必要判定後に即時モーダルダイアログとして表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | 情報（Information） |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
Please restart StaxRip.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 設定ダイアログOK | restartId <> GetRestartId() | 再起動必要な設定が変更された場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 設定変更なし | restartId = GetRestartId()（設定変更前後で同一） |
| キャンセル | DialogResult.Cancelで閉じた場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[設定ダイアログ表示前] --> B[restartId = GetRestartId]
    B --> C[設定ダイアログ表示]
    C --> D{DialogResult?}
    D -->|Cancel| E[処理終了]
    D -->|OK| F[設定保存処理]
    F --> G{restartId <> GetRestartId?}
    G -->|No| E
    G -->|Yes| H[MsgInfo表示]
    H --> E
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| s.AviSynthMode | 再起動判定用 | 設定値 |
| s.VapourSynthMode | 再起動判定用 | 設定値 |

### テーブル別参照項目詳細

#### GetRestartId関数

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| s.AviSynthMode | 再起動ID生成 | 文字列結合 |
| s.VapourSynthMode | 再起動ID生成 | 文字列結合 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理では設定保存は別処理で実行済み |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| なし | 本処理は正常系の情報通知であり、エラーケースは想定されていない | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて発生）

## セキュリティ考慮事項

本通知は固定メッセージであり、機密情報を含まない。セキュリティ上の懸念はない。

## 備考

- GetRestartIdはs.AviSynthModeとs.VapourSynthModeを結合した文字列を返す
- 将来的に再起動が必要な設定項目が追加された場合、GetRestartId関数の拡張が必要
- 自動再起動機能は現時点では実装されていない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、再起動判定に使用される設定項目を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Settings関連 | `Source/General/` | s.AviSynthMode、s.VapourSynthModeの定義 |

**読解のコツ**: これらの設定はフレームサーバーの動作モードを制御し、起動時に初期化される。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm_ShowSettings.vb | `Source/Forms/MainForm_ShowSettings.vb` | ShowSettings関数の終了処理（行514-516） |

**主要処理フロー**:
1. **行514**: restartId <> GetRestartId()の判定
2. **行515**: MsgInfo("Please restart StaxRip.")呼び出し

#### Step 3: GetRestartId関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm_ShowSettings.vb | `Source/Forms/MainForm_ShowSettings.vb` | GetRestartId関数（行522-524） |

**主要処理フロー**:
- **行523**: Return s.AviSynthMode & s.VapourSynthMode

### プログラム呼び出し階層図

```
MainForm.ShowSettings (別の場所で開始)
    │
    ├─ restartId = GetRestartId() (ダイアログ表示前)
    │
    ├─ 設定ダイアログ表示・操作
    │
    └─ ダイアログ終了時 (行514)
           │
           └─ restartId <> GetRestartId()判定
                  │
                  └─ True の場合
                         │
                         └─ MsgInfo (行515)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ダイアログ表示前 ───▶ GetRestartId() ───▶ restartId保存
                                            │
設定変更・OK ───▶ GetRestartId() ───▶ 比較
                                            │
                                            └─ 不一致時
                                                   │
                                                   └─ MsgInfo表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm_ShowSettings.vb | `Source/Forms/MainForm_ShowSettings.vb` | ソース | 設定ダイアログ処理 |
| Settings | `Source/General/` | ソース | s.AviSynthMode等の設定管理 |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示機能 |
