# 通知設計書 5-MsgOK

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるOK/Cancel確認ダイアログ通知「MsgOK」の設計仕様を定義する。MsgOKは、MsgQuestionのラッパー関数として、シンプルなOK/Cancel確認をBoolean戻り値で提供する便利関数である。

### 本通知の処理概要

MsgOK通知は、単純なYes/No形式の確認を求める場面で使用される簡便な通知メカニズムである。

**業務上の目的・背景**：MsgQuestionと同様にユーザー確認を行うが、戻り値をBooleanに変換することで、呼び出し元のコードをシンプルに保つことができる。If文での条件判定が直感的になり、コードの可読性が向上する。「このまま続行しますか?」「実行してよろしいですか?」などの単純な確認に最適。

**通知の送信タイミング**：ユーザーの確認が必要な操作が開始される前に同期的に表示される。ユーザーがボタンをクリックして応答するまで、呼び出し元の処理はブロックされる。

**通知の受信者**：現在アプリケーションを操作しているユーザー。タスクダイアログはモーダルダイアログとして表示され、応答が必須となる。

**通知内容の概要**：質問タイトルのみで構成される（contentは指定不可）。Questionアイコン（青い疑問符マーク）が表示され、OKボタンとCancelボタンが配置される。

**期待されるアクション**：ユーザーは質問内容を確認し、続行する場合はOKを、キャンセルする場合はCancelをクリックする。OKクリック時はTrueが返され、それ以外はFalseが返される。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

現在のフォアグラウンドウィンドウのオーナーとして表示される。MsgQuestionを内部で呼び出し、その結果をBoolean値に変換する。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内通知のため）

### 本文テンプレート

```
[タイトル]
{title パラメータの値}

[コンテンツ]
（なし - MsgOKではcontentは使用されない）

[アイコン]
Question（青い疑問符アイコン）

[ボタン]
[OK] [Cancel]
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 確認メッセージのタイトルテキスト | 呼び出し元から渡されるString型 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | MsgOK関数の呼び出し | なし（常に表示） | コード内でMsgOK()が呼び出された時点で表示 |
| 画面操作 | 各種続行確認 | ユーザー確認が必要な操作時 | Boolean結果が必要な簡易確認で使用 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | MsgOKは呼び出し時に常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MsgOK呼び出し] --> B[MsgQuestion呼び出し]
    B --> C[title, Nothing, TaskButton.OkCancel]
    C --> D[Msg関数呼び出し]
    D --> E[TaskDialogインスタンス生成]
    E --> F[Icon = TaskIcon.Question設定]
    F --> G[Title設定]
    G --> H[Buttons = OkCancel設定]
    H --> I[Show呼び出し]
    I --> J[ダイアログ表示]
    J --> K{ユーザー選択}
    K -->|OK| L[DialogResult.OK]
    K -->|Cancel| M[DialogResult.Cancel]
    L --> N[DialogResult.OK比較]
    M --> N
    N --> O{= DialogResult.OK?}
    O -->|Yes| P[True返却]
    O -->|No| Q[False返却]
    P --> R[終了]
    Q --> R
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（MsgOKはデータベースを参照しない）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

#### 送信ログテーブル

該当なし（MsgOKは送信ログを記録しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 表示失敗 | ウィンドウハンドル取得失敗 | スクリーン中央に表示 |
| パラメータエラー | titleが空 | 空のタイトルでダイアログを表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（アプリケーション動作中は常に表示可能）

## セキュリティ考慮事項

- 確認ダイアログはモーダル表示のため、バイパスされることはない
- Boolean戻り値により、プログラム的な条件分岐が明確になる

## 備考

- MsgOKはMsgQuestionのラッパー関数で、コードの簡潔化に貢献
- contentパラメータは内部的にNothingが渡される
- If MsgOK("確認") Then ... のような直感的な記述が可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MsgOKが返すBoolean値とDialogResultの関係を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | MsgOK関数の戻り値がBooleanであることを確認 |

**読解のコツ**: MsgOKは単純な比較演算（= DialogResult.OK）でBoolean値を返すため、ロジックは非常にシンプル。

#### Step 2: エントリーポイントを理解する

MsgOK関数の定義とMsgQuestionへの委譲を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | General.vb | `Source/General/General.vb` | MsgOK関数の定義（行1257-1259） |

**主要処理フロー**:
1. **行1257**: Function MsgOK(title As String) As Boolean
2. **行1258**: Msg関数を呼び出し、結果をDialogResult.OKと比較
3. **行1258**: TaskIcon.Question, TaskButton.OkCancelを指定

#### Step 3: 内部呼び出しの流れを理解する

MsgOKからMsg関数への呼び出しフローを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | Msg関数の定義（行1274-1282）との関係 |

**主要処理フロー**:
- **行1258**: Msg(title, Nothing, TaskIcon.Question, TaskButton.OkCancel)
- **行1274-1282**: Msg関数がTaskDialogを生成して表示
- 戻り値のDialogResultがDialogResult.OKかどうかで True/False を決定

### プログラム呼び出し階層図

```
MsgOK(title)  [General.vb:1257]
    |
    +-- Msg(title, Nothing, TaskIcon.Question, TaskButton.OkCancel)  [General.vb:1274]
    |      |
    |      +-- New TaskDialog(Of DialogResult)()  [TaskDialog.vb:8]
    |      |
    |      +-- TaskDialog.Icon = TaskIcon.Question
    |      +-- TaskDialog.Title = title
    |      +-- TaskDialog.Content = Nothing
    |      +-- TaskDialog.Buttons = TaskButton.OkCancel
    |      |
    |      +-- TaskDialog.Show()  [TaskDialog.vb:552]
    |             |
    |             +-- ShowDialog()  [TaskDialog.vb:557]
    |             |
    |             +-- Return DialogResult (OK or Cancel)
    |
    +-- (Msg() = DialogResult.OK)
    |
    +-- Return Boolean (True / False)
```

### データフロー図

```
[入力]               [処理]                    [出力]

title (String) ────> Msg関数呼び出し ───────> TaskDialog.Title設定
                          |
Nothing ───────────> Content = Nothing ────> コンテンツなし
                          |
TaskButton.OkCancel > Buttonsプロパティ ───> [OK][Cancel]ボタン
                          |
TaskIcon.Question ──> Icon設定 ────────────> pbIcon.Image
                          |
                    ShowDialog() ─────────> [画面表示]
                          |
                    ユーザー選択 ─────────> DialogResult
                          |
                    = DialogResult.OK? ───> Boolean変換
                          |
                    Return Boolean ───────> [戻り値]
                          |
                    True (OK) / False (Cancel)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| General.vb | `Source/General/General.vb` | ソース | MsgOK関数の定義（MainModule内） |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | TaskDialog(Of T)クラス、実際のダイアログ表示 |
| StockIcon.vb | `Source/UI/StockIcon.vb` | ソース | Questionアイコン取得ユーティリティ |
