# 通知設計書 50-プロファイル保存通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるオーディオプロファイル保存完了時に表示される情報通知「The profile was saved.」の設計を記載する。

### 本通知の処理概要

本通知は、AudioFormおよびCommandLineAudioEncoderFormにおいてユーザーがオーディオプロファイルを保存した際に表示される情報通知である。

**業務上の目的・背景**：オーディオエンコード設定は複雑で、同じ設定を繰り返し使用することが多い。プロファイル機能により、ユーザーは設定をカスタムプロファイルとして保存し、後で再利用できる。この通知により、プロファイル保存操作が成功したことを明確にフィードバックし、ユーザーが設定を失わないことを確認できる。

**通知の送信タイミング**：AudioFormまたはCommandLineAudioEncoderFormのSaveProfile処理において、プロファイル名入力後、保存処理が完了した際に表示される。

**通知の受信者**：AudioFormまたはCommandLineAudioEncoderFormを操作中のユーザー。

**通知内容の概要**：プロファイルが保存されたことを示す固定メッセージ。

**期待されるアクション**：ユーザーは保存成功を確認し、プロファイル選択画面などで保存したプロファイルが利用可能になったことを確認する。

## 通知種別

アプリ内通知（MsgInfoによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | なし |

### 送信先決定ロジック

オーディオプロファイル保存操作を実行したユーザーに対して、保存処理完了後に即時モーダルダイアログとして表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | 情報（Information） |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
The profile was saved.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | SaveProfile実行 | name <> ""（プロファイル名が入力された場合） | プロファイル保存処理完了時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 名前未入力 | InputBoxでプロファイル名が入力されなかった（空またはキャンセル）場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SaveProfile呼び出し] --> B[ObjectHelp.GetCopyでプロファイルコピー]
    B --> C[InputBoxでプロファイル名入力]
    C --> D{name <> ""?}
    D -->|No| E[処理終了]
    D -->|Yes| F[gap.Name = name設定]
    F --> G[s.AudioProfiles.Add]
    G --> H[g.SaveAudioProfiles]
    H --> I[MsgInfo表示]
    I --> E
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| TempProfile | 保存対象プロファイルのソース | フォームレベル変数 |

### テーブル別参照項目詳細

#### TempProfile（GUIAudioProfile/CommandLineAudioProfile）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| 全プロパティ | プロファイルコピー元 | ObjectHelp.GetCopy |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| s.AudioProfiles | ADD | 新しいプロファイルの追加 |
| 設定ファイル | SAVE | g.SaveAudioProfilesで永続化 |

#### プロファイル追加

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| Add | プロファイル | gap | s.AudioProfiles.Addで追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 名前未入力 | InputBoxが空で閉じられた | 処理中断（通知なし） |
| 保存失敗 | ファイルシステムエラー等 | 例外発生の可能性（現行は未処理） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて発生）

## セキュリティ考慮事項

- プロファイルにはエンコード設定情報が含まれるが、機密性の高い情報は含まれない
- プロファイルファイルはローカルに保存されるため、外部への情報漏洩リスクは低い

## 備考

- AudioFormとCommandLineAudioEncoderFormの両方で同一のメッセージが使用される
- プロファイル名はInputBox.Showで入力を受け付ける
- AudioFormではgap.Clean()が追加で呼び出される（不要なデータのクリーンアップ）
- 保存されたプロファイルはアプリケーション再起動後も利用可能（永続化）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、オーディオプロファイルの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Audio関連 | `Source/Encoding/` | GUIAudioProfile、CommandLineAudioProfileクラス定義 |

**読解のコツ**: プロファイルはエンコード設定、コーデック選択、ビットレートなどの情報を保持する。

#### Step 2: エントリーポイントを理解する（AudioForm）

処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AudioForm.vb | `Source/Forms/AudioForm.vb` | SaveProfile関数（行1142-1153） |

**主要処理フロー**:
1. **行1143**: ObjectHelp.GetCopy(TempProfile)でコピー作成
2. **行1144**: InputBox.Show("Enter the profile name", gap.Name)
3. **行1146-1150**: 名前入力時の保存処理
4. **行1148**: gap.Clean()（AudioForm固有）
5. **行1149**: s.AudioProfiles.Add(gap)
6. **行1150**: g.SaveAudioProfiles()
7. **行1151**: MsgInfo("The profile was saved.")

#### Step 3: エントリーポイントを理解する（CommandLineAudioEncoderForm）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommandLineAudioEncoderForm.vb | `Source/Forms/CommandLineAudioEncoderForm.vb` | SaveProfile関数（行523-533） |

**主要処理フロー**:
1. **行524**: ObjectHelp.GetCopy(TempProfile)でコピー作成
2. **行525**: InputBox.Show("Enter the profile name", gap.Name)
3. **行527-531**: 名前入力時の保存処理
4. **行528**: gap.Name = name
5. **行529**: s.AudioProfiles.Add(gap)
6. **行530**: g.SaveAudioProfiles()
7. **行531**: MsgInfo("The profile was saved.")

### プログラム呼び出し階層図

```
SaveProfile (両フォーム共通構造)
    │
    ├─ ObjectHelp.GetCopy(TempProfile)
    │      └─ プロファイルのディープコピー
    │
    ├─ InputBox.Show
    │      └─ プロファイル名入力ダイアログ
    │
    ├─ name <> "" 判定
    │
    ├─ gap.Name = name
    │
    ├─ [AudioFormのみ] gap.Clean()
    │
    ├─ s.AudioProfiles.Add(gap)
    │      └─ プロファイルリストへ追加
    │
    ├─ g.SaveAudioProfiles()
    │      └─ 設定ファイルへ永続化
    │
    └─ MsgInfo("The profile was saved.")
           └─ TaskDialog情報通知表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

TempProfile ───▶ ObjectHelp.GetCopy ───▶ gap（コピー）
                         │
                         └─ InputBox
                                │
                                └─ プロファイル名
                                       │
                                       └─ s.AudioProfiles.Add
                                              │
                                              └─ g.SaveAudioProfiles
                                                     │
                                                     └─ MsgInfo表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AudioForm.vb | `Source/Forms/AudioForm.vb` | ソース | オーディオ設定フォーム |
| CommandLineAudioEncoderForm.vb | `Source/Forms/CommandLineAudioEncoderForm.vb` | ソース | コマンドラインオーディオエンコーダーフォーム |
| GUIAudioProfile | `Source/Encoding/` | ソース | GUIオーディオプロファイルクラス |
| ObjectHelp | `Source/General/` | ソース | GetCopyメソッド（ディープコピー） |
| InputBox | `Source/UI/` | ソース | 入力ダイアログ |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数、g.SaveAudioProfiles |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示機能 |
