# 通知設計書 51-プロジェクトファイル不在警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「プロジェクトファイル不在警告」通知の設計仕様を定義する。

### 本通知の処理概要

プロジェクトファイル不在警告は、ユーザーが指定したプロジェクトファイル（.srip）が存在しない場合に、警告ダイアログを表示してユーザーに通知する機能である。

**業務上の目的・背景**：StaxRipでは、ユーザーが過去に作成したプロジェクトファイルを開く機能を提供している。しかし、ファイルが移動・削除・名前変更された場合、指定されたパスにファイルが存在しない状況が発生する。この通知は、ユーザーに対してファイルが見つからないことを明確に伝え、適切な対応（ファイルの再選択やパスの確認）を促すために必要である。

**通知の送信タイミング**：LoadProject関数が呼び出された際に、File.Exists(path)がFalseを返した場合にトリガーされる。具体的には、最近使用したプロジェクトメニューからの選択時やプロジェクトを開くダイアログからの選択時に発生する。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。ダイアログは現在アクティブなメインウィンドウ上に表示される。

**通知内容の概要**：タイトルとして「Project file not found.」、詳細内容として該当ファイルパスと「could not be found.」のメッセージが表示される。

**期待されるアクション**：ユーザーはOKボタンを押してダイアログを閉じ、正しいプロジェクトファイルを再度選択するか、ファイルの存在を確認する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。送信先の決定ロジックは不要（単一ユーザー向けデスクトップアプリケーション）。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | Project file not found. |
| ボタン | OK |

### 本文テンプレート

```
{ファイルパス}
could not be found.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| path | プロジェクトファイルのパス | LoadProject関数の引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | LoadProject関数の呼び出し | File.Exists(path) = False | プロジェクトファイルが指定パスに存在しない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ファイルが存在する場合 | File.Exists(path)がTrueの場合は通知を表示しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[LoadProject関数呼び出し] --> B[SetLastModifiedTemplate実行]
    B --> C[Refresh実行]
    C --> D{File.Exists確認}
    D -->|ファイル不存在| E[MsgWarn呼び出し]
    E --> F[RecentProjects更新]
    F --> G[メニュー更新]
    G --> H[False返却]
    D -->|ファイル存在| I[OpenProject実行]
    I --> J[結果返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ローカルファイルシステムの確認のみ）

### 更新テーブル一覧

該当なし

### 設定更新

| 対象 | 操作 | 概要 |
|-----|------|------|
| s.RecentProjects | UPDATE | 存在しないプロジェクトを最近使用したリストから更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル不存在 | 指定パスにファイルがない | 警告表示後、処理を中断しFalseを返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

ファイルパスにはユーザーの個人情報（ユーザー名等）が含まれる可能性があるが、ローカルアプリケーション内での表示のため、外部への漏洩リスクは低い。

## 備考

この通知が表示された後、最近使用したプロジェクトメニューとテンプレートメニューが非同期で更新される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロジェクトファイル（.srip）の構造とSettingsクラスのRecentProjectsを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | プロジェクトの基本構造を理解 |

**読解のコツ**: SafeSerializationによるバイナリシリアライズ形式で保存される。

#### Step 2: エントリーポイントを理解する

LoadProject関数が通知のトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | LoadProject関数（行1631-1644）を確認 |

**主要処理フロー**:
1. **行1632**: SetLastModifiedTemplate呼び出し
2. **行1633**: Refresh呼び出し
3. **行1635-1636**: File.Exists確認とMsgWarn呼び出し
4. **行1637-1639**: RecentProjectsとメニューの更新

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255）を確認 |

**主要処理フロー**:
- **行1245-1250**: MsgWarnがMsg関数を呼び出し、TaskIcon.WarningとTaskButton.OKを設定

#### Step 4: TaskDialogの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | タスクダイアログの表示ロジック |

### プログラム呼び出し階層図

```
MainForm.LoadProject (行1631)
    │
    ├─ SetLastModifiedTemplate (行1632)
    │
    ├─ Refresh (行1633)
    │
    ├─ File.Exists (行1635)
    │      └─ 【False時】MsgWarn (行1636)
    │              └─ General.Msg (行1250)
    │                      └─ TaskDialog.Show
    │
    ├─ s.UpdateRecentProjects (行1637)
    │
    ├─ UpdateRecentProjectsMenu (行1638)
    │
    └─ UpdateTemplatesMenuAsync (行1639)
```

### データフロー図

```
[入力]               [処理]                    [出力]

プロジェクトパス ───▶ LoadProject関数 ───▶ 警告ダイアログ表示
                         │
                         ▼
                    File.Exists確認
                         │
                         ▼
                    MsgWarn呼び出し
                         │
                         ▼
                    TaskDialog表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | LoadProject関数の定義、通知トリガー |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
| Project.vb | `Source/General/Project.vb` | ソース | プロジェクトクラスの定義 |
