# 通知設計書 52-プレイリスト未検出警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「プレイリスト未検出警告」通知の設計仕様を定義する。

### 本通知の処理概要

プレイリスト未検出警告は、Blu-rayフォルダまたはBlu-rayイメージ（ISO）を開く際に、PLAYLISTディレクトリが見つからない場合に警告ダイアログを表示する機能である。

**業務上の目的・背景**：StaxRipはBlu-rayディスクからの動画変換をサポートしており、eac3toツールを使用してBlu-rayのプレイリストを読み取る。Blu-rayの構造では、動画コンテンツは通常BDMV/PLAYLISTディレクトリに格納されている。このディレクトリが存在しない場合、正しいBlu-rayソースではないか、構造が不正である可能性があるため、ユーザーに警告する必要がある。

**通知の送信タイミング**：OpenBlurayFolder関数またはOpenBlurayImage関数が呼び出された際に、PLAYLISTディレクトリの存在確認で失敗した場合にトリガーされる。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。

**通知内容の概要**：「No playlist directory found.」というメッセージが警告ダイアログとして表示される。

**期待されるアクション**：ユーザーは正しいBlu-rayフォルダを再選択するか、Blu-rayディスク/イメージの構造を確認する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | No playlist directory found. |
| ボタン | OK |

### 本文テンプレート

```
No playlist directory found.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | OpenBlurayFolder関数の呼び出し | PLAYLISTディレクトリが存在しない | Blu-rayフォルダを開く際 |
| 画面操作 | OpenBlurayImage関数の呼び出し | PLAYLISTディレクトリが存在しない | Blu-rayイメージ（ISO）を開く際 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| PLAYLISTディレクトリが存在する場合 | 正常なBlu-ray構造の場合は通知を表示しない |
| srcPathが空または存在しない場合 | 事前チェックで処理が終了するため通知に到達しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OpenBlurayFolder/OpenBlurayImage呼び出し] --> B{srcPathの検証}
    B -->|空/不存在| C[Falseを返却]
    B -->|有効| D[BDMVディレクトリ確認]
    D --> E[PLAYLISTディレクトリ確認]
    E --> F{PLAYLIST存在確認}
    F -->|不存在| G[MsgWarn呼び出し]
    G --> H[Falseを返却]
    F -->|存在| I[eac3toでプレイリスト処理]
    I --> J[プレイリスト選択ダイアログ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイルシステムの確認のみ）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| PLAYLISTディレクトリ不存在 | Blu-ray構造が不正 | 警告表示後、Falseを返却して処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。ローカルファイルシステムの構造確認のみ。

## 備考

この通知は2つの異なる関数（OpenBlurayFolder、OpenBlurayImage）から呼び出される可能性がある。OpenBlurayImageの場合は、ISOファイルをマウントしてからPLAYLISTディレクトリを確認する。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Blu-rayディスクのディレクトリ構造（BDMV/PLAYLIST）を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainForm.vb | `Source/Forms/MainForm.vb` | OpenBlurayFolder関数での構造チェックロジック（行2313-2322） |

**読解のコツ**: Blu-rayの標準構造はルート/BDMV/PLAYLISTである。

#### Step 2: エントリーポイントを理解する

OpenBlurayFolderとOpenBlurayImage関数が通知のトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | OpenBlurayFolder関数（行2309-2357） |
| 2-2 | MainForm.vb | `Source/Forms/MainForm.vb` | OpenBlurayImage関数（行2359-2418） |

**主要処理フロー**:
1. **行2310-2311**: srcPathの検証
2. **行2313-2318**: BDMV/PLAYLISTディレクトリの探索
3. **行2319-2322**: PLAYLISTディレクトリ存在確認とMsgWarn呼び出し
4. **行2373-2376**: OpenBlurayImageでの同様の確認

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

### プログラム呼び出し階層図

```
MainForm.OpenBlurayFolder (行2309)
    │
    ├─ Directory.Exists (BDMV確認)
    │
    ├─ Directory.Exists (PLAYLIST確認)
    │
    ├─ DirectoryInfo.Name確認 (行2319)
    │      └─ 【不一致時】MsgWarn (行2320)
    │              └─ General.Msg
    │                      └─ TaskDialog.Show
    │
    └─ eac3toによるプレイリスト処理

MainForm.OpenBlurayImage (行2359)
    │
    ├─ IsoHelp.Mount (ISOマウント)
    │
    ├─ Directory.Exists (BDMV確認)
    │
    ├─ Directory.Exists (PLAYLIST確認)
    │
    ├─ DirectoryInfo.Name確認 (行2373)
    │      └─ 【不一致時】MsgWarn (行2374)
    │              └─ General.Msg
    │                      └─ TaskDialog.Show
    │
    └─ IsoHelp.Dismount (Finally)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Blu-rayフォルダ ───▶ OpenBlurayFolder ───▶ 警告ダイアログ表示
    または                  │                     または
ISOファイル ───────▶ OpenBlurayImage ───▶ プレイリスト選択画面
                           │
                           ▼
                    PLAYLIST確認
                           │
                    ┌──────┴──────┐
                    ▼             ▼
               存在しない      存在する
                    │             │
                    ▼             ▼
               MsgWarn        eac3to処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | OpenBlurayFolder/OpenBlurayImage関数の定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
| IsoHelp.vb | `Source/General/IsoHelp.vb` | ソース | ISOファイルのマウント/アンマウント |
