# 通知設計書 53-リカバリ保存失敗警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「リカバリ保存失敗警告」通知の設計仕様を定義する。

### 本通知の処理概要

リカバリ保存失敗警告は、ソースファイルを開く際にリカバリ用プロジェクトの保存が失敗した場合に、警告ダイアログを表示する機能である。

**業務上の目的・背景**：StaxRipでは、ユーザーがソースファイルを開いて作業を開始する前に、現在のプロジェクト状態をリカバリ用として一時保存する。これにより、予期せぬエラーや操作ミスが発生した場合に、以前の状態に復帰できるようにしている。この保存処理が失敗した場合、ユーザーにその事実を通知し、作業を続行するかどうかの判断材料を提供する必要がある。

**通知の送信タイミング**：OpenVideoSourceFiles関数内でSafeSerialization.Serialize処理が例外をスローした場合にトリガーされる。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。

**通知内容の概要**：タイトルとして「Recovery not saved!」、詳細内容としてリカバリプロジェクトの保存先パスと保存できなかった旨のメッセージが表示される。

**期待されるアクション**：ユーザーはダイアログを確認し、リカバリ機能が利用できない状態であることを認識した上で作業を続行するか、一時ディレクトリの空き容量や権限を確認する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | Recovery not saved! |
| ボタン | OK |

### 本文テンプレート

```
The recovery project could not be saved at:
{リカバリプロジェクトパス}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| recoverProjectPath | リカバリプロジェクトの保存先パス | Folder.Temp + GUID + ".bin" | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | OpenVideoSourceFiles関数の呼び出し | SafeSerialization.Serializeが例外をスロー | リカバリプロジェクトの保存処理が失敗した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| シリアライズが成功した場合 | 例外が発生しない場合は通知を表示しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OpenVideoSourceFiles呼び出し] --> B[recoverProjectPath生成]
    B --> C[SafeSerialization.Serialize実行]
    C --> D{例外発生?}
    D -->|Yes| E[MsgWarn呼び出し]
    E --> F[処理続行]
    D -->|No| G[Disposeハンドラ登録]
    G --> F
    F --> H[ソースファイル処理継続]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 一時ファイル | INSERT（試行） | リカバリ用プロジェクトファイルの保存を試行 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| シリアライズ失敗 | ディスク容量不足、権限不足など | 警告表示後、処理は続行される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

リカバリプロジェクトパスにはシステムの一時ディレクトリ（Folder.Temp）が含まれる。このパスはユーザーのローカル環境に依存するため、外部に漏洩するリスクは低い。

## 備考

この警告が表示されても、ソースファイルを開く処理自体は続行される。ただし、リカバリ機能が利用できないため、予期せぬエラーが発生した場合に以前の状態に戻せないリスクがある。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リカバリプロジェクトのシリアライズ形式を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | プロジェクトクラスの構造 |
| 1-2 | SafeSerialization.vb | `Source/General/SafeSerialization.vb` | シリアライズ処理の実装 |

**読解のコツ**: SafeSerializationはバイナリ形式でオブジェクトを保存する。

#### Step 2: エントリーポイントを理解する

OpenVideoSourceFiles関数がリカバリ保存のトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | OpenVideoSourceFiles関数（行2428-2499） |

**主要処理フロー**:
1. **行2432**: recoverProjectPathの生成（GUID使用）
2. **行2442-2447**: Try-Catchブロックでシリアライズ実行
3. **行2446**: 例外発生時のMsgWarn呼び出し
4. **行2444**: 成功時のDisposedハンドラ登録

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

### プログラム呼び出し階層図

```
MainForm.OpenVideoSourceFiles (行2428)
    │
    ├─ recoverProjectPath生成 (行2432)
    │      └─ Folder.Temp + Guid.NewGuid + ".bin"
    │
    ├─ Try
    │      ├─ SafeSerialization.Serialize (行2443)
    │      └─ AddHandler Disposed (行2444)
    │
    └─ Catch ex As Exception
           └─ MsgWarn (行2446)
                   └─ General.Msg
                           └─ TaskDialog.Show
```

### データフロー図

```
[入力]               [処理]                    [出力]

ソースファイル群 ───▶ OpenVideoSourceFiles ───▶ 警告ダイアログ（失敗時）
                           │                        または
                           ▼                   正常処理継続（成功時）
                    recoverProjectPath生成
                           │
                           ▼
                    SafeSerialization.Serialize
                           │
                    ┌──────┴──────┐
                    ▼             ▼
                  例外発生      正常完了
                    │             │
                    ▼             ▼
                 MsgWarn     Disposeハンドラ登録
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | OpenVideoSourceFiles関数の定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の定義 |
| SafeSerialization.vb | `Source/General/SafeSerialization.vb` | ソース | シリアライズ処理 |
| Project.vb | `Source/General/Project.vb` | ソース | プロジェクトクラスの定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
