# 通知設計書 54-VOBファイル警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「VOBファイル警告」通知の設計仕様を定義する。

### 本通知の処理概要

VOBファイル警告は、ユーザーがVIDEO_TS.VOBファイルを開こうとした際に、このファイルが開けないことを警告するダイアログを表示する機能である。

**業務上の目的・背景**：DVDのVOB（Video Object）ファイル形式において、VIDEO_TS.VOBは通常、ディスクのメニューやナビゲーション情報を含む特殊なファイルである。このファイルには動画コンテンツが含まれていないか、または正常に処理できない形式であることが多い。StaxRipは動画変換を目的としているため、このような非動画ファイルを開こうとした場合にユーザーに警告を発し、誤操作を防止する必要がある。

**通知の送信タイミング**：OpenVideoSourceFiles関数内で、ソースファイルのファイル名がVIDEO_TS.VOBである場合にトリガーされる。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。

**通知内容の概要**：「The file VIDEO_TS.VOB can't be opened.」というメッセージが警告ダイアログとして表示される。

**期待されるアクション**：ユーザーは正しいVOBファイル（VTS_01_1.VOBなど、実際の動画コンテンツを含むファイル）を選択し直す。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | The file VIDEO_TS.VOB can't be opened. |
| ボタン | OK |

### 本文テンプレート

```
The file VIDEO_TS.VOB can't be opened.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | OpenVideoSourceFiles関数の呼び出し | ファイル名がVIDEO_TS.VOB（大文字小文字無視） | VIDEO_TS.VOBファイルを開こうとした場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ファイル名がVIDEO_TS.VOB以外の場合 | 通常のVOBファイルは警告なしで処理される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OpenVideoSourceFiles呼び出し] --> B[ファイルリストのループ]
    B --> C{ファイル名確認}
    C -->|VIDEO_TS.VOB| D[MsgWarn呼び出し]
    D --> E[AbortException発生]
    E --> F[処理中断]
    C -->|その他のVOB| G[処理続行]
    C -->|VTS_0X_0.VOB| H[MsgQuestion確認]
    H -->|キャンセル| E
    H -->|OK| G
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| VIDEO_TS.VOBの選択 | ファイル名がVIDEO_TS.VOB | 警告表示後、AbortExceptionで処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。

## 備考

DVDのVOBファイル構造において、VIDEO_TS.VOBはメニュー情報を含むことが多い。実際の動画コンテンツはVTS_01_1.VOB、VTS_01_2.VOBなどのファイルに格納されている。また、VTS_0X_0.VOB（Xは数字）形式のファイルも通常メニューを含むため、別途確認ダイアログ（MsgQuestion）が表示される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DVDのVOBファイル構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ファイル名パターンの確認ロジック（行2458-2471） |

**読解のコツ**: VOBファイル名のパターンマッチングにはVB.NETのLike演算子が使用されている。

#### Step 2: エントリーポイントを理解する

OpenVideoSourceFiles関数がトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | OpenVideoSourceFiles関数（行2428-2499） |

**主要処理フロー**:
1. **行2458-2471**: ファイルリストのループ処理
2. **行2459**: ファイル名の取得
3. **行2461-2465**: VTS_0X_0.VOBパターンの確認とMsgQuestion
4. **行2467-2470**: VIDEO_TS.VOBの確認とMsgWarn、AbortException

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

### プログラム呼び出し階層図

```
MainForm.OpenVideoSourceFiles (行2428)
    │
    ├─ For Eachループ (行2458)
    │      │
    │      ├─ i.FileName取得 (行2459)
    │      │
    │      ├─ 【VTS_0X_0.VOBの場合】
    │      │      └─ MsgQuestion (行2462)
    │      │              └─ 【Cancel時】AbortException
    │      │
    │      └─ 【VIDEO_TS.VOBの場合】
    │             ├─ MsgWarn (行2468)
    │             │      └─ General.Msg
    │             │              └─ TaskDialog.Show
    │             └─ AbortException (行2469)
    │
    └─ 続行処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

VOBファイル群 ───▶ OpenVideoSourceFiles ───▶ 警告ダイアログ表示
                         │                        + 処理中断
                         ▼
                  ファイル名チェック
                         │
              ┌──────────┼──────────┐
              ▼          ▼          ▼
         VIDEO_TS.VOB  VTS_0X_0  その他のVOB
              │          │          │
              ▼          ▼          ▼
          MsgWarn   MsgQuestion   処理続行
              │          │
              ▼          ▼
        AbortException キャンセル時Abort
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | OpenVideoSourceFiles関数の定義、ファイル名チェック |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
