# 通知設計書 55-光学ドライブ設定警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「光学ドライブ設定警告」通知の設計仕様を定義する。

### 本通知の処理概要

光学ドライブ設定警告は、ユーザーが光学ドライブ（CD/DVD/Blu-ray）からファイルを開こうとした際に、一時ファイルフォルダの設定が必要であることを警告するダイアログを表示する機能である。

**業務上の目的・背景**：StaxRipは動画変換処理において、多数の一時ファイルを生成する。光学ドライブは読み取り専用であり、一時ファイルを書き込むことができない。そのため、一時フォルダとして光学ドライブを使用しようとした場合、処理が正常に完了できない。この警告は、ユーザーに一時フォルダをローカルの固定ドライブに設定するよう促すために必要である。

**通知の送信タイミング**：OpenVideoSourceFiles関数内で、現在の一時ディレクトリ（p.TempDir）がCD-ROMドライブのルートから始まっている場合にトリガーされる。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。

**通知内容の概要**：「Opening files from an optical drive requires to set a temp files folder in the options.」というメッセージが警告ダイアログとして表示される。

**期待されるアクション**：ユーザーはオプション設定画面で一時フォルダを固定ドライブ上の適切な場所に設定し直す。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | Opening files from an optical drive requires to set a temp files folder in the options. |
| ボタン | OK |

### 本文テンプレート

```
Opening files from an optical drive requires to set a temp files folder in the options.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | OpenVideoSourceFiles関数の呼び出し | p.TempDirがCD-ROMドライブのルートから始まる | 一時フォルダが光学ドライブに設定されている場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 一時フォルダが固定ドライブの場合 | DriveType.CDRom以外の場合は通知を表示しない |
| 一時フォルダがドライブルートと一致しない場合 | StartsWith比較で一致しない場合は通知を表示しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OpenVideoSourceFiles呼び出し] --> B[ログ出力処理]
    B --> C[DriveInfo.GetDrives取得]
    C --> D[ドライブループ]
    D --> E{DriveType = CDRom?}
    E -->|No| D
    E -->|Yes| F{TempDirがドライブルートで開始?}
    F -->|No| D
    F -->|Yes| G[MsgWarn呼び出し]
    G --> H[AbortException発生]
    H --> I[処理中断]
    D -->|ループ終了| J[処理続行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 設定参照

| 設定項目 | 用途 |
|---------|------|
| p.TempDir | 現在の一時フォルダパスの確認 |

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 光学ドライブに一時フォルダ設定 | p.TempDirがCDRomドライブ上 | 警告表示後、AbortExceptionで処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。

## 備考

DriveInfo.GetDrives()を使用して全ドライブを列挙し、DriveType.CDRomタイプのドライブのみを検査する。p.TempDirが光学ドライブのルートディレクトリから始まっている場合に警告が表示される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DriveInfoクラスとDriveTypeの使用方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ドライブチェックロジック（行2665-2672） |

**読解のコツ**: .NETのDriveInfo.GetDrives()は全ドライブ情報を取得し、DriveType列挙型でドライブの種類を判定できる。

#### Step 2: エントリーポイントを理解する

OpenVideoSourceFiles関数がトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | OpenVideoSourceFiles関数内のドライブチェック部分 |

**主要処理フロー**:
1. **行2665**: DriveInfo.GetDrives()でドライブ列挙
2. **行2666**: DriveType.CDRomのチェック
3. **行2667**: p.TempDirがドライブルートで開始するかチェック
4. **行2669**: MsgWarn呼び出し
5. **行2670**: AbortException発生

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

### プログラム呼び出し階層図

```
MainForm.OpenVideoSourceFiles (行2428)
    │
    ├─ Log.WriteEnvironment (行2656)
    │
    ├─ Log.WriteHeader (行2657)
    │
    ├─ MediaInfo.GetSummary (行2663)
    │
    └─ For Eachループ - DriveInfo.GetDrives (行2665)
           │
           ├─ DriveType確認 (行2666)
           │
           ├─ TempDir比較 (行2667)
           │
           └─ 【条件一致時】
                  ├─ MsgWarn (行2669)
                  │      └─ General.Msg
                  │              └─ TaskDialog.Show
                  └─ AbortException (行2670)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ソースファイル ───▶ OpenVideoSourceFiles ───▶ 警告ダイアログ表示
                         │                        + 処理中断
                         ▼
                  DriveInfo.GetDrives()
                         │
                         ▼
                  各ドライブチェック
                         │
              ┌──────────┴──────────┐
              ▼                    ▼
         CDRomドライブ       その他のドライブ
              │                    │
              ▼                    ▼
        TempDir比較           次のドライブへ
              │
       ┌──────┴──────┐
       ▼             ▼
    一致する      一致しない
       │             │
       ▼             ▼
    MsgWarn     次のドライブへ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | OpenVideoSourceFiles関数の定義、ドライブチェック |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
| Project.vb | `Source/General/Project.vb` | ソース | p.TempDirプロパティの定義 |
