# 通知設計書 56-テンプレート作成不可警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「テンプレート作成不可警告」通知の設計仕様を定義する。

### 本通知の処理概要

テンプレート作成不可警告は、ソースファイルを開いた後にテンプレートを作成しようとした場合に、テンプレート作成ができないことを警告するダイアログを表示する機能である。

**業務上の目的・背景**：StaxRipのテンプレート機能は、プロジェクトの初期設定を保存して再利用するためのものである。テンプレートは「白紙の状態」から設定を保存することが想定されており、すでにソースファイルが読み込まれた状態でテンプレートを保存すると、そのソースファイル固有の設定が含まれてしまい、汎用性のあるテンプレートとして機能しなくなる。この警告は、ユーザーの誤操作を防ぎ、正しいテンプレート作成フローを促すために必要である。

**通知の送信タイミング**：SaveProjectPath関数またはSaveProjectAsTemplate関数が呼び出された際に、p.SourceFileが空でない場合にトリガーされる。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。

**通知内容の概要**：「A template cannot be created after a source file was opened.」というメッセージが警告ダイアログとして表示される。

**期待されるアクション**：ユーザーは現在のプロジェクトを閉じて新規プロジェクトを開始するか、テンプレート保存を断念する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | A template cannot be created after a source file was opened. |
| ボタン | OK |

### 本文テンプレート

```
A template cannot be created after a source file was opened.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | SaveProjectPath関数の呼び出し | path.StartsWith(Folder.Template) かつ p.SourceFile <> "" | テンプレートフォルダへの保存でソースファイルが設定済みの場合 |
| 画面操作 | SaveProjectAsTemplate関数の呼び出し | p.SourceFile <> "" | テンプレート保存操作でソースファイルが設定済みの場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| p.SourceFileが空の場合 | ソースファイルが読み込まれていない場合は通知を表示しない |
| テンプレートフォルダ以外への保存の場合 | SaveProjectPathの場合、通常のプロジェクト保存は警告なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SaveProjectPath/SaveProjectAsTemplate呼び出し] --> B{保存先確認}
    B -->|SaveProjectPath + Templateフォルダ| C{SourceFile確認}
    B -->|SaveProjectAsTemplate| C
    B -->|その他| D[通常保存処理]
    C -->|空でない| E[MsgWarn呼び出し]
    E --> F[処理中断]
    C -->|空| G[テンプレート保存処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 設定参照

| 設定項目 | 用途 |
|---------|------|
| p.SourceFile | ソースファイルが読み込まれているか確認 |
| Folder.Template | テンプレート保存先フォルダのパス |

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ソースファイル読込後のテンプレート作成試行 | p.SourceFile <> "" | 警告表示後、Exit Subで処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。

## 備考

この警告は2つの異なる関数から呼び出される可能性がある。SaveProjectPathは汎用的なプロジェクト保存関数で、保存先がテンプレートフォルダの場合に警告を表示する。SaveProjectAsTemplateは明示的にテンプレートとして保存する関数で、常にソースファイルの有無をチェックする。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テンプレートフォルダのパスとプロジェクトのSourceFileプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | SourceFileプロパティの定義 |
| 1-2 | Folder.vb | `Source/General/Folder.vb` | Folder.Templateの定義 |

**読解のコツ**: Folder.TemplateはStaxRipのテンプレート保存用ディレクトリを指す。

#### Step 2: エントリーポイントを理解する

SaveProjectPathとSaveProjectAsTemplateが通知のトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | SaveProjectPath関数（行3783-3808） |
| 2-2 | MainForm.vb | `Source/Forms/MainForm.vb` | SaveProjectAsTemplate関数（行3815-3839） |

**主要処理フロー**:

SaveProjectPath:
1. **行3787**: パスのマクロ展開
2. **行3789-3793**: テンプレートフォルダへの保存時、SourceFileチェックとMsgWarn

SaveProjectAsTemplate:
1. **行3817-3835**: SourceFileが空の場合の正常処理
2. **行3837**: SourceFileが空でない場合のMsgWarn

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

### プログラム呼び出し階層図

```
MainForm.SaveProjectPath (行3783)
    │
    ├─ Macro.Expand (行3787)
    │
    ├─ path.StartsWith(Folder.Template)確認 (行3789)
    │      │
    │      └─ 【true時】p.SourceFile確認 (行3790)
    │              └─ 【空でない時】MsgWarn (行3791)
    │                      └─ Exit Sub (行3792)
    │
    └─ SafeSerialization.Serialize (行3800)

MainForm.SaveProjectAsTemplate (行3815)
    │
    ├─ p.SourceFile確認 (行3817)
    │      │
    │      ├─ 【空の場合】InputBox表示とテンプレート保存
    │      │
    │      └─ 【空でない場合】MsgWarn (行3837)
    │              └─ General.Msg
    │                      └─ TaskDialog.Show
```

### データフロー図

```
[入力]               [処理]                    [出力]

保存操作 ───▶ SaveProjectPath/AsTemplate ───▶ 警告ダイアログ表示
                         │                        + 処理中断
                         ▼                         または
                  保存先/SourceFile確認         テンプレート保存
                         │
              ┌──────────┴──────────┐
              ▼                    ▼
      SourceFile設定済み    SourceFile未設定
              │                    │
              ▼                    ▼
          MsgWarn              正常保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | SaveProjectPath/SaveProjectAsTemplate関数の定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
| Project.vb | `Source/General/Project.vb` | ソース | SourceFileプロパティの定義 |
| Folder.vb | `Source/General/Folder.vb` | ソース | Folder.Templateの定義 |
