# 通知設計書 57-アシスタント従属警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「アシスタント従属警告」通知の設計仕様を定義する。

### 本通知の処理概要

アシスタント従属警告は、アシスタント機能が完了していない状態でジョブを追加しようとした場合に、アシスタントの指示に従うよう促す警告ダイアログを表示する機能である。

**業務上の目的・背景**：StaxRipにはウィザード形式のアシスタント機能があり、ユーザーが正しい設定を行えるよう段階的に案内する。このアシスタントの指示を無視してジョブを追加しようとすると、必要な設定が不完全なまま処理が開始されてしまう可能性がある。この警告は、ユーザーにアシスタントの指示に従って正しい設定を完了するよう促すために必要である。

**通知の送信タイミング**：AddJob関数が呼び出された際に、showAssistantがTrueかつIsLoadingがFalseかつAssistantPassedがFalseの場合にトリガーされる。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。

**通知内容の概要**：「Please follow the assistant.」というメッセージが警告ダイアログとして表示される。

**期待されるアクション**：ユーザーはアシスタントの指示に従い、必要な設定を完了してからジョブを追加する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | Please follow the assistant. |
| ボタン | OK |

### 本文テンプレート

```
Please follow the assistant.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | AddJob関数の呼び出し | showAssistant = True かつ IsLoading = False かつ AssistantPassed = False | アシスタントが未完了の状態でジョブ追加を試みた場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| AssistantPassedがTrueの場合 | アシスタントが完了している場合は通知を表示しない |
| showAssistantがFalseの場合 | アシスタントチェックが無効化されている場合は通知を表示しない |
| IsLoadingがTrueの場合 | 読み込み中の場合は通知を表示しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AddJob呼び出し] --> B{showAssistant?}
    B -->|False| C[ジョブ追加処理]
    B -->|True| D{IsLoading?}
    D -->|True| C
    D -->|False| E{AssistantPassed?}
    E -->|True| C
    E -->|False| F[MsgWarn呼び出し]
    F --> G[処理中断]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 状態参照

| 状態項目 | 用途 |
|---------|------|
| AssistantPassed | アシスタントが完了したかどうかの確認 |
| IsLoading | 読み込み中かどうかの確認 |

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| アシスタント未完了でジョブ追加試行 | AssistantPassed = False | 警告表示後、Exit Subで処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。

## 備考

アシスタント機能は、ユーザーがソースファイルを開いた後に、必要な設定項目を順番にチェックし、問題がある場合はメインダイアログに案内を表示する。全ての設定が正しく完了するとAssistantPassedがTrueになり、ジョブを追加できるようになる。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アシスタントの状態管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainForm.vb | `Source/Forms/MainForm.vb` | AssistantPassedプロパティの定義 |

**読解のコツ**: AssistantPassedはMainFormのプロパティで、アシスタントの全チェックが完了したかを示すブール値。

#### Step 2: エントリーポイントを理解する

AddJob関数が通知のトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | AddJob関数（行4197-4223） |

**主要処理フロー**:
1. **行4203-4205**: g.VerifyRequirements()で要件確認
2. **行4207-4210**: showAssistant、IsLoading、AssistantPassedの確認とMsgWarn
3. **行4212-4218**: ジョブ追加処理

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

### プログラム呼び出し階層図

```
MainForm.AddJob (行4197)
    │
    ├─ g.VerifyRequirements (行4203)
    │
    ├─ showAssistant確認 (行4207)
    │      │
    │      ├─ IsLoading確認
    │      │
    │      └─ AssistantPassed確認
    │              │
    │              └─ 【False時】MsgWarn (行4208)
    │                      └─ General.Msg
    │                              └─ TaskDialog.Show
    │
    └─ 【条件クリア時】
           ├─ JobManager.JobPath取得 (行4212)
           ├─ SaveProjectPath (行4213)
           ├─ JobManager.AddJob (行4214)
           └─ MsgInfo (行4217) ※showConfirmation時
```

### データフロー図

```
[入力]               [処理]                    [出力]

ジョブ追加操作 ───▶ AddJob関数 ───▶ 警告ダイアログ表示
                         │                 + 処理中断
                         ▼                    または
                  条件チェック             ジョブ追加成功
                         │
         ┌───────────────┼───────────────┐
         ▼               ▼               ▼
    showAssistant   IsLoading    AssistantPassed
         │               │               │
         ▼               ▼               ▼
      True/False     True/False     True/False
         │               │               │
         └───────────────┴───────┬───────┘
                                 │
                          ┌──────┴──────┐
                          ▼             ▼
                    条件不成立       条件成立
                          │             │
                          ▼             ▼
                       MsgWarn     ジョブ追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | AddJob関数の定義、AssistantPassedプロパティ |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | g.VerifyRequirements関数の定義 |
