# 通知設計書 58-アシスタントスキップ不可警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「アシスタントスキップ不可警告」通知の設計仕様を定義する。

### 本通知の処理概要

アシスタントスキップ不可警告は、アシスタントの警告をスキップできない状況でジョブを追加しようとした場合に、警告ダイアログを表示する機能である。

**業務上の目的・背景**：StaxRipのアシスタント機能には、ユーザーが無視しても良いヒント（Tip）と、必ず対処が必要な警告がある。一部の警告は安全上または処理上の理由でスキップすることができない。この通知は、ユーザーがスキップ不可能な警告を無視してジョブを追加しようとした場合に、適切な設定変更を促すために必要である。

**通知の送信タイミング**：AddJob関数が呼び出された際に、CanIgnoreTipがFalseの場合にトリガーされる。これは、現在のアシスタントの警告/ヒントがスキップ可能かどうかを判定するプロパティである。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。

**通知内容の概要**：「Assistant warning cannot be skipped.」というメッセージが警告ダイアログとして表示される。

**期待されるアクション**：ユーザーはアシスタントが指摘している問題を解決してから、改めてジョブを追加する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | Assistant warning cannot be skipped. |
| ボタン | OK |

### 本文テンプレート

```
Assistant warning cannot be skipped.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | AddJob関数（ダイアログ表示版）の呼び出し | CanIgnoreTip = False | スキップ不可能な警告がある状態でジョブ追加を試みた場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| CanIgnoreTipがTrueの場合 | 警告をスキップ可能な場合は通知を表示しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AddJob showJobsDialog=True 呼び出し] --> B{CanIgnoreTip?}
    B -->|False| C[MsgWarn呼び出し]
    C --> D[処理中断]
    B -->|True| E[SkippedAssistantTipsに追加]
    E --> F{g.VerifyRequirements?}
    F -->|False| D
    F -->|True| G[PreviewForm閉じる]
    G --> H{AssistantPassed?}
    H -->|True| I[ジョブ追加処理]
    H -->|False| J[Assistant呼び出し]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 状態参照

| 状態項目 | 用途 |
|---------|------|
| CanIgnoreTip | 現在の警告/ヒントがスキップ可能かどうかの確認 |
| CurrentAssistantTipKey | 現在のアシスタントヒントのキー |
| p.SkippedAssistantTips | スキップ済みのヒントリスト |

### 更新データ

| 対象 | 操作 | 概要 |
|-----|------|------|
| p.SkippedAssistantTips | ADD | スキップしたヒントのキーを追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| スキップ不可警告のスキップ試行 | CanIgnoreTip = False | 警告表示後、Exit Subで処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。

## 備考

この通知は、AddJob関数のshowJobsDialog=Trueバージョン（行4084）で発生する。CanIgnoreTipはMainFormのプロパティで、現在表示中のアシスタントの警告/ヒントがスキップ可能かどうかを返す。スキップ可能な場合は、そのヒントのキーがp.SkippedAssistantTipsに追加される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アシスタントのスキップ機能を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainForm.vb | `Source/Forms/MainForm.vb` | CanIgnoreTipプロパティの定義 |
| 1-2 | Project.vb | `Source/General/Project.vb` | SkippedAssistantTipsプロパティの定義 |

**読解のコツ**: CanIgnoreTipは、現在のアシスタントヒントがユーザーによってスキップ可能かを示す。

#### Step 2: エントリーポイントを理解する

AddJob関数（showJobsDialog版）が通知のトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | AddJob関数（行4084-4182） |

**主要処理フロー**:
1. **行4085-4088**: CanIgnoreTipの確認とMsgWarn
2. **行4090-4092**: SkippedAssistantTipsへの追加
3. **行4094-4096**: g.VerifyRequirements()の確認
4. **行4102-4181**: ジョブ追加処理の継続

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

### プログラム呼び出し階層図

```
MainForm.AddJob (showJobsDialog=True) (行4084)
    │
    ├─ CanIgnoreTip確認 (行4085)
    │      │
    │      └─ 【False時】MsgWarn (行4086)
    │              └─ General.Msg
    │                      └─ TaskDialog.Show
    │
    ├─ p.SkippedAssistantTips.Add (行4091)
    │
    ├─ g.VerifyRequirements (行4094)
    │
    ├─ PreviewForm.Instances閉じる (行4098-4100)
    │
    └─ AssistantPassed確認 (行4102)
           │
           ├─ 【True時】ジョブ追加処理
           │
           └─ 【False時】Assistant()呼び出し
```

### データフロー図

```
[入力]               [処理]                    [出力]

ジョブ追加操作 ───▶ AddJob関数 ───▶ 警告ダイアログ表示
                         │                 + 処理中断
                         ▼                    または
                  CanIgnoreTip確認        ジョブ追加成功
                         │
              ┌──────────┴──────────┐
              ▼                    ▼
           False                 True
              │                    │
              ▼                    ▼
          MsgWarn         SkippedTipsに追加
                                   │
                                   ▼
                           VerifyRequirements
                                   │
                            ┌──────┴──────┐
                            ▼             ▼
                         False          True
                            │             │
                            ▼             ▼
                        処理中断      AssistantPassed確認
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | AddJob関数の定義、CanIgnoreTipプロパティ |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
| Project.vb | `Source/General/Project.vb` | ソース | SkippedAssistantTipsプロパティの定義 |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | g.VerifyRequirements関数の定義 |
