# 通知設計書 59-ジョブ追加通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「ジョブ追加通知」の設計仕様を定義する。

### 本通知の処理概要

ジョブ追加通知は、ジョブがジョブリストに正常に追加された際に、情報ダイアログを表示してユーザーに追加完了を通知する機能である。

**業務上の目的・背景**：StaxRipでは、動画変換処理をジョブとしてキューイングし、後でまとめて実行することができる。ユーザーがジョブを追加した際に、追加が成功したことを明確にフィードバックすることで、操作の確認と安心感を提供する。特に複数のジョブを連続して追加する場合に、各追加操作が成功したことを確認できることが重要である。

**通知の送信タイミング**：AddJob関数が正常に完了し、showConfirmationパラメータがTrueの場合にトリガーされる。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。

**通知内容の概要**：「Job added」という簡潔な情報メッセージが表示される。

**期待されるアクション**：ユーザーはOKを押してダイアログを閉じ、次の操作（追加のジョブ追加、ジョブの実行、設定の調整など）に進む。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 低 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Info（情報アイコン） |
| タイトル | Job added |
| ボタン | OK |

### 本文テンプレート

```
Job added
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | AddJob関数の完了 | showConfirmation = True | ジョブ追加成功時に確認表示が有効な場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| showConfirmationがFalseの場合 | 確認表示が無効化されている場合は通知を表示しない |
| ジョブ追加が失敗した場合 | 処理が途中で中断された場合は通知に到達しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AddJob呼び出し] --> B{g.VerifyRequirements?}
    B -->|False| C[処理中断]
    B -->|True| D{showAssistant & !IsLoading & !AssistantPassed?}
    D -->|True| E[MsgWarn - アシスタント警告]
    E --> C
    D -->|False| F[JobManager.JobPath取得]
    F --> G[SaveProjectPath]
    G --> H[JobManager.AddJob]
    H --> I{showConfirmation?}
    I -->|True| J[MsgInfo呼び出し]
    J --> K[テンプレート読み込み処理]
    I -->|False| K
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新データ

| 対象 | 操作 | 概要 |
|-----|------|------|
| ジョブリスト | ADD | 新しいジョブをジョブマネージャーに追加 |
| プロジェクトファイル | SAVE | ジョブパスにプロジェクトを保存 |

## エラー処理

### エラーケース一覧

該当なし（成功時のみ通知が表示される）

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。

## 備考

この通知はオプションであり、showConfirmationパラメータで制御される。コマンドライン版のAddJob関数（Command属性付き）では、showConfirmationパラメータがDispNameで「Show Confirmation」として公開されており、ユーザーがスクリプトやショートカットから呼び出す際に確認表示の有無を選択できる。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ジョブマネージャーの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JobManager.vb | `Source/General/JobManager.vb` | ジョブの管理構造 |

**読解のコツ**: JobManagerはジョブのキューイングと実行を管理するクラス。

#### Step 2: エントリーポイントを理解する

AddJob関数が通知のトリガーとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | AddJob関数（行4197-4223） |

**主要処理フロー**:
1. **行4203-4205**: g.VerifyRequirements()の確認
2. **行4207-4210**: アシスタント状態の確認
3. **行4212**: JobManager.JobPathの取得
4. **行4213**: SaveProjectPath呼び出し
5. **行4214**: JobManager.AddJob呼び出し
6. **行4216-4218**: showConfirmation時のMsgInfo呼び出し

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfo関数（行1216-1220） |

### プログラム呼び出し階層図

```
MainForm.AddJob (行4197)
    │
    ├─ g.VerifyRequirements (行4203)
    │
    ├─ アシスタント状態確認 (行4207)
    │
    ├─ JobManager.JobPath取得 (行4212)
    │
    ├─ SaveProjectPath (行4213)
    │
    ├─ JobManager.AddJob (行4214)
    │
    └─ 【showConfirmation時】MsgInfo (行4217)
           └─ General.Msg
                   └─ TaskDialog.Show
```

### データフロー図

```
[入力]               [処理]                    [出力]

ジョブ追加操作 ───▶ AddJob関数 ───▶ 情報ダイアログ表示
                         │                （成功時のみ）
                         ▼
                  条件チェック
                         │
              ┌──────────┴──────────┐
              ▼                    ▼
         条件不成立             条件成立
              │                    │
              ▼                    ▼
          処理中断           JobManager.AddJob
                                   │
                                   ▼
                           showConfirmation確認
                                   │
                            ┌──────┴──────┐
                            ▼             ▼
                          True          False
                            │             │
                            ▼             ▼
                        MsgInfo        無通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | AddJob関数の定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
| JobManager.vb | `Source/General/JobManager.vb` | ソース | ジョブ管理の実装 |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | g.VerifyRequirements関数の定義 |
