# 通知設計書 6-Msg

## 概要

本ドキュメントは、StaxRipアプリケーションにおける汎用メッセージダイアログ通知「Msg」の設計仕様を定義する。Msgは、アイコンとボタンを自由にカスタマイズ可能な最も基本的なタスクダイアログ関数であり、MsgInfo/MsgError/MsgWarn/MsgQuestion/MsgOKの全てがこの関数を内部で使用する。

### 本通知の処理概要

Msg関数は、StaxRipアプリケーションにおける全てのタスクダイアログ表示の基盤となる汎用通知メカニズムである。

**業務上の目的・背景**：様々なメッセージ表示ニーズに対応するため、アイコン種別とボタン構成を完全にカスタマイズ可能な汎用的な通知関数が必要である。この関数を基盤として、MsgInfo/MsgError/MsgWarn等の特化した関数が構築されている。また、アプリケーション独自の複合的なダイアログが必要な場合にも直接使用できる。

**通知の送信タイミング**：呼び出し元から明示的に呼び出された瞬間に同期的に表示される。ユーザーがボタンをクリックして応答するまで、呼び出し元の処理はブロックされる。

**通知の受信者**：現在アプリケーションを操作しているユーザー。タスクダイアログはモーダルダイアログとして表示される。

**通知内容の概要**：タイトルとコンテンツ（詳細メッセージ）、指定されたアイコン、指定されたボタン群で構成される。TaskIcon列挙型とTaskButton列挙型により、表示内容を完全に制御できる。

**期待されるアクション**：ユーザーはメッセージ内容を確認し、提示されたボタンのいずれかをクリックして応答する。選択されたボタンに対応するDialogResultが呼び出し元に返される。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 可変（アイコン種別による） |
| リトライ | 無し |

### 送信先決定ロジック

現在のフォアグラウンドウィンドウのオーナーとして表示される。GetHandle()メソッドで親ウィンドウを自動取得する。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内通知のため）

### 本文テンプレート

```
[タイトル]
{title パラメータの値}

[コンテンツ]（オプション）
{content パラメータの値}

[アイコン]（iconパラメータで指定）
- None: アイコンなし
- Info: 青い情報アイコン
- Warning: 黄色い警告アイコン
- Question: 青い疑問符アイコン
- Error: 赤いエラーアイコン
- Shield: シールドアイコン

[ボタン]（buttonsパラメータで指定）
- OK, Yes, No, Cancel, Retry, Closeの任意の組み合わせ
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | メッセージのタイトルテキスト | 呼び出し元から渡されるString型 | Yes |
| content | メッセージの詳細テキスト | 呼び出し元から渡されるString型 | No |
| icon | 表示するアイコンの種別 | 呼び出し元から渡されるTaskIcon列挙型 | Yes |
| buttons | 表示するボタンの構成 | 呼び出し元から渡されるTaskButton列挙型 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Msg関数の呼び出し | なし（常に表示） | コード内でMsg()が呼び出された時点で表示 |
| 画面操作 | MsgInfo呼び出し | なし | 内部的にMsg(title, content, TaskIcon.Info, TaskButton.OK)を呼び出し |
| 画面操作 | MsgError呼び出し | timeout >= 0 | 内部的にTaskDialog(Of String)を直接使用（Msg関数は使わない） |
| 画面操作 | MsgWarn呼び出し | onlyOnce=Falseまたは初回 | 内部的にMsg(text, content, TaskIcon.Warning, TaskButton.OK)を呼び出し |
| 画面操作 | MsgQuestion呼び出し | なし | 内部的にMsg(title, content, TaskIcon.Question, buttons)を呼び出し |
| 画面操作 | MsgOK呼び出し | なし | 内部的にMsg(title, Nothing, TaskIcon.Question, TaskButton.OkCancel)を呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | Msg関数は呼び出し時に常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Msg呼び出し] --> B[TaskDialog Of DialogResult生成]
    B --> C[Icon設定]
    C --> D[Title設定]
    D --> E[Content設定]
    E --> F[Buttons設定]
    F --> G{HasFlag OK?}
    G -->|Yes| H[AddButton OK]
    G -->|No| I{HasFlag Yes?}
    H --> I
    I -->|Yes| J[AddButton Yes]
    I -->|No| K{HasFlag No?}
    J --> K
    K -->|Yes| L[AddButton No]
    K -->|No| M{HasFlag Cancel?}
    L --> M
    M -->|Yes| N[AddButton Cancel]
    M -->|No| O{HasFlag Retry?}
    N --> O
    O -->|Yes| P[AddButton Retry]
    O -->|No| Q{HasFlag Close?}
    P --> Q
    Q -->|Yes| R[AddButton Close]
    Q -->|No| S[Show呼び出し]
    R --> S
    S --> T[ダイアログ表示]
    T --> U{ユーザー選択}
    U --> V[DialogResult返却]
    V --> W[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（Msgはデータベースを参照しない）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

#### 送信ログテーブル

該当なし（Msgは送信ログを記録しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 表示失敗 | ウィンドウハンドル取得失敗 | スクリーン中央に表示 |
| パラメータエラー | title/contentがnull | 空文字列として扱う |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（アプリケーション動作中は常に表示可能）

## セキュリティ考慮事項

- ダイアログはモーダル表示のため、他の操作を一時的にブロックする
- 表示される情報の内容は呼び出し元の責任で管理される

## 備考

- MsgはMainModuleに定義されたグローバル関数
- TaskDialog(Of DialogResult)をUsingブロックで使用し、リソースを適切に解放
- MsgInfo/MsgWarn/MsgQuestion/MsgOKの基盤となる関数
- MsgErrorのみ、タイムアウト/コピーボタン機能のためTaskDialog(Of String)を直接使用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Msg関数で使用されるTaskIcon列挙型とTaskButton列挙型を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | TaskIcon列挙型（行580-587）、TaskButton列挙型（行589-601）の定義 |

**読解のコツ**: TaskIconは単純な列挙型、TaskButtonはフラグ列挙型として定義されている。フラグ列挙型により、複数のボタンを組み合わせて指定できる。

#### Step 2: エントリーポイントを理解する

Msg関数の定義とTaskDialogの生成・設定を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | General.vb | `Source/General/General.vb` | Msg関数の定義（行1274-1282） |

**主要処理フロー**:
1. **行1274**: Function Msg(title, content, icon, buttons) As DialogResult
2. **行1275**: Using td As New TaskDialog(Of DialogResult) - リソース管理
3. **行1276**: td.Icon = icon - アイコン設定
4. **行1277**: td.Title = title - タイトル設定
5. **行1278**: td.Content = content - コンテンツ設定
6. **行1279**: td.Buttons = buttons - ボタン設定
7. **行1280**: Return td.Show() - ダイアログ表示と結果返却

#### Step 3: TaskDialogのプロパティ設定を理解する

TaskDialogクラスのIcon、Buttonsプロパティの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | Init()メソッドでのIcon処理（行77-97）、Buttons WriteOnlyプロパティ（行313-323） |

**主要処理フロー**:
- **行77-97**: Icon設定によるStockIcon画像の取得
- **行82-91**: TaskIcon値に応じたStockIconIdentifierの選択
- **行313-323**: TaskButtonフラグのループ処理でAddButton()呼び出し

### プログラム呼び出し階層図

```
Msg(title, content, icon, buttons)  [General.vb:1274]
    |
    +-- Using New TaskDialog(Of DialogResult)()  [TaskDialog.vb:8]
           |
           +-- td.Icon = icon  ─────────────────────────────┐
           +-- td.Title = title                              │
           +-- td.Content = content                          │
           +-- td.Buttons = buttons  [TaskDialog.vb:313]     │
           |      |                                          │
           |      +-- For Each TaskButton value              │
           |             |                                   │
           |             +-- HasFlag(OK) ──> AddButton("OK") │
           |             +-- HasFlag(Yes) ─> AddButton("Yes")│
           |             +-- HasFlag(No) ──> AddButton("No") │
           |             +-- HasFlag(Cancel) > AddButton()   │
           |             +-- HasFlag(Retry) > AddButton()    │
           |             +-- HasFlag(Close) > AddButton()    │
           |                                                 │
           +-- td.Show()  [TaskDialog.vb:552]                │
                  |                                          │
                  +-- Init()  [TaskDialog.vb:43] <───────────┘
                  |      |
                  |      +-- Icon処理  [TaskDialog.vb:77]
                  |      |      |
                  |      |      +-- StockIcon.GetImage()
                  |      |
                  |      +-- ボタン処理  [TaskDialog.vb:152]
                  |
                  +-- ShowDialog()  [TaskDialog.vb:557]
                  |
                  +-- Return SelectedValue (DialogResult)
```

### データフロー図

```
[入力]               [処理]                    [出力]

title (String) ────> td.Title設定 ─────────> TaskDialog.Title
                          |
content (String) ───> td.Content設定 ───────> TaskDialog.Content
                          |
icon (TaskIcon) ────> td.Icon設定 ──────────> アイコン画像選択
    |                     |
    +-- None ────────> アイコンなし
    +-- Info ────────> StockIcon.Info
    +-- Warning ─────> StockIcon.Warning
    +-- Question ────> StockIcon.Help
    +-- Error ───────> StockIcon.Error
    +-- Shield ──────> StockIcon.Shield
                          |
buttons (TaskButton) > td.Buttons設定 ──────> ボタン群生成
    |                     |
    +-- OK ──────────> [OK]ボタン
    +-- Yes ─────────> [Yes]ボタン
    +-- No ──────────> [No]ボタン
    +-- Cancel ──────> [Cancel]ボタン
    +-- Retry ───────> [Retry]ボタン
    +-- Close ───────> [Close]ボタン
                          |
                    td.Show() ────────────> [画面表示]
                          |
                    ユーザー選択 ─────────> DialogResult
                          |
                    Return DialogResult ──> [戻り値]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| General.vb | `Source/General/General.vb` | ソース | Msg関数の定義（MainModule内） |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | TaskDialog(Of T)クラス、TaskIcon/TaskButton列挙型 |
| TaskDialogBaseForm.vb | `Source/UI/TaskDialogBaseForm.vb` | ソース | TaskDialogの基底フォームクラス |
| StockIcon.vb | `Source/UI/StockIcon.vb` | ソース | システムアイコン取得ユーティリティ |
