# 通知設計書 60-デフォルト復元通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「デフォルト復元通知」の設計仕様を定義する。

### 本通知の処理概要

デフォルト復元通知は、ユーザーがデフォルト設定を復元した際に、復元が完了したことを情報ダイアログで通知する機能である。

**業務上の目的・背景**：StaxRipでは、フィルタプロファイルやコマンドラインオプションなど、様々な設定をカスタマイズできる。ユーザーが設定を変更しすぎて元に戻したい場合や、問題が発生した際の対処として、デフォルト設定に復元する機能がある。この通知は、復元操作が正常に完了したことをユーザーにフィードバックし、操作の確認を提供するために必要である。

**通知の送信タイミング**：複数の場所でデフォルト復元機能が実装されており、それぞれの復元処理が完了した後にトリガーされる。主な使用箇所はフィルタプロファイルダイアログ、コマンドラインコントロール、メニューカスタマイズなど。

**通知の受信者**：StaxRipアプリケーションを操作しているエンドユーザー本人。

**通知内容の概要**：「Defaults were restored.」という簡潔な情報メッセージが表示される。

**期待されるアクション**：ユーザーはOKを押してダイアログを閉じ、復元されたデフォルト設定を使用して作業を続ける。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（モーダルダイアログ） |
| 優先度 | 低 |
| リトライ | 無 |

### 送信先決定ロジック

アプリケーションを操作中のユーザーに対して直接表示する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Info（情報アイコン） |
| タイトル | Defaults were restored. |
| ボタン | OK |

### 本文テンプレート

```
Defaults were restored.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ShowFilterProfilesDialog内のRestore Defaults | ユーザーが確認ダイアログでOKを押した場合 | フィルタプロファイルのデフォルト復元 |
| 画面操作 | CommandLineControl内のRestore Defaults | ユーザーが確認ダイアログでOKを押した場合 | コマンドラインオプションのデフォルト復元 |
| 画面操作 | Menu.ShowScriptDialog内のRestore Defaults | ユーザーが確認ダイアログでOKを押した場合 | メニュースクリプトのデフォルト復元 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 確認ダイアログでキャンセルを押した場合 | 復元操作がキャンセルされた場合は通知を表示しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Restore Defaultsボタンクリック] --> B[確認ダイアログ表示]
    B --> C{ユーザーの選択}
    C -->|OK| D[デフォルト値を設定]
    D --> E[MsgInfo呼び出し]
    E --> F[ダイアログに反映]
    C -->|Cancel| G[キャンセル処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新データ

| 対象 | 操作 | 概要 |
|-----|------|------|
| ダイアログ内のテキスト値 | UPDATE | デフォルト値でテキストを置換 |

## エラー処理

### エラーケース一覧

該当なし（成功時のみ通知が表示される）

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。

## 備考

この通知は複数の異なるダイアログで使用されている。主な使用箇所：
- MainForm.ShowFilterProfilesDialog（行4297）：フィルタプロファイル設定
- CommandLineControl.ShowDialogEx（行131）：コマンドラインオプション設定
- Menu.ShowScriptDialog（行686）：メニュースクリプト設定

各箇所で同じメッセージ「Defaults were restored.」が表示される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

復元されるデフォルト設定の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FilterCategory.vb | `Source/General/FilterCategory.vb` | フィルタプロファイルのデフォルト定義 |

**読解のコツ**: GetAviSynthDefaults()やGetVapourSynthDefaults()がデフォルト値を返す。

#### Step 2: エントリーポイントを理解する

複数の箇所でデフォルト復元が実装されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ShowFilterProfilesDialog関数（行4280-4329） |
| 2-2 | CommandLineControl.vb | `Source/Controls/CommandLineControl.vb` | ShowDialogEx関数（行126-136） |
| 2-3 | Menu.vb | `Source/UI/Menu.vb` | ShowScriptDialog関数（行681-688） |

**主要処理フロー（ShowFilterProfilesDialogの場合）**:
1. **行4291-4292**: Restore Defaultsボタンの設定
2. **行4294-4299**: ボタンクリック時のアクション定義
3. **行4295**: 確認ダイアログの表示
4. **行4296**: デフォルト値の設定
5. **行4297**: MsgInfo呼び出し

#### Step 3: メッセージ表示関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfo関数（行1216-1220） |

### プログラム呼び出し階層図

```
MainForm.ShowFilterProfilesDialog (行4280)
    │
    ├─ MacroEditorDialog作成
    │
    ├─ bnContext.ClickAction設定 (行4294)
    │      │
    │      └─ Msg確認ダイアログ (行4295)
    │              │
    │              └─ 【OK時】
    │                      ├─ Value = getDefaults() (行4296)
    │                      └─ MsgInfo (行4297)
    │                              └─ General.Msg
    │                                      └─ TaskDialog.Show
    │
    └─ dialog.ShowDialog

CommandLineControl.ShowDialogEx (行126)
    │
    └─ bnContext.ClickAction設定 (行128)
           │
           └─ MsgOK確認 (行129)
                   │
                   └─ 【OK時】
                           ├─ Value = RestoreFunc.Invoke (行130)
                           └─ MsgInfo (行131)

Menu.ShowScriptDialog (行681)
    │
    └─ bnContext.ClickAction設定 (行683)
           │
           └─ MsgOK確認 (行684)
                   │
                   └─ 【OK時】
                           ├─ Value = defaults (行685)
                           └─ MsgInfo (行686)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Restore Defaults ───▶ 確認ダイアログ ───▶ 情報ダイアログ表示
    クリック               │                  + 設定値復元
                           ▼
                    ユーザー選択
                           │
              ┌────────────┴────────────┐
              ▼                        ▼
            Cancel                    OK
              │                        │
              ▼                        ▼
            何もしない          デフォルト値設定
                                       │
                                       ▼
                                   MsgInfo
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | ShowFilterProfilesDialog関数の定義 |
| CommandLineControl.vb | `Source/Controls/CommandLineControl.vb` | ソース | ShowDialogEx関数の定義 |
| Menu.vb | `Source/UI/Menu.vb` | ソース | ShowScriptDialog関数の定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数、MsgOK関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示の実装 |
| FilterCategory.vb | `Source/General/FilterCategory.vb` | ソース | デフォルトフィルタプロファイルの定義 |
