# 通知設計書 61-カテゴリ再作成警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「カテゴリ再作成警告」通知の設計仕様を定義する。フィルタプロファイル編集時に必須カテゴリ（Source, Crop, Resize）が削除された場合に、システムが自動的に再作成したことをユーザーに警告するための通知である。

### 本通知の処理概要

本通知は、ユーザーがフィルタプロファイルを編集し、必須カテゴリを誤って削除した場合にシステムの健全性を維持するために表示される警告通知である。

**業務上の目的・背景**：StaxRipの動画処理パイプラインでは、Source（ソース読み込み）、Crop（クロップ処理）、Resize（リサイズ処理）の3つのフィルタカテゴリが必須である。これらのカテゴリが存在しない場合、スクリプト生成やエンコード処理が正常に動作しない。ユーザーがプロファイル編集中に誤ってこれらのカテゴリを削除することを防止し、システムの安定性を確保する目的で本通知が実装されている。

**通知の送信タイミング**：ユーザーがFilters Profile Editorダイアログでフィルタプロファイルを編集し、OKボタンをクリックして変更を確定した際に、必須カテゴリの存在チェックが実行される。チェックの結果、Source、Crop、Resizeのいずれかが欠落している場合に本通知が表示される。

**通知の受信者**：現在操作中のユーザー（アプリケーションの操作者）に対してモーダルダイアログとして直接表示される。

**通知内容の概要**：削除された必須カテゴリの名前と、そのカテゴリがシステムによって自動的に再作成されたことを伝えるメッセージが表示される。

**期待されるアクション**：ユーザーは警告を確認し、OKボタンをクリックして処理を続行する。必要に応じて、再作成されたカテゴリの設定を確認・調整する。

## 通知種別

アプリ内通知（モーダルダイアログ / TaskDialog）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー操作をブロック） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

本通知はUIスレッド上でモーダルダイアログとして表示されるため、送信先決定ロジックは存在しない。操作中のユーザーに直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | TaskDialog |
| アイコン | Warning（警告アイコン） |
| タイトル | 動的生成（カテゴリ名を含む） |
| ボタン | OK |

### 本文テンプレート

```
The category '{カテゴリ名}' was recreated. A Source, Crop and Resize category is mandatory.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| カテゴリ名 | 再作成されたカテゴリの名前 | FilterCategory.Name | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | フィルタプロファイル編集ダイアログでOKクリック | 必須カテゴリ（Source, Crop, Resize）のいずれかが編集後のプロファイルに存在しない | ユーザーがプロファイル編集を確定した際に必須カテゴリの存在チェックを実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 必須カテゴリがすべて存在する場合 | Source, Crop, Resizeのすべてが編集後のプロファイルに含まれている場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[フィルタプロファイル編集ダイアログでOKクリック] --> B[プロファイルのパース処理]
    B --> C[デフォルトカテゴリの取得]
    C --> D{必須カテゴリのループ}
    D --> E{カテゴリが編集後プロファイルに存在するか?}
    E -->|Yes| F[次のカテゴリへ]
    E -->|No| G{Source/Crop/Resizeのいずれかか?}
    G -->|Yes| H[MsgWarn表示]
    H --> I[カテゴリを自動追加]
    I --> F
    G -->|No| F
    F --> D
    D -->|ループ終了| J[プロファイル保存]
    J --> K[設定保存]
    K --> L[メニュー再構築]
    L --> M[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用せず、アプリケーションの設定オブジェクト（Settings）を参照・更新する。

| データソース | 用途 | 備考 |
|-----------|------|------|
| s.AviSynthProfiles | AviSynthフィルタプロファイルの参照・更新 | スクリプトエンジンがAviSynthの場合 |
| s.VapourSynthProfiles | VapourSynthフィルタプロファイルの参照・更新 | スクリプトエンジンがVapourSynthの場合 |
| FilterCategory | デフォルトカテゴリ定義の参照 | 必須カテゴリの存在確認に使用 |

### 更新対象

| 対象 | 操作 | 概要 |
|-----------|------|------|
| filterProfiles | Add | 欠落した必須カテゴリをプロファイルリストに追加 |
| s.AviSynthProfiles / s.VapourSynthProfiles | 上書き | 編集後のプロファイルで設定を更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| パース失敗 | プロファイルのINI形式が不正 | 例外をキャッチしてg.ShowExceptionで表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作起点のため） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作時に即座に表示）

## セキュリティ考慮事項

- 本通知は外部への送信を行わないため、情報漏洩のリスクはない
- ユーザーの操作内容（プロファイル編集）はローカルに保存されるのみ

## 備考

- 本通知はVB.NETのMsgWarn関数を使用して実装されている
- 必須カテゴリの再作成はユーザーの意図しない削除から設定を保護する安全機構である

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィルタプロファイルとフィルタカテゴリの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FilterCategory.vb | `Source/Video/FilterCategory.vb` | FilterCategoryクラスの構造、Name/Filtersプロパティ |
| 1-2 | Settings.vb | `Source/General/Settings.vb` | AviSynthProfiles/VapourSynthProfilesプロパティの定義 |

**読解のコツ**: VB.NETのProperty構文とList(Of T)の使用法に注意。FilterCategoryはフィルタのグループ化を表現するクラス。

#### Step 2: エントリーポイントを理解する

フィルタプロファイル編集ダイアログの処理起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ShowFiltersProfileEditorメソッド（行4280-4333付近） |

**主要処理フロー**:
1. **行4290**: MacroEditorDialog表示とプロファイルテキストの設定
2. **行4301**: ダイアログ結果がOKの場合の処理開始
3. **行4303**: ParseFilterProfilesIniContentでプロファイルをパース
4. **行4305-4318**: 必須カテゴリの存在チェックループ
5. **行4315**: MsgWarn表示（本通知の発火点）
6. **行4316**: カテゴリの自動追加

#### Step 3: 通知表示関数を理解する

MsgWarn関数の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

**主要処理フロー**:
- **行1245**: MsgWarn関数定義（text, content, onlyOnceパラメータ）
- **行1250**: Msg関数呼び出し（TaskIcon.Warning, TaskButton.OK）

### プログラム呼び出し階層図

```
MainForm.ShowFiltersProfileEditorメソッド
    │
    ├─ MacroEditorDialog.ShowDialog()
    │      └─ ユーザーがプロファイルを編集
    │
    ├─ FilterCategory.ParseFilterProfilesIniContent()
    │      └─ 編集後テキストをパース
    │
    ├─ getDefaults() [ローカル関数]
    │      └─ デフォルトカテゴリリストを取得
    │
    ├─ MsgWarn() [MainModule]
    │      └─ Msg() [MainModule]
    │             └─ TaskDialog表示
    │
    └─ g.SaveSettings()
           └─ 設定をファイルに保存
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ユーザー編集テキスト ──▶ ParseFilterProfilesIniContent() ──▶ List(Of FilterCategory)
                               │
                               ▼
デフォルトカテゴリ ────▶ 存在チェックループ
                               │
                               ▼
欠落カテゴリ検出 ────────▶ MsgWarn() ──▶ 警告ダイアログ表示
                               │
                               ▼
カテゴリ自動追加 ────────▶ filterProfiles.Add()
                               │
                               ▼
                        s.AviSynthProfiles /
                        s.VapourSynthProfiles ──▶ 設定更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォームとプロファイル編集機能 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数を含む汎用モジュール |
| FilterCategory.vb | `Source/Video/FilterCategory.vb` | ソース | フィルタカテゴリのデータ構造と解析 |
| Settings.vb | `Source/General/Settings.vb` | ソース | アプリケーション設定の管理 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示のUIコンポーネント |
