# 通知設計書 62-字幕未検出通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「字幕未検出通知」の設計仕様を定義する。ハードコード字幕追加機能でIDX形式の字幕ファイルを開いた際に、字幕トラックが見つからない場合にユーザーに通知するための情報通知である。

### 本通知の処理概要

本通知は、ユーザーがハードコード字幕を追加しようとしてIDX形式の字幕ファイルを選択したが、そのファイル内に有効な字幕トラックが含まれていなかった場合に表示される情報通知である。

**業務上の目的・背景**：IDX形式（VobSub）の字幕ファイルは、複数の言語トラックを含むことができるコンテナ形式である。しかし、ファイルが破損していたり、正しく作成されていない場合、字幕データが含まれていない可能性がある。ユーザーが無効なファイルを選択した際に、処理を続行できない理由を明確に伝えることで、ユーザーエクスペリエンスを向上させる。

**通知の送信タイミング**：ユーザーがメニューから「Add Hardcoded Subtitle」機能を選択し、ファイル選択ダイアログでIDX形式のファイルを選択した直後に、Subtitle.Createメソッドでファイルをパースし、字幕トラックが0件の場合に表示される。

**通知の受信者**：現在操作中のユーザー（アプリケーションの操作者）に対してモーダルダイアログとして直接表示される。

**通知内容の概要**：選択されたIDXファイル内に字幕が見つからなかったことを伝えるシンプルなメッセージが表示される。

**期待されるアクション**：ユーザーは通知を確認し、OKボタンをクリックして処理を終了する。その後、別の有効な字幕ファイルを選択するか、字幕追加をキャンセルする。

## 通知種別

アプリ内通知（モーダルダイアログ / TaskDialog）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー操作をブロック） |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

本通知はUIスレッド上でモーダルダイアログとして表示されるため、送信先決定ロジックは存在しない。操作中のユーザーに直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | TaskDialog |
| アイコン | Info（情報アイコン） |
| タイトル | No subtitles found. |
| ボタン | OK |

### 本文テンプレート

```
No subtitles found.
```

### 添付ファイル

なし

## テンプレート変数

本通知にはテンプレート変数は使用されない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | N/A | N/A | N/A |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ハードコード字幕追加ダイアログでIDXファイルを選択 | Subtitle.Createの戻り値が空（Count = 0） | IDXファイルのパース結果に字幕トラックが含まれていない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 字幕トラックが1つ以上存在する場合 | パース結果のCountが1以上の場合は通知せず、言語選択ダイアログを表示 |
| IDX以外のファイル形式を選択した場合 | srt, ass等の他形式では本チェックは行われない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ハードコード字幕追加メニュー選択] --> B[ファイル選択ダイアログ表示]
    B --> C{ユーザーがファイルを選択}
    C -->|Cancel| D[処理終了]
    C -->|OK| E{ファイル拡張子チェック}
    E -->|idx| F[Subtitle.Createでパース]
    E -->|その他| G[AddHardcodedSubtitleFilter処理]
    F --> H{字幕トラック数チェック}
    H -->|Count = 0| I[MsgInfo表示]
    I --> J[Exit Sub]
    H -->|Count > 0| K[言語選択ダイアログ表示]
    K --> L{ユーザー選択}
    L -->|Cancel| J
    L -->|OK| M[IDXファイル更新]
    M --> G
    G --> N[処理完了]
    D --> N
    J --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。ファイルシステム上のIDXファイルを直接読み取る。

| データソース | 用途 | 備考 |
|-----------|------|------|
| IDXファイル | 字幕トラック情報の読み取り | VobSub形式のインデックスファイル |
| Subtitle.Create() | IDXファイルのパース | Subtitleクラスのファクトリメソッド |

### 更新対象

本通知の発火時点では更新処理は行われない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル読み取りエラー | IDXファイルが破損または読み取り不可 | Subtitle.Create内で例外処理（空リスト返却） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作起点のため） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作時に即座に表示）

## セキュリティ考慮事項

- 本通知は外部への送信を行わないため、情報漏洩のリスクはない
- ファイルパス情報は通知メッセージには含まれない

## 備考

- 本通知はVB.NETのMsgInfo関数を使用して実装されている
- IDX形式以外（srt, ass等）では字幕トラック数チェックは行われない
- 字幕が見つからない原因として、ファイル破損、不正なフォーマット、空のIDXファイルなどが考えられる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Subtitleクラスの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Subtitle.vb | `Source/General/Subtitle.vb` | SubtitleクラスとCreate静的メソッドの定義 |

**読解のコツ**: VB.NETのShared Function（静的メソッド）の使用法に注意。Createメソッドがファクトリパターンを実装している。

#### Step 2: エントリーポイントを理解する

ハードコード字幕追加機能のエントリーポイントを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ShowHardcodedSubtitleDialogメソッド（行4458-4492） |

**主要処理フロー**:
1. **行4459-4461**: OpenFileDialogの設定と表示
2. **行4463-4464**: ファイル選択結果のチェックと拡張子判定
3. **行4465**: Subtitle.Createでファイルをパース
4. **行4467-4470**: 字幕トラック数チェックと通知表示（本通知の発火点）
5. **行4472-4486**: 言語選択処理

#### Step 3: 通知表示関数を理解する

MsgInfo関数の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfo関数（行1216-1220） |

**主要処理フロー**:
- **行1216**: MsgInfo関数定義（title, contentパラメータ）
- **行1219**: Msg関数呼び出し（TaskIcon.Info, TaskButton.OK）

### プログラム呼び出し階層図

```
MainForm.ShowHardcodedSubtitleDialogFromTempDir()
    │  または
MainForm.ShowHardcodedSubtitleDialogFromLastSourceDir()
    │
    └─ MainForm.ShowHardcodedSubtitleDialog(initDir)
           │
           ├─ OpenFileDialog.ShowDialog()
           │      └─ ユーザーがファイルを選択
           │
           ├─ Subtitle.Create(fileName)
           │      └─ IDXファイルをパースして字幕リストを返却
           │
           ├─ MsgInfo() [MainModule] ※Count = 0の場合
           │      └─ Msg() [MainModule]
           │             └─ TaskDialog表示
           │
           └─ p.AddHardcodedSubtitleFilter() ※Count > 0の場合
                  └─ 字幕フィルタをスクリプトに追加
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ファイルパス(*.idx) ──────▶ Subtitle.Create() ──────▶ List(Of Subtitle)
                               │
                               ▼
                        字幕トラック数判定
                               │
           ┌───────────────────┴───────────────────┐
           ▼                                       ▼
    Count = 0                                Count > 0
           │                                       │
           ▼                                       ▼
    MsgInfo() ──▶ 情報ダイアログ表示     SelectionBox表示
           │                                       │
           ▼                                       ▼
    処理終了(Exit Sub)                    AddHardcodedSubtitleFilter()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォームとハードコード字幕追加機能 |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数を含む汎用モジュール |
| Subtitle.vb | `Source/General/Subtitle.vb` | ソース | 字幕データ構造とパース処理 |
| FileTypes.vb | `Source/General/FileTypes.vb` | ソース | SubtitleExludingContainersフィルタ定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示のUIコンポーネント |
