# 通知設計書 63-引数解析エラー警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「引数解析エラー警告」通知の設計仕様を定義する。コマンドライン引数の解析処理中にエラーが発生した場合に、ユーザーに問題のある引数と詳細なエラーメッセージを表示するための警告通知である。

### 本通知の処理概要

本通知は、StaxRipをコマンドラインから起動する際に渡された引数の解析に失敗した場合に表示される警告通知である。バッチ処理やスクリプトからの自動化操作において、不正な引数が指定された場合のトラブルシューティングを支援する。

**業務上の目的・背景**：StaxRipはコマンドライン引数を使用した自動化やバッチ処理をサポートしている。ユーザーや外部スクリプトから渡された引数が不正な形式であったり、認識できないコマンドであった場合に、どの引数に問題があるかを明確に伝えることで、デバッグを容易にする。

**通知の送信タイミング**：アプリケーション起動時にProcessCommandLineメソッドがコマンドライン引数を順次処理する際、各引数の解析でExceptionがスローされた場合に表示される。ファイルパスとして認識できず、かつCommandManager.ProcessCommandLineArgumentでも処理できない引数が対象となる。

**通知の受信者**：現在操作中のユーザー（アプリケーションの操作者）に対してモーダルダイアログとして直接表示される。

**通知内容の概要**：問題のある引数の値と、発生した例外のメッセージが表示される。

**期待されるアクション**：ユーザーは通知を確認し、コマンドライン引数の形式を見直す。バッチファイルやスクリプトを修正して再実行する。

## 通知種別

アプリ内通知（モーダルダイアログ / TaskDialog）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー操作をブロック） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

本通知はUIスレッド上でモーダルダイアログとして表示されるため、送信先決定ロジックは存在しない。操作中のユーザーに直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | TaskDialog |
| アイコン | Warning（警告アイコン） |
| タイトル | Error parsing argument: |
| ボタン | OK |

### 本文テンプレート

```
Error parsing argument:

{引数の値}

{例外メッセージ}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| 引数の値 | 解析に失敗した引数の文字列 | args配列の要素 | Yes |
| 例外メッセージ | スローされた例外のMessageプロパティ | Exception.Message | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| アプリケーション起動 | コマンドライン引数の解析処理 | 引数がファイルとして存在せず、かつCommandManagerで処理できない | Try-Catchブロックで例外がキャッチされた場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 引数がファイルパスとして有効な場合 | arg.FileExists()がTrueの場合は処理対象ファイルとして扱う |
| CommandManagerで正常処理された場合 | ProcessCommandLineArgumentがTrueを返した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[アプリケーション起動] --> B[ProcessCommandLine呼び出し]
    B --> C[コマンドライン解析]
    C --> D{引数リストのループ}
    D --> E{引数はファイルパス?}
    E -->|Yes| F[ファイルリストに追加]
    E -->|No| G[CommandManager.ProcessCommandLineArgument呼び出し]
    G --> H{処理成功?}
    H -->|Yes| I[次の引数へ]
    H -->|No| J[例外スロー]
    J --> K[Catch ブロック]
    K --> L[MsgWarn表示]
    L --> I
    F --> I
    I --> D
    D -->|ループ終了| M[ファイル処理開始]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データソース | 用途 | 備考 |
|-----------|------|------|
| Environment.CommandLine | コマンドライン文字列の取得 | OS提供のコマンドライン |
| CommandManager | コマンド引数の処理 | 組み込みコマンドの実行 |

### 更新対象

本通知の発火時点では更新処理は行われない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不正な引数形式 | コマンド形式が認識できない | 警告表示後、次の引数の処理を続行 |
| 存在しないファイル指定 | ファイルパスとして解釈されるが存在しない | 同様に警告表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（アプリケーション起動時に即座に表示）

## セキュリティ考慮事項

- 本通知は外部への送信を行わないため、情報漏洩のリスクはない
- コマンドライン引数にはファイルパス等の機密情報が含まれる可能性があるが、ローカル表示のみのため問題なし

## 備考

- 本通知はVB.NETのMsgWarn関数を使用して実装されている
- エラー発生後も他の引数の処理は継続される
- BR2定数（改行2つ）を使用してメッセージをフォーマット

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コマンドライン解析の基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ParseCommandLineメソッドの存在確認 |
| 1-2 | CommandManager.vb | `Source/General/CommandManager.vb` | ProcessCommandLineArgumentメソッドの定義 |

**読解のコツ**: VB.NETの例外処理（Try-Catch）と拡張メソッド（FileExists）に注意。

#### Step 2: エントリーポイントを理解する

コマンドライン処理の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ProcessCommandLineメソッド（行4911-4952） |

**主要処理フロー**:
1. **行4912**: 空コマンドラインのチェック
2. **行4914**: ParseCommandLineで引数を配列に分解
3. **行4925-4944**: 引数ループとTry-Catch処理
4. **行4935-4940**: ファイル存在チェックとCommandManager呼び出し
5. **行4942-4944**: 例外キャッチとMsgWarn表示（本通知の発火点）

#### Step 3: 通知表示関数を理解する

MsgWarn関数の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

**主要処理フロー**:
- **行1245**: MsgWarn関数定義（text, content, onlyOnceパラメータ）
- **行1250**: Msg関数呼び出し（TaskIcon.Warning, TaskButton.OK）

### プログラム呼び出し階層図

```
MainForm.OnShown()
    │
    └─ MainForm.ProcessCommandLine(Environment.CommandLine)
           │
           ├─ ParseCommandLine(commandLine)
           │      └─ コマンドライン文字列を配列に分解
           │
           ├─ [引数ループ]
           │      │
           │      ├─ arg.FileExists()
           │      │      └─ ファイルパスとして存在するか確認
           │      │
           │      └─ CommandManager.ProcessCommandLineArgument(arg)
           │             └─ 組み込みコマンドとして処理
           │
           └─ [例外発生時]
                  │
                  └─ MsgWarn() [MainModule]
                         └─ Msg() [MainModule]
                                └─ TaskDialog表示
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Environment.CommandLine ──▶ ParseCommandLine() ──▶ String配列
                               │
                               ▼
                        引数ごとのループ処理
                               │
           ┌───────────────────┼───────────────────┐
           ▼                   ▼                   ▼
    FileExists()     CommandManager.Process...   例外発生
           │                   │                   │
           ▼                   ▼                   ▼
    ファイルリスト追加    コマンド実行         MsgWarn()
                                                   │
                                                   ▼
                                            警告ダイアログ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォームとコマンドライン処理 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数とBR2定数を含む汎用モジュール |
| CommandManager.vb | `Source/General/CommandManager.vb` | ソース | コマンドライン引数の処理ロジック |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示のUIコンポーネント |
| StringExtensions.vb | `Source/General/StringExtensions.vb` | ソース | FileExists拡張メソッドの定義 |
