# 通知設計書 64-手動マージ案内通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「手動マージ案内通知」の設計仕様を定義する。複数のソースファイルをマージする際にmkvmergeツールが失敗した場合に、ユーザーに手動でのマージを案内するための情報通知である。

### 本通知の処理概要

本通知は、ユーザーが「Merge」機能を使用して複数のビデオファイルを結合しようとした際に、mkvmergeによる自動マージ処理が例外をスローした場合に表示される案内通知である。自動処理の失敗をユーザーに通知し、代替手段（手動マージやサポートフォーラムへの相談）を提示する。

**業務上の目的・背景**：StaxRipは複数のビデオファイルを1つに結合するマージ機能を提供している。内部的にmkvmergeツールを使用しているが、特定のファイル形式やコーデックの組み合わせによっては結合に失敗することがある。失敗時にユーザーが適切な対処を行えるよう、明確なガイダンスを提供する必要がある。

**通知の送信タイミング**：ShowOpenSourceMergeFilesDialogメソッドで、mkvmerge（proc.Start()）の実行時に例外がキャッチされた直後に表示される。対象はMPG/VOB以外のファイル形式でのマージ操作時となる。

**通知の受信者**：現在操作中のユーザー（アプリケーションの操作者）に対してモーダルダイアログとして直接表示される。

**通知内容の概要**：「Manual Merging」というタイトルで、ユーザーに適切なツールを使用した手動マージまたはサポートフォーラムへの相談を促すメッセージが表示される。

**期待されるアクション**：ユーザーは通知を確認し、別のマージツール（MKVToolNix GUI等）を使用して手動でファイルを結合するか、StaxRipのサポートフォーラムで解決策を探す。

## 通知種別

アプリ内通知（モーダルダイアログ / TaskDialog）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー操作をブロック） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

本通知はUIスレッド上でモーダルダイアログとして表示されるため、送信先決定ロジックは存在しない。操作中のユーザーに直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | TaskDialog |
| アイコン | Info（情報アイコン） |
| タイトル | Manual Merging |
| ボタン | OK |

### 本文テンプレート

```
Please merge the files manually with an appropriate tool or visit the support forum].
```

注：メッセージ内の `]` は原文のまま（コード上のタイポと思われる）

### 添付ファイル

なし

## テンプレート変数

本通知にはテンプレート変数は使用されない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | N/A | N/A | N/A |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ファイルマージ処理の実行（proc.Start()） | mkvmergeの実行で例外が発生 | Try-Catchブロックで例外がキャッチされた場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| MPG/VOBファイルの場合 | OpenVideoSourceFilesメソッドで処理されるため本通知は発生しない |
| mkvmergeが正常終了した場合 | 例外が発生しなければ通知されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Merge機能選択] --> B[SourceFilesForm表示]
    B --> C{ユーザーがファイルを選択}
    C -->|Cancel| D[処理終了]
    C -->|OK| E{ファイル拡張子チェック}
    E -->|mpg/vob| F[OpenVideoSourceFiles処理]
    E -->|その他| G[Proc初期化]
    G --> H[mkvmergeコマンド設定]
    H --> I[MediaInfo ログ出力]
    I --> J[proc.Start実行]
    J --> K{例外発生?}
    K -->|No| L[出力ファイル存在チェック]
    K -->|Yes| M[g.ShowException表示]
    M --> N[MsgInfo表示]
    N --> O[AbortException スロー]
    L --> P[後続処理]
    D --> Q[終了]
    F --> Q
    O --> Q
    P --> Q
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データソース | 用途 | 備考 |
|-----------|------|------|
| SourceFilesForm | ユーザー選択ファイルの取得 | マージ対象ファイルリスト |
| Package.mkvmerge | mkvmergeツールのパス取得 | 外部ツール呼び出し |
| MediaInfo | ファイル情報のログ出力 | マージ前の情報記録 |

### 更新対象

本通知の発火時点では更新処理は行われない。処理は中断される。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| mkvmerge実行失敗 | mkvmergeがインストールされていない/パスが通っていない | MsgInfo表示後、AbortExceptionをスロー |
| ファイル形式非互換 | マージ不可能なファイル形式の組み合わせ | 同様にMsgInfo表示 |
| ツールエラー | mkvmerge内部エラー | 同様にMsgInfo表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作起点のため） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作時に即座に表示）

## セキュリティ考慮事項

- 本通知は外部への送信を行わないため、情報漏洩のリスクはない
- サポートフォーラムへの誘導があるが、ユーザーが自発的にアクセスする形式

## 備考

- 本通知はVB.NETのMsgInfo関数を使用して実装されている
- 通知後にAbortExceptionがスローされ、処理が中断される
- g.ShowExceptionで詳細な例外情報も別途表示される
- メッセージ内の `]` は原文のタイポである可能性が高い

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Proc（プロセス管理）クラスとSourceFilesFormの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Proc.vb | `Source/General/Proc.vb` | Procクラスの構造、Start()メソッド |
| 1-2 | SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | ファイル選択UIの構造 |

**読解のコツ**: ProcクラスはProcess.Startのラッパーで、外部ツール呼び出しを管理。IsMergeフラグの役割に注意。

#### Step 2: エントリーポイントを理解する

マージ機能のエントリーポイントを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ShowOpenSourceMergeFilesDialogメソッド（行5100-5157） |

**主要処理フロー**:
1. **行5104-5108**: SourceFilesFormの表示とマージモード設定
2. **行5111-5114**: MPG/VOBファイルの判定と分岐
3. **行5115-5126**: Proc初期化とmkvmergeコマンド設定
4. **行5127-5133**: proc.Start()呼び出しと例外処理（本通知の発火点）
5. **行5131**: MsgInfo表示
6. **行5132**: AbortExceptionスロー

#### Step 3: 通知表示関数を理解する

MsgInfo関数の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfo関数（行1216-1220） |

**主要処理フロー**:
- **行1216**: MsgInfo関数定義（title, contentパラメータ）
- **行1219**: Msg関数呼び出し（TaskIcon.Info, TaskButton.OK）

### プログラム呼び出し階層図

```
MainForm.ShowOpenSourceMergeFilesDialog()
    │
    ├─ SourceFilesForm.ShowDialog()
    │      └─ ユーザーがファイルを選択（IsMerge = True）
    │
    ├─ [mpg/vobの場合]
    │      └─ OpenVideoSourceFiles()
    │
    └─ [その他の場合]
           │
           ├─ Proc初期化
           │      ├─ Header = "Merge source files"
           │      ├─ Encoding = UTF8
           │      └─ Package = mkvmerge
           │
           ├─ MediaInfo.GetSummary() [ログ出力]
           │
           └─ proc.Start()
                  │
                  ├─ [正常終了] → 出力ファイル処理
                  │
                  └─ [例外発生]
                         │
                         ├─ g.ShowException(ex)
                         │
                         ├─ MsgInfo() [MainModule]
                         │      └─ Msg() → TaskDialog表示
                         │
                         └─ AbortException スロー
```

### データフロー図

```
[入力]                      [処理]                           [出力]

SourceFilesForm選択 ──────▶ GetFiles() ──────────▶ List(Of String)
        │
        ▼
ファイル拡張子判定
        │
        ├─ [mpg/vob] ──▶ OpenVideoSourceFiles()
        │
        └─ [その他]
               │
               ▼
        mkvmerge呼び出し
               │
        ┌──────┴──────┐
        ▼             ▼
    成功          例外発生
        │             │
        ▼             ▼
出力ファイル処理   g.ShowException()
                      │
                      ▼
                MsgInfo() ──▶ 案内ダイアログ表示
                      │
                      ▼
              AbortException ──▶ 処理中断
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォームとマージ機能 |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数を含む汎用モジュール |
| Proc.vb | `Source/General/Proc.vb` | ソース | 外部プロセス実行管理 |
| SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | ソース | ファイル選択UI |
| Package.vb | `Source/General/Package.vb` | ソース | 外部ツール（mkvmerge）の定義 |
| MediaInfo.vb | `Source/General/MediaInfo.vb` | ソース | メディア情報取得 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示のUIコンポーネント |
