# 通知設計書 65-一時フォルダ作成失敗エラー

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「一時フォルダ作成失敗エラー」通知の設計仕様を定義する。Blu-rayディスクのデマックス処理時に一時フォルダの作成に失敗した場合に、ユーザーに問題を通知するためのエラー通知である。

### 本通知の処理概要

本通知は、Blu-rayソースからのデマックス処理を開始する際に、指定された一時フォルダ（作業ディレクトリ）の作成に失敗した場合に表示されるエラー通知である。ディスク空き容量不足、アクセス権限不足、パスの不正などの原因をユーザーに伝える。

**業務上の目的・背景**：Blu-rayディスクからのデマックス処理は大量の一時ファイルを生成するため、適切な作業ディレクトリが必要である。ディレクトリの作成に失敗した場合、処理を続行できないため、ユーザーに明確なエラーメッセージを表示して問題解決を促す必要がある。

**通知の送信タイミング**：Blu-rayソース選択ダイアログで出力フォルダを設定し、OKボタンをクリックした後、Directory.CreateDirectoryの実行時に例外がキャッチされた場合に表示される。

**通知の受信者**：現在操作中のユーザー（アプリケーションの操作者）に対してモーダルダイアログとして直接表示される。

**通知内容の概要**：一時フォルダの作成に失敗したことと、問題のあるフォルダパスが表示される。

**期待されるアクション**：ユーザーは通知を確認し、別の一時フォルダを指定するか、ディスク空き容量を確保するか、フォルダへのアクセス権限を確認する。

## 通知種別

アプリ内通知（モーダルダイアログ / TaskDialog）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー操作をブロック） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

本通知はUIスレッド上でモーダルダイアログとして表示されるため、送信先決定ロジックは存在しない。操作中のユーザーに直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | TaskDialog |
| アイコン | Error（エラーアイコン） |
| タイトル | The temp folder could not be created. |
| ボタン | OK |
| コピーボタン | あり |

### 本文テンプレート

```
The temp folder could not be created.

{フォルダパス}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| フォルダパス | 作成に失敗したフォルダのパス | form.OutputFolder | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Blu-rayデマックスダイアログでOKクリック | Directory.CreateDirectoryで例外が発生 | フォルダが存在せず、作成にも失敗した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| フォルダが既に存在する場合 | Directory.Exists()がTrueの場合は作成処理をスキップ |
| フォルダ作成が成功した場合 | 例外が発生しなければ通知されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Blu-rayソース選択] --> B[プレイリスト選択]
    B --> C[タイトル入力]
    C --> D[作業ディレクトリ設定]
    D --> E[デマックスダイアログ表示]
    E --> F{ダイアログ結果}
    F -->|Cancel| G[処理終了]
    F -->|OK| H{出力フォルダ存在チェック}
    H -->|存在する| I[固定ドライブチェックへ]
    H -->|存在しない| J[Directory.CreateDirectory実行]
    J --> K{作成成功?}
    K -->|Yes| I
    K -->|No - 例外発生| L[MsgError表示]
    L --> M[Exit Sub]
    I --> N[後続処理]
    G --> O[終了]
    M --> O
    N --> O
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データソース | 用途 | 備考 |
|-----------|------|------|
| form.OutputFolder | 出力フォルダパスの取得 | ユーザー入力値 |
| Directory.Exists() | フォルダ存在確認 | System.IO |
| Directory.CreateDirectory() | フォルダ作成 | System.IO |

### 更新対象

本通知の発火時点では更新処理は行われない。処理は中断される。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| UnauthorizedAccessException | アクセス権限不足 | MsgError表示後、Exit Sub |
| DirectoryNotFoundException | パスが無効 | 同様にMsgError表示 |
| IOException | ディスク空き容量不足等 | 同様にMsgError表示 |
| PathTooLongException | パスが長すぎる | 同様にMsgError表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作起点のため） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作時に即座に表示）

## セキュリティ考慮事項

- 本通知は外部への送信を行わないため、情報漏洩のリスクはない
- フォルダパス情報が表示されるが、ローカル表示のみのため問題なし

## 備考

- 本通知はVB.NETのMsgError関数を使用して実装されている
- BR2定数（改行2つ）を使用してメッセージをフォーマット
- 通知後はExit Subで処理が中断される
- MsgErrorはコピーボタン付きのダイアログを表示する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Blu-rayデマックス処理の基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MainForm.vb | `Source/Forms/MainForm.vb` | Blu-ray処理関連のフォーム変数 |
| 1-2 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | デマックス設定フォームの構造 |

**読解のコツ**: form.OutputFolderはユーザーが指定した出力先パス。VB.NETのDirectory.CreateDirectoryの例外処理に注意。

#### Step 2: エントリーポイントを理解する

Blu-rayデマックス処理の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | Blu-ray処理部分（行5230-5320付近） |

**主要処理フロー**:
1. **行5255**: ダイアログ結果がOKの場合の処理開始
2. **行5256**: Directory.Existsで出力フォルダ存在チェック
3. **行5257-5262**: Try-Catchブロックでフォルダ作成
4. **行5260**: MsgError表示（本通知の発火点）
5. **行5261**: Exit Subで処理中断

#### Step 3: 通知表示関数を理解する

MsgError関数の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgError関数（行1222-1241） |

**主要処理フロー**:
- **行1222**: MsgError関数定義（title, content, timeoutパラメータ）
- **行1231-1240**: TaskDialogの設定とShowCopyButton = True

### プログラム呼び出し階層図

```
[Blu-ray/M2TS処理開始]
    │
    ├─ プレイリスト選択
    │      └─ PlaylistFolder.Escape
    │
    ├─ タイトル入力（InputBox.Show）
    │
    ├─ 作業ディレクトリ決定
    │      ├─ p.TempDir使用
    │      └─ または FolderBrowserDialog
    │
    └─ form.ShowDialog()
           │
           └─ [DialogResult.OK]
                  │
                  ├─ Directory.Exists(form.OutputFolder)
                  │      └─ [存在しない場合]
                  │             │
                  │             └─ Directory.CreateDirectory()
                  │                    │
                  │                    └─ [例外発生]
                  │                           │
                  │                           └─ MsgError() [MainModule]
                  │                                  └─ TaskDialog表示
                  │
                  └─ g.IsFixedDrive() チェック
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ユーザー入力パス ─────────▶ Directory.Exists() ──────▶ Boolean
        │
        ├─ [存在する] ──▶ 次の処理へ
        │
        └─ [存在しない]
               │
               ▼
        Directory.CreateDirectory()
               │
        ┌──────┴──────┐
        ▼             ▼
    成功          例外発生
        │             │
        ▼             ▼
次の処理へ      MsgError()
                      │
                      ▼
               エラーダイアログ表示
                      │
                      ▼
               Exit Sub ──▶ 処理中断
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォームとBlu-ray処理 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数とBR2定数を含む汎用モジュール |
| eac3toForm.vb | `Source/Forms/eac3toForm.vb` | ソース | eac3toデマックス設定フォーム |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示のUIコンポーネント |
