# 通知設計書 66-固定ドライブエラー

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「固定ドライブエラー」通知の設計仕様を定義する。一時ディレクトリとしてリムーバブルドライブやネットワークドライブが指定された場合に、ユーザーにエラーを通知するための通知である。

### 本通知の処理概要

本通知は、Blu-rayデマックス処理の一時ディレクトリとして、固定ローカルドライブ以外（USBメモリ、外付けHDD、ネットワークドライブ等）が指定された場合に表示されるエラー通知である。処理の安定性と信頼性を確保するための制約をユーザーに伝える。

**業務上の目的・背景**：Blu-rayデマックス処理は大量のデータを一時的に保存するため、高速かつ安定したストレージが必要である。リムーバブルドライブやネットワークドライブは、転送速度の問題、接続の不安定さ、突然の切断リスクがあるため、処理の信頼性を確保するために固定ローカルドライブのみを許可している。

**通知の送信タイミング**：Blu-rayソース選択後、一時フォルダの作成に成功した直後に、g.IsFixedDrive()メソッドで出力フォルダのドライブ種別をチェックする。固定ドライブでない場合に表示される。

**通知の受信者**：現在操作中のユーザー（アプリケーションの操作者）に対してモーダルダイアログとして直接表示される。

**通知内容の概要**：一時ディレクトリとして固定ローカルドライブのみがサポートされていることを伝えるメッセージが表示される。

**期待されるアクション**：ユーザーは通知を確認し、固定ローカルドライブ（内蔵HDD/SSD）上の別のフォルダを一時ディレクトリとして指定する。

## 通知種別

アプリ内通知（モーダルダイアログ / TaskDialog）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー操作をブロック） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

本通知はUIスレッド上でモーダルダイアログとして表示されるため、送信先決定ロジックは存在しない。操作中のユーザーに直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | TaskDialog |
| アイコン | Error（エラーアイコン） |
| タイトル | Only fixed local drives are supported as temp dir. |
| ボタン | OK |
| コピーボタン | あり |

### 本文テンプレート

```
Only fixed local drives are supported as temp dir.
```

### 添付ファイル

なし

## テンプレート変数

本通知にはテンプレート変数は使用されない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | N/A | N/A | N/A |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Blu-rayデマックスダイアログでOKクリック後のドライブチェック | g.IsFixedDrive(form.OutputFolder)がFalse | 指定フォルダが固定ローカルドライブ上にない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 固定ドライブの場合 | g.IsFixedDrive()がTrueの場合は通知されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[一時フォルダ作成成功] --> B[g.IsFixedDrive チェック]
    B --> C{固定ドライブか?}
    C -->|Yes| D[ディスク空き容量チェック]
    C -->|No| E[MsgError表示]
    E --> F[Exit Sub]
    D --> G[後続処理（eac3toデマックス）]
    F --> H[終了]
    G --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データソース | 用途 | 備考 |
|-----------|------|------|
| g.IsFixedDrive() | ドライブ種別判定 | DriveInfo.DriveTypeを使用 |
| form.OutputFolder | 出力フォルダパスの取得 | ユーザー入力値 |
| DriveInfo | ドライブ情報取得 | System.IO |

### 更新対象

本通知の発火時点では更新処理は行われない。処理は中断される。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リムーバブルドライブ | USBメモリ、外付けHDD等 | MsgError表示後、Exit Sub |
| ネットワークドライブ | マッピングされたネットワーク共有 | 同様にMsgError表示 |
| CDRom/DVD | 光学ドライブ | 同様にMsgError表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作起点のため） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作時に即座に表示）

## セキュリティ考慮事項

- 本通知は外部への送信を行わないため、情報漏洩のリスクはない
- ドライブ情報はセキュリティ上のリスクが低い

## 備考

- 本通知はVB.NETのMsgError関数を使用して実装されている
- g.IsFixedDriveはDriveInfo.DriveType == DriveType.Fixedで判定
- No.65（一時フォルダ作成失敗エラー）の直後に実行されるチェック
- 通知後はExit Subで処理が中断される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ドライブ判定ロジックの基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | IsFixedDriveメソッドの定義 |
| 1-2 | System.IO.DriveInfo | .NET Framework | DriveType列挙型の理解 |

**読解のコツ**: DriveType.Fixed = 3（固定ディスク）。Path.GetPathRootでドライブレターを抽出。

#### Step 2: エントリーポイントを理解する

ドライブチェックの呼び出し箇所を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | Blu-ray処理部分（行5265-5268） |

**主要処理フロー**:
1. **行5263**: 一時フォルダ作成成功後の処理
2. **行5265**: g.IsFixedDrive(form.OutputFolder)チェック
3. **行5266**: MsgError表示（本通知の発火点）
4. **行5267**: Exit Subで処理中断

#### Step 3: 通知表示関数を理解する

MsgError関数の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgError関数（行1222-1241） |

**主要処理フロー**:
- **行1222**: MsgError関数定義
- **行1236**: ShowCopyButton = True

### プログラム呼び出し階層図

```
[Blu-ray処理 - 一時フォルダ作成成功後]
    │
    └─ g.IsFixedDrive(form.OutputFolder)
           │
           ├─ Path.GetPathRoot(path)
           │      └─ ドライブレター抽出（例: "C:\"）
           │
           ├─ DriveInfo(root)
           │      └─ ドライブ情報取得
           │
           └─ DriveType == DriveType.Fixed
                  │
                  ├─ [True] ──▶ 後続処理（ディスク容量チェック）
                  │
                  └─ [False]
                         │
                         └─ MsgError() [MainModule]
                                └─ TaskDialog表示
                                       │
                                       └─ Exit Sub
```

### データフロー図

```
[入力]                      [処理]                           [出力]

form.OutputFolder ─────────▶ Path.GetPathRoot() ──────▶ ドライブルート
        │
        ▼
DriveInfo(root)
        │
        ▼
DriveType判定
        │
        ├─ [Fixed] ──▶ 次の処理へ（ディスク容量チェック）
        │
        └─ [その他]
               │
               ▼
        MsgError() ──▶ エラーダイアログ表示
               │
               ▼
        Exit Sub ──▶ 処理中断
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォームとBlu-ray処理 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数を含む汎用モジュール |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | IsFixedDriveメソッドの定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示のUIコンポーネント |
