# 通知設計書 67-無効フォーマット警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「無効フォーマット警告」通知の設計仕様を定義する。ターゲット画像サイズの入力形式が不正な場合に、ユーザーに警告を通知するための通知である。

### 本通知の処理概要

本通知は、ユーザーがターゲット画像サイズをメニューから指定する際に、入力された値の形式が認識できない場合に表示される警告通知である。正しい入力形式をユーザーに示唆する。

**業務上の目的・背景**：StaxRipでは動画のリサイズ処理において、ユーザーがターゲット解像度を指定できる。入力形式として「1920x1080」のような幅x高さ形式、または単一の数値（ピクセル数）が期待される。これらの形式に合致しない入力があった場合に、ユーザーに正しい入力を促す必要がある。

**通知の送信タイミング**：TargetImageMenuClickメソッドで、ユーザー入力値の解析を試みた結果、整数値として認識できず、かつ「幅x高さ」形式でも認識できなかった場合に表示される。

**通知の受信者**：現在操作中のユーザー（アプリケーションの操作者）に対してモーダルダイアログとして直接表示される。

**通知内容の概要**：入力された形式が無効であることを伝えるシンプルなメッセージが表示される。

**期待されるアクション**：ユーザーは通知を確認し、正しい形式（例：「1920x1080」または「1920」）で再入力する。

## 通知種別

アプリ内通知（モーダルダイアログ / TaskDialog）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー操作をブロック） |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

本通知はUIスレッド上でモーダルダイアログとして表示されるため、送信先決定ロジックは存在しない。操作中のユーザーに直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | TaskDialog |
| アイコン | Warning（警告アイコン） |
| タイトル | Invalid format |
| ボタン | OK |

### 本文テンプレート

```
Invalid format
```

### 添付ファイル

なし

## テンプレート変数

本通知にはテンプレート変数は使用されない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | N/A | N/A | N/A |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ターゲット画像サイズメニューからの値入力 | value.IsInt()がFalseかつ「幅x高さ」形式でもない | 入力値が整数でなく、かつWIDTHxHEIGHT形式でもない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 整数値として認識できる場合 | value.IsInt()がTrueの場合はピクセル数として処理 |
| 「幅x高さ」形式の場合 | 「x」を含み、分割後の両方が整数の場合は解像度として処理 |
| ユーザーがキャンセルした場合 | Macro.ExpandGUIでCancelがTrueの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ターゲット画像サイズメニュー選択] --> B[Macro.Expand処理]
    B --> C[Macro.ExpandGUI処理]
    C --> D{キャンセル?}
    D -->|Yes| E[Exit Sub]
    D -->|No| F{value.IsInt?}
    F -->|Yes| G[SetTargetImageSizeByPixel呼び出し]
    G --> E
    F -->|No| H{「x」を含むか?}
    H -->|No| I[MsgWarn表示]
    H -->|Yes| J[SplitNoEmptyAndWhiteSpaceで分割]
    J --> K{分割後2要素かつ両方Int?}
    K -->|Yes| L[SetTargetImageSize呼び出し]
    K -->|No| I
    L --> E
    I --> E
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データソース | 用途 | 備考 |
|-----------|------|------|
| Macro.Expand() | マクロ変数の展開 | 入力値の前処理 |
| Macro.ExpandGUI() | GUI入力の展開 | ダイアログからの入力取得 |

### 更新対象

本通知の発火時点では更新処理は行われない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効な形式 | 整数でもWIDTHxHEIGHT形式でもない入力 | MsgWarn表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作起点のため） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作時に即座に表示）

## セキュリティ考慮事項

- 本通知は外部への送信を行わないため、情報漏洩のリスクはない
- 入力値はローカルでの処理のみ

## 備考

- 本通知はVB.NETのMsgWarn関数を使用して実装されている
- 有効な入力形式：単一整数（例：1920）、WIDTHxHEIGHT（例：1920x1080）
- マクロ変数を含む入力も許可される（Macro.Expandで展開）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

入力値の解析ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StringExtensions.vb | `Source/General/StringExtensions.vb` | IsInt(), SplitNoEmptyAndWhiteSpace()拡張メソッド |
| 1-2 | Macro.vb | `Source/General/Macro.vb` | Expand(), ExpandGUI()メソッド |

**読解のコツ**: VB.NETの拡張メソッドとStringクラスのContainsメソッドに注意。IsInt()は文字列が整数として解釈可能かを判定。

#### Step 2: エントリーポイントを理解する

ターゲット画像サイズ設定の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | TargetImageMenuClickメソッド（行5615-5642） |

**主要処理フロー**:
1. **行5616**: g.EnableFilter("Resize")でリサイズフィルタ有効化
2. **行5618-5625**: Macro.ExpandとMacro.ExpandGUIで値を展開
3. **行5627-5629**: value.IsInt()チェックとSetTargetImageSizeByPixel呼び出し
4. **行5632-5638**: 「x」を含む場合の分割と検証
5. **行5641**: MsgWarn表示（本通知の発火点）

#### Step 3: 通知表示関数を理解する

MsgWarn関数の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数（行1245-1255） |

**主要処理フロー**:
- **行1245**: MsgWarn関数定義
- **行1250**: Msg関数呼び出し（TaskIcon.Warning, TaskButton.OK）

### プログラム呼び出し階層図

```
TargetImageMenuClickメソッド(value)
    │
    ├─ Macro.Expand(value)
    │      └─ マクロ変数を実際の値に展開
    │
    ├─ Macro.ExpandGUI(value)
    │      └─ GUIダイアログからの入力取得
    │
    ├─ [キャンセル時] ──▶ Exit Sub
    │
    ├─ value.IsInt() チェック
    │      │
    │      ├─ [True] ──▶ SetTargetImageSizeByPixel()
    │      │
    │      └─ [False]
    │             │
    │             └─ value.Contains("x") チェック
    │                    │
    │                    ├─ [True] ──▶ SplitNoEmptyAndWhiteSpace("x")
    │                    │                  │
    │                    │                  └─ 分割検証
    │                    │                         │
    │                    │                         ├─ [OK] ──▶ SetTargetImageSize()
    │                    │                         │
    │                    │                         └─ [NG] ──▶ MsgWarn()
    │                    │
    │                    └─ [False] ──▶ MsgWarn()
    │
    └─ MsgWarn() [MainModule]
           └─ Msg() ──▶ TaskDialog表示
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ユーザー入力 ─────────────▶ Macro.Expand() ──────────▶ 展開後文字列
        │
        ▼
Macro.ExpandGUI()
        │
        ▼
形式チェック
        │
        ├─ [整数] ──▶ SetTargetImageSizeByPixel()
        │
        ├─ [WIDTHxHEIGHT] ──▶ SetTargetImageSize()
        │
        └─ [その他]
               │
               ▼
        MsgWarn() ──▶ 警告ダイアログ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォームとリサイズ設定 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数を含む汎用モジュール |
| StringExtensions.vb | `Source/General/StringExtensions.vb` | ソース | 文字列拡張メソッド（IsInt等） |
| Macro.vb | `Source/General/Macro.vb` | ソース | マクロ展開処理 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示のUIコンポーネント |
