# 通知設計書 68-パラメータ無効エラー

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「パラメータ無効エラー」通知の設計仕様を定義する。ソースフィルタが無効なパラメータ（幅、高さ、フレーム数、フレームレート等）を返した場合に、ユーザーにエラーを通知するための通知である。

### 本通知の処理概要

本通知は、ソーススクリプトからビデオ情報を取得する際に、ソースフィルタが不正な値を返した場合に表示されるエラー通知である。スクリプトの問題や、ソースファイルの破損、フィルタの設定ミスなどを検出して報告する。

**業務上の目的・背景**：StaxRipではAviSynth/VapourSynthスクリプトを使用して動画を読み込む。ソースフィルタ（LWLibavSource、FFVideoSource等）がビデオパラメータを正しく取得できない場合、後続のエンコード処理が正常に動作しない。問題を早期に検出し、ユーザーに完全なスクリプト内容を提示することで、デバッグを容易にする。

**通知の送信タイミング**：UpdateSourceParametersメソッドでソーススクリプトから情報を取得しようとした際に、p.SourceScript.GetInfo()の呼び出しで例外が発生した場合に表示される。

**通知の受信者**：現在操作中のユーザー（アプリケーションの操作者）に対してモーダルダイアログとして直接表示される。

**通知内容の概要**：「Source filter returned invalid parameters」というタイトルと共に、問題のあるスクリプトの完全な内容が本文として表示される。

**期待されるアクション**：ユーザーは通知を確認し、表示されたスクリプト内容を基にソースフィルタの設定を見直す。ソースファイルの確認、フィルタプラグインの更新、または代替フィルタの使用を検討する。

## 通知種別

アプリ内通知（モーダルダイアログ / TaskDialog）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー操作をブロック） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

本通知はUIスレッド上でモーダルダイアログとして表示されるため、送信先決定ロジックは存在しない。操作中のユーザーに直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | TaskDialog |
| アイコン | Error（エラーアイコン） |
| タイトル | Source filter returned invalid parameters |
| ボタン | OK |
| コピーボタン | あり |

### 本文テンプレート

```
{スクリプトの完全な内容}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| スクリプト内容 | 問題のあるスクリプトの完全な内容 | p.SourceScript.GetFullScript() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | UpdateSourceParametersメソッドでのソーススクリプト情報取得 | p.SourceScript.GetInfo()で例外が発生 | ソースフィルタが無効なパラメータを返した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| p.SourceScriptがNullの場合 | ソーススクリプトが設定されていない場合は処理をスキップ |
| GetInfo()が正常に完了した場合 | 例外が発生しなければ通知されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[UpdateSourceParameters呼び出し] --> B{p.SourceScript Is Nothing?}
    B -->|Yes| C[Exit Sub]
    B -->|No| D[Try ブロック開始]
    D --> E[p.SourceScript.GetInfo呼び出し]
    E --> F{例外発生?}
    F -->|No| G[パラメータ設定]
    G --> H[処理完了]
    F -->|Yes| I[Catch ブロック]
    I --> J[MsgError表示]
    J --> K[AbortException スロー]
    C --> L[終了]
    H --> L
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データソース | 用途 | 備考 |
|-----------|------|------|
| p.SourceScript | ソーススクリプトオブジェクト | プロジェクト設定 |
| p.SourceScript.GetInfo() | ビデオ情報取得 | ServerInfo構造体を返す |
| p.SourceScript.GetFullScript() | スクリプト全文取得 | 通知メッセージに使用 |

### 更新対象

本通知の発火時点では更新処理は行われない。処理は中断される。

| 更新対象 | 操作 | 概要 |
|---------|------|------|
| p.SourceWidth | 設定予定 | 幅（例外発生により未設定） |
| p.SourceHeight | 設定予定 | 高さ（例外発生により未設定） |
| p.SourceSeconds | 設定予定 | 長さ（例外発生により未設定） |
| p.SourceFrameRate | 設定予定 | フレームレート（例外発生により未設定） |
| p.SourceFrames | 設定予定 | フレーム数（例外発生により未設定） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ソースフィルタエラー | フィルタが無効なパラメータを返す | MsgError表示後、AbortExceptionをスロー |
| ファイル読み取りエラー | ソースファイルが破損または読み取り不可 | 同様にMsgError表示 |
| フィルタプラグインエラー | プラグインが正しく動作しない | 同様にMsgError表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 本通知は外部への送信を行わないため、情報漏洩のリスクはない
- スクリプト内容にはファイルパスが含まれる可能性があるが、ローカル表示のみのため問題なし

## 備考

- 本通知はVB.NETのMsgError関数を使用して実装されている
- 通知後にAbortExceptionがスローされ、処理が中断される
- スクリプト内容が表示されるため、ユーザーはデバッグに必要な情報を得られる
- MsgErrorはコピーボタン付きのダイアログを表示する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

VideoScript関連クラスとServerInfo構造体を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | VideoScriptクラス、GetInfo()、GetFullScript()メソッド |
| 1-2 | FrameServer.vb | `Source/Video/FrameServer.vb` | ServerInfo構造体の定義 |

**読解のコツ**: GetInfo()はフレームサーバーを使用してスクリプトを実行し、ビデオ情報を取得。例外はスクリプトの実行エラーや無効なパラメータ値を示す。

#### Step 2: エントリーポイントを理解する

ソースパラメータ更新処理の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | UpdateSourceParametersメソッド（行5681-5696） |

**主要処理フロー**:
1. **行5682**: p.SourceScriptのNullチェック
2. **行5684**: Tryブロック開始
3. **行5685**: p.SourceScript.GetInfo()呼び出し
4. **行5687-5691**: Width, Height, Seconds, FrameRate, Framesの設定
5. **行5692-5695**: Catchブロックと通知表示（本通知の発火点）
6. **行5693**: MsgError表示
7. **行5694**: AbortExceptionスロー

#### Step 3: 通知表示関数を理解する

MsgError関数の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgError関数（行1222-1241） |

**主要処理フロー**:
- **行1222**: MsgError関数定義
- **行1236**: ShowCopyButton = True

### プログラム呼び出し階層図

```
UpdateSourceParameters()
    │
    ├─ [p.SourceScript Is Nothing]
    │      └─ Exit Sub
    │
    └─ [Try ブロック]
           │
           ├─ p.SourceScript.GetInfo()
           │      │
           │      ├─ FrameServerFactory.Create()
           │      │      └─ フレームサーバー生成
           │      │
           │      └─ ServerInfo取得
           │             │
           │             ├─ [成功]
           │             │      │
           │             │      ├─ p.SourceWidth = info.Width
           │             │      ├─ p.SourceHeight = info.Height
           │             │      ├─ p.SourceSeconds = CInt(...)
           │             │      ├─ p.SourceFrameRate = info.FrameRate
           │             │      └─ p.SourceFrames = info.FrameCount
           │             │
           │             └─ [失敗 - 例外発生]
           │
           └─ [Catch ブロック]
                  │
                  ├─ MsgError() [MainModule]
                  │      │
                  │      ├─ title: "Source filter returned invalid parameters"
                  │      └─ content: p.SourceScript.GetFullScript()
                  │
                  └─ Throw New AbortException()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

p.SourceScript ─────────▶ GetInfo() ──────────▶ ServerInfo
        │                     │
        │                     ├─ [成功]
        │                     │      │
        │                     │      ▼
        │                     │  パラメータ設定
        │                     │      │
        │                     │      ▼
        │                     │  p.SourceWidth, Height等 更新
        │                     │
        │                     └─ [失敗 - 例外]
        │                            │
        │                            ▼
        │                     GetFullScript()
        │                            │
        │                            ▼
        │                     MsgError() ──▶ エラーダイアログ表示
        │                            │
        │                            ▼
        │                     AbortException ──▶ 処理中断
        │
        └─ スクリプト内容 ──▶ エラーダイアログ本文
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォームとソースパラメータ更新 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数を含む汎用モジュール |
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | ビデオスクリプト管理 |
| FrameServer.vb | `Source/Video/FrameServer.vb` | ソース | フレームサーバーとServerInfo構造体 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ダイアログ表示のUIコンポーネント |
